/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.rest.impl;

import io.apiman.common.logging.ApimanLoggerFactory;
import io.apiman.common.logging.IApimanLogger;
import io.apiman.manager.api.beans.download.DownloadBean;
import io.apiman.manager.api.beans.download.DownloadType;
import io.apiman.manager.api.beans.system.SystemStatusBean;
import io.apiman.manager.api.config.Version;
import io.apiman.manager.api.core.IDownloadManager;
import io.apiman.manager.api.core.IStorage;
import io.apiman.manager.api.core.exceptions.StorageException;
import io.apiman.manager.api.exportimport.json.JsonExportWriter;
import io.apiman.manager.api.exportimport.manager.StorageExporter;
import io.apiman.manager.api.exportimport.write.IExportWriter;
import io.apiman.manager.api.rest.ISystemResource;
import io.apiman.manager.api.rest.exceptions.NotAuthorizedException;
import io.apiman.manager.api.rest.exceptions.SystemErrorException;
import io.apiman.manager.api.security.ISecurityContext;
import io.apiman.manager.api.service.ImportExportService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.BooleanUtils;

@ApplicationScoped
public class SystemResourceImpl
implements ISystemResource {
    private IStorage storage;
    private ISecurityContext securityContext;
    private Version version;
    private StorageExporter exporter;
    private IDownloadManager downloadManager;
    private ImportExportService importExportService;
    @Context
    private HttpServletRequest request;

    @Inject
    public SystemResourceImpl(IStorage storage, ISecurityContext securityContext, Version version, StorageExporter exporter, IDownloadManager downloadManager, ImportExportService importExportService) {
        this.storage = storage;
        this.securityContext = securityContext;
        this.version = version;
        this.exporter = exporter;
        this.downloadManager = downloadManager;
        this.importExportService = importExportService;
    }

    public SystemResourceImpl() {
    }

    public SystemStatusBean getStatus() {
        SystemStatusBean rval = new SystemStatusBean();
        rval.setId("apiman-manager-api");
        rval.setName("API Manager REST API");
        rval.setDescription("The API Manager REST API is used by the API Manager UI to get stuff done. You can use it to automate any API Management task you wish. For example, create new Organizations, Plans, Clients, and APIs.");
        rval.setMoreInfo("https://www.apiman.io/latest/api-manager-restdocs.html");
        rval.setUp(this.storage != null);
        if (this.version != null) {
            rval.setVersion(this.version.getVersionString());
            rval.setBuiltOn(this.version.getVersionDate());
        }
        return rval;
    }

    public Response exportData(String download) throws NotAuthorizedException {
        this.securityContext.checkAdminPermissions();
        if (BooleanUtils.toBoolean((String)download)) {
            try {
                DownloadBean dbean = this.downloadManager.createDownload(DownloadType.exportJson, "/system/export");
                return Response.ok((Object)dbean, (String)"application/json").build();
            }
            catch (StorageException e) {
                throw new SystemErrorException((Throwable)e);
            }
        }
        return this.exportData();
    }

    public Response exportData() {
        final IApimanLogger exportLogger = ApimanLoggerFactory.getLogger(IExportWriter.class);
        StreamingOutput stream = new StreamingOutput(){

            public void write(OutputStream os) throws IOException, WebApplicationException {
                JsonExportWriter writer = new JsonExportWriter(os, exportLogger);
                SystemResourceImpl.this.exporter.init((IExportWriter)writer);
                SystemResourceImpl.this.exporter.export();
                os.flush();
            }
        };
        return Response.ok((Object)stream, (String)"application/json").header("Content-Disposition", (Object)"attachment; filename=api-manager-export.json").build();
    }

    public Response importData() throws NotAuthorizedException {
        File tempFile;
        this.securityContext.checkAdminPermissions();
        try {
            tempFile = File.createTempFile("apiman_import", ".json");
            tempFile.deleteOnExit();
            ServletInputStream data = this.request.getInputStream();
            FileUtils.copyInputStreamToFile((InputStream)data, (File)tempFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        final File importFile = tempFile;
        StreamingOutput stream = new StreamingOutput(){

            public void write(OutputStream output) throws IOException, WebApplicationException {
                final PrintWriter writer = new PrintWriter(output);
                IApimanLogger logger = new IApimanLogger(){

                    public void warn(String message) {
                        writer.println("WARN: " + message);
                        writer.flush();
                    }

                    public void warn(String message, Object ... args) {
                        this.warn(MessageFormat.format(message, args));
                    }

                    public void trace(String message) {
                        writer.println("TRACE: " + message);
                        writer.flush();
                    }

                    public void trace(String message, Object ... args) {
                        this.trace(MessageFormat.format(message, args));
                    }

                    public void info(String message) {
                        writer.println("INFO: " + message);
                        writer.flush();
                    }

                    public void info(String message, Object ... args) {
                        this.info(MessageFormat.format(message, args));
                    }

                    public void error(String message, Throwable error) {
                        writer.println("ERROR: " + message);
                        error.printStackTrace(writer);
                        writer.flush();
                    }

                    public void error(Throwable error) {
                        writer.println("ERROR: " + error.getMessage());
                        error.printStackTrace(writer);
                        writer.flush();
                    }

                    public void error(Throwable error, String message, Object ... args) {
                        this.error(MessageFormat.format(message, args), error);
                    }

                    public void debug(String message) {
                        writer.println("DEBUG: " + message);
                        writer.flush();
                    }

                    public void debug(String message, Object ... args) {
                        this.debug(MessageFormat.format(message, args));
                    }
                };
                try {
                    SystemResourceImpl.this.storage.beginTx();
                    SystemResourceImpl.this.importExportService.fullImport(importFile, logger);
                    SystemResourceImpl.this.storage.commitTx();
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                    SystemResourceImpl.this.storage.rollbackTx();
                    throw new IOException(e);
                }
                finally {
                    writer.flush();
                    writer.close();
                    output.close();
                }
            }
        };
        return Response.ok((Object)stream).build();
    }
}

