/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.rest.impl;

import io.apiman.manager.api.beans.BeanUtils;
import io.apiman.manager.api.beans.policies.PolicyDefinitionBean;
import io.apiman.manager.api.beans.policies.UpdatePolicyDefinitionBean;
import io.apiman.manager.api.beans.summary.PolicyDefinitionSummaryBean;
import io.apiman.manager.api.beans.summary.PolicyFormType;
import io.apiman.manager.api.core.IStorage;
import io.apiman.manager.api.core.IStorageQuery;
import io.apiman.manager.api.core.exceptions.StorageException;
import io.apiman.manager.api.rest.IPolicyDefinitionResource;
import io.apiman.manager.api.rest.exceptions.AbstractRestException;
import io.apiman.manager.api.rest.exceptions.NotAuthorizedException;
import io.apiman.manager.api.rest.exceptions.PolicyDefinitionAlreadyExistsException;
import io.apiman.manager.api.rest.exceptions.PolicyDefinitionNotFoundException;
import io.apiman.manager.api.rest.exceptions.SystemErrorException;
import io.apiman.manager.api.rest.exceptions.i18n.Messages;
import io.apiman.manager.api.rest.exceptions.util.ExceptionFactory;
import io.apiman.manager.api.security.ISecurityContext;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.transaction.Transactional;

@ApplicationScoped
@Transactional
public class PolicyDefinitionResourceImpl
implements IPolicyDefinitionResource {
    private IStorage storage;
    private IStorageQuery query;
    private ISecurityContext securityContext;

    @Inject
    public PolicyDefinitionResourceImpl(IStorage storage, IStorageQuery query, ISecurityContext securityContext) {
        this.storage = storage;
        this.query = query;
        this.securityContext = securityContext;
    }

    public PolicyDefinitionResourceImpl() {
    }

    public List<PolicyDefinitionSummaryBean> list() {
        try {
            return this.query.listPolicyDefinitions();
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    public PolicyDefinitionBean create(PolicyDefinitionBean bean) throws PolicyDefinitionAlreadyExistsException, NotAuthorizedException {
        this.securityContext.checkAdminPermissions();
        if (bean.getId() == null || bean.getId().trim().isEmpty()) {
            bean.setId(BeanUtils.idFromName((String)bean.getName()));
        } else {
            bean.setId(BeanUtils.idFromName((String)bean.getId()));
        }
        try {
            if (this.storage.getPolicyDefinition(bean.getId()) != null) {
                throw ExceptionFactory.policyDefAlreadyExistsException((String)bean.getName());
            }
            if (bean.getFormType() == null) {
                bean.setFormType(PolicyFormType.Default);
            }
            this.storage.createPolicyDefinition(bean);
            return bean;
        }
        catch (AbstractRestException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    public PolicyDefinitionBean get(String policyDefinitionId) throws PolicyDefinitionNotFoundException {
        try {
            PolicyDefinitionBean bean = this.storage.getPolicyDefinition(policyDefinitionId);
            if (bean == null) {
                throw ExceptionFactory.policyDefNotFoundException((String)policyDefinitionId);
            }
            return bean;
        }
        catch (AbstractRestException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    public void update(String policyDefinitionId, UpdatePolicyDefinitionBean bean) throws PolicyDefinitionNotFoundException, NotAuthorizedException {
        this.securityContext.checkAdminPermissions();
        try {
            PolicyDefinitionBean pdb = this.storage.getPolicyDefinition(policyDefinitionId);
            if (pdb == null) {
                throw ExceptionFactory.policyDefNotFoundException((String)policyDefinitionId);
            }
            if (pdb.getPluginId() != null) {
                throw new SystemErrorException(Messages.i18n.format("CannotUpdatePluginPolicyDef", new Object[0]));
            }
            if (bean.getName() != null) {
                pdb.setName(bean.getName());
            }
            if (bean.getDescription() != null) {
                pdb.setDescription(bean.getDescription());
            }
            if (bean.getIcon() != null) {
                pdb.setIcon(bean.getIcon());
            }
            this.storage.updatePolicyDefinition(pdb);
        }
        catch (AbstractRestException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    public void delete(String policyDefinitionId) throws PolicyDefinitionNotFoundException, NotAuthorizedException {
        this.securityContext.checkAdminPermissions();
        try {
            PolicyDefinitionBean pdb = this.storage.getPolicyDefinition(policyDefinitionId);
            if (pdb == null) {
                throw ExceptionFactory.policyDefNotFoundException((String)policyDefinitionId);
            }
            if (pdb.getPluginId() != null) {
                throw new SystemErrorException(Messages.i18n.format("CannotDeletePluginPolicyDef", new Object[0]));
            }
            this.storage.deletePolicyDefinition(pdb);
        }
        catch (AbstractRestException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SystemErrorException((Throwable)e);
        }
    }
}

