/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.rest.impl;

import io.apiman.common.logging.ApimanLoggerFactory;
import io.apiman.common.logging.IApimanLogger;
import io.apiman.manager.api.beans.actions.ActionBean;
import io.apiman.manager.api.beans.actions.ContractActionDto;
import io.apiman.manager.api.beans.contracts.ContractBean;
import io.apiman.manager.api.beans.contracts.ContractStatus;
import io.apiman.manager.api.beans.idm.PermissionType;
import io.apiman.manager.api.beans.orgs.OrganizationBean;
import io.apiman.manager.api.core.IStorage;
import io.apiman.manager.api.rest.IActionResource;
import io.apiman.manager.api.rest.exceptions.ActionException;
import io.apiman.manager.api.rest.exceptions.NotAuthorizedException;
import io.apiman.manager.api.rest.exceptions.util.ExceptionFactory;
import io.apiman.manager.api.rest.impl.util.DataAccessUtilMixin;
import io.apiman.manager.api.security.ISecurityContext;
import io.apiman.manager.api.service.ActionService;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.transaction.Transactional;

@ApplicationScoped
@Transactional
public class ActionResourceImpl
implements IActionResource,
DataAccessUtilMixin {
    private final IApimanLogger LOGGER = ApimanLoggerFactory.getLogger(ActionResourceImpl.class);
    private IStorage storage;
    private ISecurityContext securityContext;
    private ActionService actionService;

    @Inject
    public ActionResourceImpl(IStorage storage, ISecurityContext securityContext, ActionService actionService) {
        this.storage = storage;
        this.securityContext = securityContext;
        this.actionService = actionService;
    }

    public ActionResourceImpl() {
    }

    public void performAction(ActionBean action) throws ActionException, NotAuthorizedException {
        switch (action.getType()) {
            case publishAPI: {
                this.publishApi(action);
                return;
            }
            case retireAPI: {
                this.retireApi(action);
                return;
            }
            case registerClient: {
                this.registerClient(action);
                return;
            }
            case unregisterClient: {
                this.unregisterClient(action);
                return;
            }
            case lockPlan: {
                this.lockPlan(action);
                return;
            }
        }
        throw ExceptionFactory.actionException((String)("Action type not supported: " + action.getType().toString()));
    }

    public void approveContract(ContractActionDto action) throws ActionException, NotAuthorizedException {
        this.LOGGER.debug("Request approve contract {0} from {1}", new Object[]{action, this.securityContext.getCurrentUser()});
        ContractBean contract = (ContractBean)this.tryAction(() -> this.storage.getContract(action.getContractId()));
        OrganizationBean planOrg = contract.getPlan().getPlan().getOrganization();
        this.securityContext.checkPermissions(PermissionType.planAdmin, planOrg.getId());
        if (action.getStatus() == ContractStatus.Rejected) {
            this.actionService.rejectContract(action, this.securityContext.getCurrentUser());
        } else {
            this.actionService.approveContract(action, this.securityContext.getCurrentUser());
        }
    }

    private void lockPlan(ActionBean action) throws ActionException, NotAuthorizedException {
        this.LOGGER.debug("Request to lock plan {0} from {1}", new Object[]{action, this.securityContext.getCurrentUser()});
        this.securityContext.checkPermissions(PermissionType.planAdmin, action.getOrganizationId());
        this.actionService.lockPlan(action.getOrganizationId(), action.getEntityId(), action.getEntityVersion());
    }

    private void unregisterClient(ActionBean action) throws ActionException, NotAuthorizedException {
        this.LOGGER.debug("Request to unregister client {0} from {1}", new Object[]{action, this.securityContext.getCurrentUser()});
        this.securityContext.checkPermissions(PermissionType.clientAdmin, action.getOrganizationId());
        this.actionService.unregisterClient(action.getOrganizationId(), action.getEntityId(), action.getEntityVersion());
    }

    private void registerClient(ActionBean action) throws ActionException, NotAuthorizedException {
        this.LOGGER.debug("Request to register client {0} from {1}", new Object[]{action, this.securityContext.getCurrentUser()});
        this.securityContext.checkPermissions(PermissionType.clientAdmin, action.getOrganizationId());
        this.actionService.registerClient(action.getOrganizationId(), action.getEntityId(), action.getEntityVersion());
    }

    private void retireApi(ActionBean action) throws ActionException, NotAuthorizedException {
        this.LOGGER.debug("Request to retire API {0} from {1}", new Object[]{action, this.securityContext.getCurrentUser()});
        this.securityContext.checkPermissions(PermissionType.apiAdmin, action.getOrganizationId());
        this.actionService.retireApi(action.getOrganizationId(), action.getEntityId(), action.getEntityVersion());
    }

    private void publishApi(ActionBean action) throws ActionException, NotAuthorizedException {
        this.LOGGER.debug("Request to publish API {0} from {1}", new Object[]{action, this.securityContext.getCurrentUser()});
        this.securityContext.checkPermissions(PermissionType.apiAdmin, action.getOrganizationId());
        this.actionService.publishApi(action.getOrganizationId(), action.getEntityId(), action.getEntityVersion());
    }
}

