/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.notifications.email.handlers;

import io.apiman.manager.api.beans.clients.ClientStatus;
import io.apiman.manager.api.beans.events.ClientVersionStatusEvent;
import io.apiman.manager.api.beans.events.IVersionedApimanEvent;
import io.apiman.manager.api.beans.idm.UserDto;
import io.apiman.manager.api.beans.notifications.EmailNotificationTemplate;
import io.apiman.manager.api.beans.notifications.dto.NotificationDto;
import io.apiman.manager.api.notifications.email.SimpleEmail;
import io.apiman.manager.api.notifications.email.SimpleMailNotificationService;
import io.apiman.manager.api.notifications.email.handlers.INotificationHandler;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Initialized;
import javax.enterprise.event.Observes;
import javax.inject.Inject;

@ApplicationScoped
public class ClientAppRegisteredEmailNotification
implements INotificationHandler<ClientVersionStatusEvent> {
    private final SimpleMailNotificationService mailNotificationService;

    @Inject
    public ClientAppRegisteredEmailNotification(SimpleMailNotificationService mailNotificationService) {
        this.mailNotificationService = mailNotificationService;
    }

    public void init(@Observes @Initialized(value=ApplicationScoped.class) Object init) {
    }

    @Override
    public void handle(NotificationDto<ClientVersionStatusEvent> notification, Map<String, Object> defaultTemplateMap) {
        UserDto recipient = notification.getRecipient();
        this.mailNotificationService.findTemplateFor(notification.getReason(), recipient.getLocale()).ifPresentOrElse(template -> this.send(recipient, (EmailNotificationTemplate)template, defaultTemplateMap), () -> this.warnOnce(recipient, (NotificationDto<IVersionedApimanEvent>)notification));
    }

    void send(UserDto recipient, EmailNotificationTemplate template, Map<String, Object> defaultTemplateMap) {
        SimpleEmail mail = SimpleEmail.builder().setRecipient(recipient).setTemplate(template).setTemplateVariables(defaultTemplateMap).build();
        this.mailNotificationService.send(mail);
    }

    @Override
    public boolean wants(NotificationDto<? extends IVersionedApimanEvent> raw) {
        if (raw.getReason().equals("apiman.client.status_change")) {
            NotificationDto<? extends IVersionedApimanEvent> notification = raw;
            ClientVersionStatusEvent event = (ClientVersionStatusEvent)notification.getPayload();
            return event.getNewStatus() == ClientStatus.Registered && event.getPreviousStatus() == ClientStatus.AwaitingApproval;
        }
        return false;
    }
}

