/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.notifications.email;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.apiman.manager.api.beans.events.ApimanBuilderMixin;
import io.apiman.manager.api.beans.idm.UserDto;
import io.apiman.manager.api.beans.notifications.EmailNotificationTemplate;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.StringJoiner;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonDeserialize(builder=Builder.class)
public class SimpleEmail {
    private String toName;
    private String toEmail;
    private Locale locale;
    private Map<String, String> headers;
    private EmailNotificationTemplate template;
    private Map<String, Object> templateVariables;

    SimpleEmail(String toName, String toEmail, Locale locale, Map<String, String> headers, EmailNotificationTemplate template, Map<String, Object> templateVariables) {
        this.toName = toName;
        this.toEmail = toEmail;
        this.locale = locale;
        this.headers = headers;
        this.template = template;
        this.templateVariables = templateVariables;
    }

    public SimpleEmail() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getToName() {
        return this.toName;
    }

    public String getToEmail() {
        return this.toEmail;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public EmailNotificationTemplate getTemplate() {
        return this.template;
    }

    public Map<String, Object> getTemplateVariables() {
        return this.templateVariables;
    }

    public String toString() {
        return new StringJoiner(", ", SimpleEmail.class.getSimpleName() + "[", "]").add("toName='" + this.toName + "'").add("toEmail='" + this.toEmail + "'").add("headers=" + this.headers).add("template=" + this.template).add("templateVariables=" + this.templateVariables).toString();
    }

    @JsonPOJOBuilder(withPrefix="set")
    public static class Builder
    implements ApimanBuilderMixin {
        @NotBlank
        private String toName;
        @NotBlank
        private String toEmail;
        @NotNull
        private Locale locale;
        @NotNull
        private Map<String, String> headers = Collections.emptyMap();
        @NotNull
        private EmailNotificationTemplate template;
        @NotNull
        private Map<String, Object> templateVariables;
        @Nullable
        private UserDto userDto;

        Builder() {
        }

        public Builder setRecipient(@org.jetbrains.annotations.NotNull UserDto userDto) {
            this.userDto = userDto;
            return this;
        }

        public Builder setToName(@NotBlank String toName) {
            this.toName = toName;
            return this;
        }

        public Builder setToEmail(@NotBlank String toEmail) {
            this.toEmail = toEmail;
            return this;
        }

        public Builder setTemplate(EmailNotificationTemplate template) {
            this.template = template;
            return this;
        }

        public Builder setLocale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public Builder setTemplateVariables(Map<String, Object> templateVariables) {
            this.templateVariables = templateVariables;
            return this;
        }

        public Builder setHeaders(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public SimpleEmail build() {
            if (this.userDto != null) {
                this.toName = this.userDto.getFullName();
                this.toEmail = this.userDto.getEmail();
                this.locale = this.userDto.getLocale();
            }
            this.beanValidate(this);
            return new SimpleEmail(this.toName, this.toEmail, this.locale, this.headers, this.template, this.templateVariables);
        }

        public String toString() {
            return new StringJoiner(", ", Builder.class.getSimpleName() + "[", "]").add("toName='" + this.toName + "'").add("toEmail='" + this.toEmail + "'").add("locale='" + this.locale + "'").add("headers=" + this.headers).add("template=" + this.template).add("templateVariables=" + this.templateVariables).add("userDto=" + this.userDto).toString();
        }
    }
}

