/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.notifications.email;

import io.apiman.common.logging.ApimanLoggerFactory;
import io.apiman.common.logging.IApimanLogger;
import io.apiman.manager.api.notifications.email.IEmailSender;
import io.apiman.manager.api.notifications.email.SmtpEmailConfiguration;
import java.util.Map;
import javax.mail.Authenticator;
import org.apache.commons.mail.DefaultAuthenticator;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.apache.commons.mail.SimpleEmail;

public class EmailSender
implements IEmailSender {
    private final IApimanLogger LOGGER = ApimanLoggerFactory.getLogger(EmailSender.class);
    private final SmtpEmailConfiguration emailConfiguration;

    public EmailSender(SmtpEmailConfiguration emailConfiguration) {
        this.emailConfiguration = emailConfiguration;
        this.LOGGER.debug("EmailSender config: {0}", new Object[]{emailConfiguration});
    }

    @Override
    public void sendPlaintext(String toEmail, String toName, String subject, String body, Map<String, String> headers) throws IEmailSender.EmailException {
        try {
            SimpleEmail email = new SimpleEmail();
            this.setCommonConfigElements((Email)email, toName, toEmail, subject, headers);
            email.setMsg(body);
            email.send();
        }
        catch (EmailException e) {
            throw new IEmailSender.EmailException(e);
        }
        this.LOGGER.debug("Plaintext-only email notification sent. \nto: {0} \ntoName: {1} \nsubject: {2} \nbody: {3} \nheaders: {4}", new Object[]{toEmail, toName, subject, body, headers});
    }

    @Override
    public void sendHtml(String toEmail, String toName, String subject, String htmlBody, String plainBody, Map<String, String> headers) throws IEmailSender.EmailException {
        try {
            HtmlEmail email = new HtmlEmail();
            this.setCommonConfigElements((Email)email, toName, toEmail, subject, headers);
            email.setHtmlMsg(htmlBody);
            email.setTextMsg(plainBody);
            email.send();
        }
        catch (EmailException e) {
            throw new IEmailSender.EmailException(e);
        }
        this.LOGGER.debug("HTML email notification sent. \nto: {0} \ntoName: {1} \nsubject: {2} \nHTML body: {3} \nplain body: {4} \nheaders: {5}", new Object[]{toEmail, toName, subject, htmlBody, plainBody, headers});
    }

    private void setCommonConfigElements(Email email, String toName, String toEmail, String subject, Map<String, String> headers) throws EmailException {
        email.setCharset("utf-8");
        email.addTo(toEmail, toName);
        email.setFrom(this.emailConfiguration.getFromEmail(), this.emailConfiguration.getFromName());
        email.setSubject(subject);
        email.setHostName(this.emailConfiguration.getHost());
        email.setSmtpPort(this.emailConfiguration.getPort());
        email.setAuthenticator((Authenticator)new DefaultAuthenticator(this.emailConfiguration.getUsername(), this.emailConfiguration.getPassword()));
        email.getHeaders().putAll(headers);
        if (this.emailConfiguration.getStartTLSMode() == SmtpEmailConfiguration.StartTLSEnum.REQUIRED || this.emailConfiguration.getStartTLSMode() == SmtpEmailConfiguration.StartTLSEnum.OPTIONAL) {
            email.setStartTLSEnabled(true);
            if (this.emailConfiguration.getStartTLSMode() == SmtpEmailConfiguration.StartTLSEnum.REQUIRED) {
                email.setStartTLSRequired(true);
            }
        } else if (this.emailConfiguration.getStartTLSMode() == SmtpEmailConfiguration.StartTLSEnum.DISABLED) {
            email.setStartTLSRequired(false);
        }
        if (this.emailConfiguration.isSsl()) {
            email.setSslSmtpPort(Integer.toString(this.emailConfiguration.getPort()));
            email.setSSLOnConnect(true);
        } else {
            email.setSSLOnConnect(false);
        }
    }
}

