/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.events;

import io.apiman.common.logging.ApimanLoggerFactory;
import io.apiman.common.logging.IApimanLogger;
import io.apiman.manager.api.beans.events.ApimanEvent;
import io.apiman.manager.api.beans.events.ApimanEventHeaders;
import io.apiman.manager.api.beans.events.IVersionedApimanEvent;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantLock;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;

@ApplicationScoped
public class EventService {
    private static final IApimanLogger LOGGER = ApimanLoggerFactory.getLogger(EventService.class);
    private Event<IVersionedApimanEvent> eventDispatcher;
    private boolean active = true;
    private final ReentrantLock lock = new ReentrantLock();

    @Inject
    public EventService(Event<IVersionedApimanEvent> eventDispatcher) {
        this.eventDispatcher = eventDispatcher;
    }

    public EventService() {
    }

    public boolean isActive() {
        return this.active;
    }

    public EventService activate() {
        this.lock.lock();
        this.active = true;
        this.lock.unlock();
        return this;
    }

    public EventService deactivate() {
        this.lock.lock();
        this.active = false;
        this.lock.unlock();
        return this;
    }

    public EventService lock() {
        this.lock.lock();
        return this;
    }

    public EventService unlock() {
        this.lock.unlock();
        return this;
    }

    public <E extends IVersionedApimanEvent> E fireEvent(E event) {
        event.getHeaders().setEventVersion(this.getEventVersion(event)).setType(this.getType(event)).setTime(OffsetDateTime.now());
        if (this.isActive()) {
            this.eventDispatcher.fire(event);
            LOGGER.debug("Fired event: {0}", new Object[]{event});
        } else {
            LOGGER.debug("EventService is deactivated. Event will be discarded: {0}");
        }
        return event;
    }

    private long getEventVersion(IVersionedApimanEvent event) {
        ApimanEventHeaders headers = event.getHeaders();
        if (headers.getEventVersion() <= 0L) {
            if (event.getClass().isAnnotationPresent(ApimanEvent.class)) {
                ApimanEvent ev = event.getClass().getAnnotation(ApimanEvent.class);
                return ev.version();
            }
            throw new IllegalStateException("No version set for @ApimanEvent event: " + event.getClass().getCanonicalName());
        }
        return headers.getEventVersion();
    }

    private String getType(IVersionedApimanEvent event) {
        String currentValue = event.getHeaders().getType();
        if (StringUtils.isEmpty((CharSequence)currentValue) && event.getClass().isAnnotationPresent(ApimanEvent.class)) {
            ApimanEvent ev = event.getClass().getAnnotation(ApimanEvent.class);
            currentValue = ev.name();
        }
        return Optional.ofNullable(currentValue).filter(s -> !s.isBlank()).orElse(event.getClass().getCanonicalName());
    }
}

