/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.implementations.support.delegates;

import io.annot8.api.data.Content;
import io.annot8.api.properties.Properties;
import java.util.Optional;
import java.util.function.Supplier;

public class DelegateContentBuilder<C extends Content<D>, D>
implements Content.Builder<C, D> {
    private final Content.Builder<C, D> delegate;

    public DelegateContentBuilder(Content.Builder<C, D> delegate) {
        this.delegate = delegate;
    }

    public Content.Builder<C, D> withDescription(String description) {
        this.delegate.withDescription(description);
        return this;
    }

    public Content.Builder<C, D> withData(Supplier<D> data) {
        this.delegate.withData(data);
        return this;
    }

    public Content.Builder<C, D> from(C from) {
        this.delegate.from(from);
        return this;
    }

    public Content.Builder<C, D> withId(String id) {
        this.delegate.withId(id);
        return this;
    }

    public Content.Builder<C, D> withProperty(String key, Object value) {
        this.delegate.withProperty(key, value);
        return this;
    }

    public Content.Builder<C, D> withPropertyIfPresent(String key, Optional<?> value) {
        value.ifPresent(o -> this.delegate.withProperty(key, o));
        return this;
    }

    public Content.Builder<C, D> withoutProperty(String key, Object value) {
        this.delegate.withoutProperty(key, value);
        return this;
    }

    public Content.Builder<C, D> withoutProperty(String key) {
        this.delegate.withoutProperty(key);
        return this;
    }

    public Content.Builder<C, D> withProperties(Properties properties) {
        this.delegate.withProperties(properties);
        return this;
    }

    public C save() {
        return (C)((Content)this.delegate.save());
    }
}

