/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.support;

import hudson.Extension;
import io.alauda.jenkins.devops.support.KubernetesCluster;
import io.alauda.jenkins.devops.support.KubernetesClusterConfigurationListener;
import io.alauda.jenkins.devops.support.client.Clients;
import io.alauda.jenkins.devops.support.exception.KubernetesClientException;
import io.alauda.jenkins.devops.support.utils.SyncPluginConfigurationCompatiblilityMigrater;
import io.kubernetes.client.ApiClient;
import io.kubernetes.client.Configuration;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.GlobalConfiguration;
import org.kohsuke.stapler.DataBoundSetter;

@Extension(ordinal=203.0)
public class KubernetesClusterConfiguration
extends GlobalConfiguration {
    private static final Logger logger = Logger.getLogger(KubernetesClusterConfiguration.class.getName());
    private List<KubernetesCluster> k8sClusters = new LinkedList<KubernetesCluster>();

    public static KubernetesClusterConfiguration get() {
        return (KubernetesClusterConfiguration)((Object)GlobalConfiguration.all().get(KubernetesClusterConfiguration.class));
    }

    public KubernetesClusterConfiguration() {
        this.load();
        KubernetesCluster clusterMigrateFromSync = SyncPluginConfigurationCompatiblilityMigrater.migrateConfigurationFromSyncPlugin();
        if (clusterMigrateFromSync != null) {
            clusterMigrateFromSync.setDefaultCluster(true);
            clusterMigrateFromSync.setManagerCluster(true);
            this.setCluster(clusterMigrateFromSync);
            return;
        }
        if (this.k8sClusters.size() == 0) {
            KubernetesCluster cluster = new KubernetesCluster();
            cluster.setDefaultCluster(true);
            cluster.setManagerCluster(true);
            this.setCluster(cluster);
        } else {
            this.triggerEvents(this.k8sClusters.get(0));
        }
    }

    public KubernetesCluster getCluster() {
        if (this.k8sClusters == null || this.k8sClusters.size() == 0) {
            return null;
        }
        return this.k8sClusters.get(0);
    }

    @DataBoundSetter
    public void setCluster(KubernetesCluster cluster) {
        KubernetesCluster currentCluster;
        if (this.k8sClusters == null) {
            this.k8sClusters = new LinkedList<KubernetesCluster>();
        }
        if ((currentCluster = this.getCluster()) != null && currentCluster.equals((Object)cluster)) {
            return;
        }
        this.k8sClusters.clear();
        this.k8sClusters.add(cluster);
        this.save();
        this.triggerEvents(cluster);
    }

    private void triggerEvents(KubernetesCluster cluster) {
        try {
            ApiClient client = Clients.createClientFromCluster(cluster);
            client.getHttpClient().setReadTimeout(0L, TimeUnit.SECONDS);
            Configuration.setDefaultApiClient((ApiClient)client);
            new Thread(() -> this.triggerConfigChangeEvent(cluster, client)).start();
        }
        catch (KubernetesClientException e) {
            e.printStackTrace();
            logger.log(Level.SEVERE, String.format("Unable to create client from cluster %s, reason %s", cluster.getMasterUrl(), e.getMessage()));
            new Thread(() -> this.triggerConfigErrorEvent(cluster, e)).start();
        }
    }

    private void triggerConfigChangeEvent(KubernetesCluster cluster, ApiClient client) {
        KubernetesClusterConfigurationListener.all().forEach(listener -> new Thread(() -> listener.onConfigChange(cluster, client)).start());
    }

    private void triggerConfigErrorEvent(KubernetesCluster cluster, Throwable reason) {
        KubernetesClusterConfigurationListener.all().forEach(listener -> listener.onConfigError(cluster, reason));
    }
}

