/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.sync.util;

import com.cloudbees.hudson.plugins.folder.AbstractFolderProperty;
import com.cloudbees.hudson.plugins.folder.Folder;
import hudson.BulkChange;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Saveable;
import hudson.util.XStream2;
import io.alauda.devops.java.client.models.V1alpha1JenkinsBinding;
import io.alauda.devops.java.client.models.V1alpha1Pipeline;
import io.alauda.devops.java.client.models.V1alpha1PipelineConfig;
import io.alauda.devops.java.client.models.V1alpha1PipelineConfigSpec;
import io.alauda.devops.java.client.models.V1alpha1PipelineSource;
import io.alauda.devops.java.client.models.V1alpha1PipelineSourceGit;
import io.alauda.devops.java.client.models.V1alpha1PipelineSourceSvn;
import io.alauda.devops.java.client.models.V1alpha1PipelineStatus;
import io.alauda.devops.java.client.models.V1alpha1PipelineStatusBuilder;
import io.alauda.devops.java.client.models.V1alpha1PipelineStrategy;
import io.alauda.devops.java.client.models.V1alpha1PipelineStrategyJenkins;
import io.alauda.devops.java.client.utils.DeepCopyUtils;
import io.alauda.jenkins.devops.sync.AlaudaFolderProperty;
import io.alauda.jenkins.devops.sync.AlaudaSyncGlobalConfiguration;
import io.alauda.jenkins.devops.sync.client.Clients;
import io.alauda.jenkins.devops.sync.util.NamespaceName;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.filters.StringInputStream;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public abstract class AlaudaUtils {
    private static final Logger logger = Logger.getLogger(AlaudaUtils.class.getName());
    private static final String PLUGIN_NAME = "alauda-sync";
    private static String jenkinsPodNamespace = null;
    private static final DateTimeFormatter dateFormatter;

    private AlaudaUtils() {
    }

    public static boolean isPipelineStrategyPipeline(V1alpha1Pipeline pipeline) {
        if (pipeline.getSpec() == null) {
            logger.warning("bad input, null spec: " + pipeline);
            return false;
        }
        V1alpha1PipelineStrategy strategy = pipeline.getSpec().getStrategy();
        if (strategy == null) {
            logger.warning("bad input, null strategy: " + pipeline);
            return false;
        }
        V1alpha1PipelineStrategyJenkins jenkins = strategy.getJenkins();
        return jenkins != null && (StringUtils.isNotEmpty((String)jenkins.getJenkinsfile()) || StringUtils.isNotEmpty((String)jenkins.getJenkinsfilePath()));
    }

    public static boolean isPipelineStrategyPipelineConfig(V1alpha1PipelineConfig pc) {
        if (pc == null) {
            return false;
        }
        V1alpha1PipelineStrategy strategy = pc.getSpec().getStrategy();
        if (strategy == null) {
            return false;
        }
        V1alpha1PipelineStrategyJenkins jenkins = strategy.getJenkins();
        if (jenkins == null) {
            return false;
        }
        return StringUtils.isNotEmpty((String)jenkins.getJenkinsfile()) || StringUtils.isNotEmpty((String)jenkins.getJenkinsfilePath());
    }

    public static String jenkinsJobName(V1alpha1PipelineConfig pc) {
        String namespace = pc.getMetadata().getNamespace();
        String name = pc.getMetadata().getName();
        return AlaudaUtils.jenkinsJobName(namespace, name);
    }

    public static String jenkinsJobName(String namespace, String pipelineConfigName) {
        return namespace + "-" + pipelineConfigName;
    }

    public static String jenkinsJobFullName(V1alpha1PipelineConfig pc) {
        String jobName = (String)pc.getMetadata().getAnnotations().get("jenkins.alauda.io/job-path");
        if (StringUtils.isNotBlank((String)jobName)) {
            return jobName;
        }
        return pc.getMetadata().getNamespace() + "/" + AlaudaUtils.jenkinsJobName(pc);
    }

    public static ItemGroup getOrCreateFullNameParent(Jenkins activeJenkins, String fullName, String namespace) throws IOException {
        int idx = fullName.lastIndexOf(47);
        if (idx > 0) {
            String parentFullName = fullName.substring(0, idx);
            Item parent = activeJenkins.getItemByFullName(parentFullName);
            if (parent instanceof Folder) {
                Folder folder = (Folder)parent;
                AlaudaFolderProperty alaPro = (AlaudaFolderProperty)folder.getProperties().get(AlaudaFolderProperty.class);
                if (alaPro == null) {
                    folder.addProperty((AbstractFolderProperty)new AlaudaFolderProperty());
                } else {
                    alaPro.setDirty(false);
                }
                folder.save();
                return folder;
            }
            if (parent == null && parentFullName.equals(namespace)) {
                Folder folder = new Folder((ItemGroup)activeJenkins, namespace);
                folder.setDescription("Folder for the Alauda DevOps project: " + namespace);
                folder.addProperty((AbstractFolderProperty)new AlaudaFolderProperty());
                BulkChange bk = new BulkChange((Saveable)folder);
                StringInputStream jobStream = new StringInputStream(new XStream2().toXML((Object)folder));
                activeJenkins.createProjectFromXML(namespace, (InputStream)jobStream).save();
                bk.commit();
                parent = activeJenkins.getItemByFullName(namespace);
                if (parent instanceof ItemGroup) {
                    return (ItemGroup)parent;
                }
            } else {
                throw new IllegalArgumentException(String.format("cannot create folder %s", parentFullName));
            }
        }
        return activeJenkins;
    }

    public static String jenkinsJobDisplayName(V1alpha1PipelineConfig pc) {
        String namespace = pc.getMetadata().getNamespace();
        String name = pc.getMetadata().getName();
        return AlaudaUtils.jenkinsJobDisplayName(namespace, name);
    }

    public static String jenkinsJobDisplayName(String namespace, String pipelineConfigName) {
        return namespace + "/" + pipelineConfigName;
    }

    public static String getNamespacefromPodInputs() {
        return jenkinsPodNamespace;
    }

    public static void updateGitSourceUrl(V1alpha1PipelineConfig pipelineConfig, String gitUrl, String ref) {
        V1alpha1PipelineSource source = AlaudaUtils.getOrCreatePipelineSource(pipelineConfig);
        V1alpha1PipelineSourceGit git = source.getGit();
        if (git == null) {
            git = new V1alpha1PipelineSourceGit();
            source.setGit(git);
        }
        git.setUri(gitUrl);
        git.setRef(ref);
    }

    public static void updateSvnSourceUrl(V1alpha1PipelineConfig pipelineConfig, String svnUrl) {
        V1alpha1PipelineSource source = AlaudaUtils.getOrCreatePipelineSource(pipelineConfig);
        V1alpha1PipelineSourceSvn svn = source.getSvn();
        if (svn == null) {
            svn = new V1alpha1PipelineSourceSvn();
            source.setSvn(svn);
        }
        svn.setUri(svnUrl);
    }

    public static V1alpha1PipelineSource getOrCreatePipelineSource(V1alpha1PipelineConfig pipelineConfig) {
        V1alpha1PipelineSource source;
        V1alpha1PipelineConfigSpec spec = pipelineConfig.getSpec();
        if (spec == null) {
            spec = new V1alpha1PipelineConfigSpec();
            pipelineConfig.setSpec(spec);
        }
        if ((source = spec.getSource()) == null) {
            source = new V1alpha1PipelineSource();
            spec.setSource(source);
        }
        return source;
    }

    public static boolean isValidSource(V1alpha1PipelineSource source) {
        return AlaudaUtils.isValidGitSource(source) || AlaudaUtils.isValidSvnSource(source);
    }

    public static boolean isValidGitSource(V1alpha1PipelineSource source) {
        return source != null && source.getGit() != null && source.getGit().getUri() != null;
    }

    public static boolean isValidSvnSource(V1alpha1PipelineSource source) {
        return source != null && source.getSvn() != null && source.getSvn().getUri() != null;
    }

    public static void updatePipelinePhase(V1alpha1Pipeline pipeline, String phase) {
        logger.log(Level.FINE, "setting pipeline to {0} in namespace {1}/{2}", new Object[]{phase, pipeline.getMetadata().getNamespace(), pipeline.getMetadata().getName()});
        V1alpha1Pipeline oldPipeline = (V1alpha1Pipeline)DeepCopyUtils.deepCopy((Object)pipeline);
        V1alpha1PipelineStatus stats = pipeline.getStatus();
        if (stats == null) {
            stats = new V1alpha1PipelineStatusBuilder().build();
        }
        stats.setPhase(phase);
        pipeline.setStatus(stats);
        Clients.get(V1alpha1Pipeline.class).update(oldPipeline, pipeline);
        pipeline.setStatus(stats);
    }

    public static NamespaceName buildConfigNameFromJenkinsJobName(String jobName, String namespace) {
        return new NamespaceName(namespace, jobName);
    }

    public static NamespaceName pipelineConfigNameFromJenkinsJobName(String jobName, String namespace) {
        return new NamespaceName(namespace, jobName);
    }

    public static String formatTimestamp(long timestamp) {
        return dateFormatter.print((ReadableInstant)new DateTime(timestamp));
    }

    public static String getCurrentTimestamp() {
        return dateFormatter.print((ReadableInstant)new DateTime());
    }

    public static long parseTimestamp(String timestamp) {
        return dateFormatter.parseMillis(timestamp);
    }

    public static boolean isCancellable(V1alpha1PipelineStatus pipelineStatus) {
        String phase = pipelineStatus.getPhase();
        return phase.equals("Queued") || phase.equals("Pending") || phase.equals("Running");
    }

    public static boolean isNew(V1alpha1PipelineStatus pipelineStatus) {
        return pipelineStatus.getPhase().equals("Pending");
    }

    public static boolean isCancelled(V1alpha1PipelineStatus status) {
        return status != null && status.isAborted() != false;
    }

    public static String convertNameToValidResourceName(String text) {
        String lower = text.toLowerCase();
        StringBuilder builder = new StringBuilder();
        boolean started = false;
        int lastCh = 32;
        int last = lower.length() - 1;
        for (int i = 0; i <= last; ++i) {
            int ch = lower.charAt(i);
            if (!(ch >= 97 && ch <= 122 || ch >= 48 && ch <= 57)) {
                if (ch == 47) {
                    ch = 46;
                } else if (ch != 46 && ch != 45) {
                    ch = 45;
                }
                if (!started || lastCh == 45 || lastCh == 46 || i == last) continue;
            }
            builder.append((char)ch);
            started = true;
            lastCh = ch;
        }
        return builder.toString();
    }

    public static boolean isBindingToCurrentJenkins(V1alpha1JenkinsBinding jenkinsBinding) {
        AlaudaSyncGlobalConfiguration pluginConfig = AlaudaSyncGlobalConfiguration.get();
        String jenkinsName = jenkinsBinding.getSpec().getJenkins().getName();
        String jenkinsService = pluginConfig.getJenkinsService();
        return jenkinsName.equals(jenkinsService);
    }

    static {
        jenkinsPodNamespace = System.getProperty("PROJECT_NAME");
        if (jenkinsPodNamespace != null && jenkinsPodNamespace.trim().length() > 0) {
            jenkinsPodNamespace = jenkinsPodNamespace.trim();
        } else {
            File f = new File("/run/secrets/kubernetes.io/serviceaccount/namespace");
            if (f.exists()) {
                try (FileReader fr = new FileReader("/run/secrets/kubernetes.io/serviceaccount/namespace");
                     BufferedReader br = new BufferedReader(fr);){
                    jenkinsPodNamespace = br.readLine();
                    if (jenkinsPodNamespace != null && jenkinsPodNamespace.trim().length() > 0) {
                        jenkinsPodNamespace = jenkinsPodNamespace.trim();
                    }
                }
                catch (FileNotFoundException e) {
                    logger.log(Level.FINE, "getNamespaceFromPodInputs", e);
                }
                catch (IOException e) {
                    logger.log(Level.FINE, "getNamespaceFromPodInputs", e);
                }
            }
        }
        dateFormatter = ISODateTimeFormat.dateTimeNoMillis();
    }
}

