/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.sync.mapper.converter;

import antlr.ANTLRException;
import com.cloudbees.hudson.plugins.folder.AbstractFolderProperty;
import com.cloudbees.hudson.plugins.folder.Folder;
import com.cloudbees.hudson.plugins.folder.computed.DefaultOrphanedItemStrategy;
import com.cloudbees.hudson.plugins.folder.computed.OrphanedItemStrategy;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.triggers.Trigger;
import io.alauda.devops.java.client.models.V1alpha1CodeRepository;
import io.alauda.devops.java.client.models.V1alpha1CodeRepositoryRef;
import io.alauda.devops.java.client.models.V1alpha1CodeRepositorySpec;
import io.alauda.devops.java.client.models.V1alpha1MultiBranchBehaviours;
import io.alauda.devops.java.client.models.V1alpha1MultiBranchOrphan;
import io.alauda.devops.java.client.models.V1alpha1MultiBranchPipeline;
import io.alauda.devops.java.client.models.V1alpha1OriginCodeRepository;
import io.alauda.devops.java.client.models.V1alpha1PipelineConfig;
import io.alauda.devops.java.client.models.V1alpha1PipelineSource;
import io.alauda.devops.java.client.models.V1alpha1PipelineSourceGit;
import io.alauda.devops.java.client.models.V1alpha1PipelineStrategyJenkins;
import io.alauda.devops.java.client.models.V1alpha1PipelineTrigger;
import io.alauda.devops.java.client.models.V1alpha1PipelineTriggerCron;
import io.alauda.devops.java.client.utils.DeepCopyUtils;
import io.alauda.jenkins.devops.sync.MultiBranchProperty;
import io.alauda.jenkins.devops.sync.client.Clients;
import io.alauda.jenkins.devops.sync.client.JenkinsClient;
import io.alauda.jenkins.devops.sync.exception.PipelineConfigConvertException;
import io.alauda.jenkins.devops.sync.folder.CronFolderTrigger;
import io.alauda.jenkins.devops.sync.mapper.PipelineConfigMapper;
import io.alauda.jenkins.devops.sync.mapper.converter.GitProviderMultiBranch;
import io.alauda.jenkins.devops.sync.mapper.converter.JobConverter;
import io.alauda.jenkins.devops.sync.util.CredentialsUtils;
import io.alauda.jenkins.devops.sync.util.NamespaceName;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.validation.constraints.NotNull;
import jenkins.branch.BranchProjectFactory;
import jenkins.branch.BranchSource;
import jenkins.model.Jenkins;
import jenkins.plugins.git.GitSCMSource;
import jenkins.plugins.git.traits.BranchDiscoveryTrait;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.impl.trait.RegexSCMHeadFilterTrait;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowBranchProjectFactory;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class MultibranchWorkflowJobConverter
implements JobConverter<WorkflowMultiBranchProject> {
    private static final Logger logger = LoggerFactory.getLogger(MultibranchWorkflowJobConverter.class);
    private JenkinsClient jenkinsClient;
    private PipelineConfigMapper mapper = new PipelineConfigMapper();

    public MultibranchWorkflowJobConverter() {
        this.jenkinsClient = JenkinsClient.getInstance();
    }

    @Override
    public boolean accept(V1alpha1PipelineConfig pipelineConfig) {
        if (pipelineConfig == null) {
            return false;
        }
        Map labels = pipelineConfig.getMetadata().getLabels();
        return "multi-branch".equals(labels.get("pipeline.kind"));
    }

    @Override
    public WorkflowMultiBranchProject convert(V1alpha1PipelineConfig pipelineConfig) throws PipelineConfigConvertException, IOException {
        Optional<V1alpha1PipelineTrigger> triggerOpt;
        List triggers;
        WorkflowMultiBranchProject job;
        String name;
        String namespace = pipelineConfig.getMetadata().getNamespace();
        NamespaceName namespaceName = new NamespaceName(namespace, name = pipelineConfig.getMetadata().getName());
        Item item = this.jenkinsClient.getItem(namespaceName);
        if (item == null) {
            logger.debug("Unable to found a Jenkins job for PipelineConfig '{}/{}'", (Object)namespace, (Object)name);
            Folder parentFolder = this.jenkinsClient.upsertFolder(namespace);
            job = new WorkflowMultiBranchProject((ItemGroup)parentFolder, this.mapper.jenkinsJobName(namespace, name));
            job.addProperty((AbstractFolderProperty)new MultiBranchProperty(namespace, name, pipelineConfig.getMetadata().getUid(), pipelineConfig.getMetadata().getResourceVersion()));
        } else {
            if (!(item instanceof WorkflowMultiBranchProject)) {
                throw new PipelineConfigConvertException(new String[]{String.format("Unable to update Jenkins job, except a WorkflowMultiBranchProject but found a %s", item.getClass())});
            }
            job = (WorkflowMultiBranchProject)item;
            MultiBranchProperty mbProperty = (MultiBranchProperty)job.getProperties().get(MultiBranchProperty.class);
            mbProperty.setResourceVersion(pipelineConfig.getMetadata().getResourceVersion());
        }
        job.getSourcesList().clear();
        V1alpha1PipelineStrategyJenkins strategy = pipelineConfig.getSpec().getStrategy().getJenkins();
        WorkflowBranchProjectFactory wfFactory = new WorkflowBranchProjectFactory();
        wfFactory.setScriptPath(strategy.getJenkinsfilePath());
        job.setProjectFactory((BranchProjectFactory)wfFactory);
        V1alpha1MultiBranchBehaviours behaviours = null;
        V1alpha1MultiBranchPipeline multiBranch = strategy.getMultiBranch();
        if (multiBranch != null) {
            V1alpha1MultiBranchOrphan orphaned = multiBranch.getOrphaned();
            DefaultOrphanedItemStrategy orphanedStrategy = orphaned != null ? new DefaultOrphanedItemStrategy(true, String.valueOf(orphaned.getDays()), String.valueOf(orphaned.getMax())) : new DefaultOrphanedItemStrategy(false, "", "");
            job.setOrphanedItemStrategy((OrphanedItemStrategy)orphanedStrategy);
            behaviours = multiBranch.getBehaviours();
        }
        V1alpha1PipelineSource source = pipelineConfig.getSpec().getSource();
        GitSCMSource scmSource = null;
        V1alpha1CodeRepositoryRef codeRepoRef = source.getCodeRepository();
        V1alpha1PipelineSourceGit gitSource = source.getGit();
        GitProviderMultiBranch gitProvider = null;
        if (codeRepoRef != null) {
            String codeRepoName = codeRepoRef.getName();
            V1alpha1CodeRepository codeRep = (V1alpha1CodeRepository)Clients.get(V1alpha1CodeRepository.class).lister().namespace(namespace).get(codeRepoRef.getName());
            if (codeRep != null) {
                V1alpha1CodeRepositorySpec codeRepoSpec = codeRep.getSpec();
                V1alpha1OriginCodeRepository codeRepo = codeRepoSpec.getRepository();
                String repoOwner = codeRepo.getOwner().getName();
                String repository = codeRepo.getName();
                String codeRepoType = codeRepo.getCodeRepoServiceType();
                Optional<GitProviderMultiBranch> gitProviderOpt = Jenkins.getInstance().getExtensionList(GitProviderMultiBranch.class).stream().filter(git -> git.accept(codeRepo.getCodeRepoServiceType())).findFirst();
                boolean supported = gitProviderOpt.isPresent();
                if (supported) {
                    gitProvider = gitProviderOpt.get();
                    scmSource = gitProvider.getSCMSource(repoOwner, repository);
                    if (scmSource == null) {
                        logger.warn("Can't create instance for AbstractGitSCMSource. Type is {}.", (Object)codeRepoType);
                        return null;
                    }
                } else {
                    logger.warn("Not support for {}, codeRepo name is {}. Fall back to general git.", (Object)codeRepoType, (Object)codeRepoName);
                    scmSource = new GitSCMSource(codeRepo.getCloneURL());
                }
            } else {
                logger.warn("Can't found codeRepository {}, namespace {}.", (Object)codeRepoName, (Object)namespace);
            }
        } else if (gitSource != null) {
            scmSource = new GitSCMSource(gitSource.getUri());
        } else {
            logger.warn("Not found git repository.");
        }
        if (scmSource != null) {
            this.handleSCMTraits((SCMSource)scmSource, behaviours, gitProvider);
            this.handleCredentials((SCMSource)scmSource, pipelineConfig);
            job.setSourcesList(Collections.singletonList(new BranchSource((SCMSource)scmSource)));
            scmSource.setOwner((SCMSourceOwner)job);
        }
        if ((triggers = pipelineConfig.getSpec().getTriggers()) != null && (triggerOpt = triggers.stream().filter(trigger -> "cron".equals(trigger.getType())).findFirst()).isPresent()) {
            V1alpha1PipelineTrigger trigger2 = triggerOpt.get();
            V1alpha1PipelineTriggerCron cron = trigger2.getCron();
            try {
                job.addTrigger((Trigger)new CronFolderTrigger(cron.getRule(), cron.isEnabled()));
            }
            catch (ANTLRException e) {
                e.printStackTrace();
            }
        }
        Map<String, String> logURLs = Collections.singletonMap("alauda.io/multi-branch-scan-log", String.format("/job/%s/job/%s/indexing/logText/progressiveText", namespace, this.mapper.jenkinsJobName(namespace, name)));
        this.addAnnotations(pipelineConfig, logURLs);
        return job;
    }

    private void handleSCMTraits(@NotNull SCMSource source, V1alpha1MultiBranchBehaviours behaviours, GitProviderMultiBranch gitProvider) {
        ArrayList<Object> traits = new ArrayList<Object>();
        if (behaviours != null && StringUtils.isNotBlank((String)behaviours.getFilterExpression())) {
            traits.add(new RegexSCMHeadFilterTrait(behaviours.getFilterExpression()));
        }
        if (gitProvider != null) {
            traits.add(gitProvider.getBranchDiscoverTrait(1));
            traits.add(gitProvider.getOriginPRTrait(1));
            traits.add(gitProvider.getForkPRTrait(1));
            traits.add(gitProvider.getCloneTrait());
        } else {
            traits.add(new BranchDiscoveryTrait());
        }
        try {
            Method method = source.getClass().getMethod("setTraits", List.class);
            method.invoke((Object)source, traits);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            logger.error(String.format("Can't setting traits, source class is %s", source.getClass()));
        }
    }

    private void handleCredentials(@NotNull SCMSource source, @NotNull V1alpha1PipelineConfig pipelineConfig) throws IOException {
        try {
            String credentialId = CredentialsUtils.getSCMSourceCredentialsId(pipelineConfig);
            Method method = source.getClass().getMethod("setCredentialsId", String.class);
            method.invoke((Object)source, credentialId);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            logger.error(String.format("Can't setting credentials, source class is %s", source.getClass()));
        }
    }

    private void addAnnotations(@NotNull V1alpha1PipelineConfig pc, @NotNull Map<String, String> annotations) {
        V1alpha1PipelineConfig oldPc = (V1alpha1PipelineConfig)DeepCopyUtils.deepCopy((Object)pc);
        annotations.forEach((key, value) -> pc.getMetadata().putAnnotationsItem(key, value));
        Clients.get(V1alpha1PipelineConfig.class).update(oldPc, pc);
    }
}

