/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.sync.listener;

import com.cloudbees.workflow.rest.external.AtomFlowNodeExt;
import com.cloudbees.workflow.rest.external.FlowNodeExt;
import com.cloudbees.workflow.rest.external.PendingInputActionsExt;
import com.cloudbees.workflow.rest.external.RunExt;
import com.cloudbees.workflow.rest.external.StageNodeExt;
import com.cloudbees.workflow.rest.external.StatusExt;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.jenkinsci.plugins.badge.action.BadgeAction;
import hudson.Extension;
import hudson.PluginManager;
import hudson.model.Actionable;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.triggers.SafeTimerTask;
import io.alauda.devops.java.client.models.V1alpha1Pipeline;
import io.alauda.devops.java.client.models.V1alpha1PipelineStatus;
import io.alauda.devops.java.client.models.V1alpha1PipelineStatusJenkins;
import io.alauda.devops.java.client.models.V1alpha1PipelineStatusJenkinsBuilder;
import io.alauda.devops.java.client.utils.DeepCopyUtils;
import io.alauda.jenkins.devops.sync.AlaudaJobProperty;
import io.alauda.jenkins.devops.sync.AlaudaSyncGlobalConfiguration;
import io.alauda.jenkins.devops.sync.JenkinsPipelineCause;
import io.alauda.jenkins.devops.sync.MultiBranchProperty;
import io.alauda.jenkins.devops.sync.WorkflowJobProperty;
import io.alauda.jenkins.devops.sync.client.Clients;
import io.alauda.jenkins.devops.sync.util.JenkinsUtils;
import io.alauda.jenkins.devops.sync.util.PipelineUtils;
import io.alauda.jenkins.devops.sync.util.WorkflowJobUtils;
import io.jenkins.blueocean.rest.factory.BlueRunFactory;
import io.jenkins.blueocean.rest.model.BluePipelineNode;
import io.jenkins.blueocean.rest.model.BluePipelineStep;
import io.jenkins.blueocean.rest.model.BlueRun;
import io.kubernetes.client.extended.workqueue.DefaultRateLimitingQueue;
import io.kubernetes.client.extended.workqueue.RateLimitingQueue;
import io.kubernetes.client.extended.workqueue.ratelimiter.BucketRateLimiter;
import io.kubernetes.client.extended.workqueue.ratelimiter.RateLimiter;
import io.kubernetes.client.models.V1Status;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.validation.constraints.NotNull;
import jenkins.model.Jenkins;
import jenkins.util.Timer;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;
import org.jenkinsci.plugins.workflow.support.steps.input.InputAction;
import org.jenkinsci.plugins.workflow.support.steps.input.InputStepExecution;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.kohsuke.stapler.DataBoundConstructor;

@Extension
public class PipelineSyncRunListener
extends RunListener<Run> {
    private static final Logger logger = Logger.getLogger(PipelineSyncRunListener.class.getName());
    private long pollPeriodMs = 5000L;
    private transient RateLimitingQueue<Run> runs = new DefaultRateLimitingQueue(Executors.newSingleThreadExecutor(), (RateLimiter)new BucketRateLimiter(100L, 2L, Duration.ofSeconds(1L)));
    private transient AtomicBoolean timerStarted = new AtomicBoolean(false);

    @DataBoundConstructor
    public PipelineSyncRunListener() {
    }

    public void onStarted(Run run, TaskListener listener) {
        if (this.shouldPollRun(run)) {
            this.runs.add((Object)run);
            logger.info("starting polling build " + run.getUrl());
            this.checkTimerStarted();
        } else {
            logger.fine("not polling polling pipeline " + run.getUrl() + " as its not a WorkflowJob");
        }
    }

    private void checkTimerStarted() {
        long delayPollPeriodMs = 1000L;
        if (this.timerStarted.compareAndSet(false, true)) {
            Timer.get().scheduleAtFixedRate((Runnable)new SafeTimerTask(){

                protected void doRun() throws Exception {
                    PipelineSyncRunListener.this.pollLoop();
                }
            }, delayPollPeriodMs, this.pollPeriodMs, TimeUnit.MILLISECONDS);
        }
    }

    public void onCompleted(Run run, @Nonnull TaskListener listener) {
        if (this.shouldPollRun(run)) {
            this.runs.add((Object)run);
            logger.fine("onCompleted " + run.getUrl());
        } else {
            logger.fine(() -> "this build is not WorkflowRun, " + run);
        }
    }

    public synchronized void onDeleted(Run run) {
        if (!this.shouldPollRun(run)) {
            return;
        }
        JenkinsPipelineCause cause = PipelineUtils.findAlaudaCause((Actionable)run);
        if (cause != null) {
            String namespace = cause.getNamespace();
            String pipelineName = cause.getName();
            V1Status result = PipelineUtils.delete(namespace, pipelineName);
            int buildNum = run.getNumber();
            logger.fine("Delete `Pipeline` result is: " + result + "; name is: " + pipelineName + "; buildNum is: " + buildNum);
        }
        logger.fine("onDeleted " + run.getUrl());
    }

    public synchronized void onFinalized(Run run) {
        if (this.shouldPollRun(run)) {
            this.runs.add((Object)run);
            logger.fine("onFinalized " + run.getUrl());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void pollLoop() {
        try {
            while (true) lbl-1000:
            // 6 sources

            {
                runToPoll = (Run)this.runs.get();
                try {
                    result = this.pollRun(runToPoll);
                    shouldPollAgain = false;
                    status = RunExt.create((WorkflowRun)((WorkflowRun)runToPoll)).getStatus();
                    switch (2.$SwitchMap$com$cloudbees$workflow$rest$external$StatusExt[status.ordinal()]) {
                        case 1: 
                        case 2: {
                            shouldPollAgain = true;
                            break;
                        }
                        case 3: {
                            if (!runToPoll.isBuilding()) break;
                            shouldPollAgain = true;
                            this.runs.add((Object)runToPoll);
                            break;
                        }
                    }
                    if (shouldPollAgain) {
                        if (result.isRequeue()) {
                            PipelineSyncRunListener.logger.log(Level.FINE, String.format("[PipelineSyncRun] Requeue Run %s", new Object[]{runToPoll.getFullDisplayName()}));
                            this.runs.addRateLimited((Object)runToPoll);
                        }
                        PipelineSyncRunListener.logger.log(Level.FINE, String.format("[PipelineSyncRun] The status of run %s is %s, will poll it again after two seconds", new Object[]{runToPoll.getFullDisplayName(), status}));
                        this.runs.addAfter((Object)runToPoll, Duration.ofSeconds(2L));
                    }
                    if (result.isRequeue()) {
                        PipelineSyncRunListener.logger.log(Level.FINE, String.format("[PipelineSyncRun] Requeue Run %s", new Object[]{runToPoll.getFullDisplayName()}));
                        this.runs.addRateLimited((Object)runToPoll);
                    }
                    this.runs.forget((Object)runToPoll);
                }
                finally {
                    this.runs.done((Object)runToPoll);
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException e) {
            PipelineSyncRunListener.logger.log(Level.SEVERE, "Unable to poll status of runs, reason %s", e.getMessage());
            Thread.currentThread().interrupt();
            return;
        }
        ** GOTO lbl-1000
    }

    private synchronized io.kubernetes.client.extended.controller.reconciler.Result pollRun(Run run) {
        BlueRun blueRun;
        if (!(run instanceof WorkflowRun)) {
            throw new IllegalStateException("Cannot poll a non-workflow run");
        }
        logger.log(Level.FINE, String.format("Polling run %s", run.getFullDisplayName()));
        RunExt wfRunExt = null;
        try {
            wfRunExt = RunExt.create((WorkflowRun)((WorkflowRun)run));
        }
        catch (Throwable e) {
            logger.log(Level.FINE, String.format("Failed to create RunExt for run %s, reason: %s", run.getDisplayName(), e.getMessage()));
            new io.kubernetes.client.extended.controller.reconciler.Result(true);
        }
        try {
            blueRun = BlueRunFactory.getRun((Run)run, null);
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, String.format("Unable to poll run %s, reason: %s", run.getDisplayName(), t.getMessage()));
            return new io.kubernetes.client.extended.controller.reconciler.Result(true);
        }
        try {
            return this.upsertPipeline(run, wfRunExt, blueRun);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Cannot update status: {0}", e.getMessage());
            return new io.kubernetes.client.extended.controller.reconciler.Result(true);
        }
    }

    private boolean shouldUpdatePipeline(JenkinsPipelineCause cause, int latestStageNum, int latestNumFlowNodes, StatusExt status) {
        long currTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
        logger.fine(String.format("shouldUpdatePipeline curr time %s last update %s curr stage num %s last stage num %scurr flow num %s last flow num %s status %s", String.valueOf(currTime), String.valueOf(cause.getLastUpdateToAlaudaDevOps()), String.valueOf(latestStageNum), String.valueOf(cause.getNumStages()), String.valueOf(latestNumFlowNodes), String.valueOf(cause.getNumFlowNodes()), status.toString()));
        if (currTime > cause.getLastUpdateToAlaudaDevOps() + this.pollPeriodMs) {
            return true;
        }
        if (cause.getNumStages() != latestStageNum) {
            return true;
        }
        if (cause.getNumFlowNodes() != latestNumFlowNodes) {
            return true;
        }
        return status != StatusExt.IN_PROGRESS && status != StatusExt.PAUSED_PENDING_INPUT;
    }

    private String toBlueJson(@NotNull PipelineJson pipeJson) {
        ObjectMapper blueJsonMapper = new ObjectMapper();
        blueJsonMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        blueJsonMapper.disable(SerializationFeature.FAIL_ON_SELF_REFERENCES);
        try {
            return blueJsonMapper.writeValueAsString((Object)pipeJson);
        }
        catch (JsonProcessingException e) {
            logger.log(Level.SEVERE, "Failed to serialize blueJson run. " + (Object)((Object)e), e);
            logger.log(Level.SEVERE, "blueJson data: " + pipeJson);
            return null;
        }
    }

    private io.kubernetes.client.extended.controller.reconciler.Result upsertPipeline(@NotNull Run run, RunExt wfRunExt, BlueRun blueRun) {
        String logsBlueOceanUrl;
        String progressiveLogUrl;
        String stepsUrl;
        String stepsLogUrl;
        String stagesLogUrl;
        String stagesUrl;
        String viewLogUrl;
        String logsConsoleUrl;
        String logsUrl;
        String buildUrl;
        String rootUrl;
        JenkinsPipelineCause cause;
        block24: {
            Job wfJob;
            List causes = run.getCauses();
            causes.forEach(causeItem -> logger.fine(() -> "run " + run + " caused by " + causeItem));
            cause = PipelineUtils.findAlaudaCause((Actionable)run);
            if (cause == null) {
                logger.warning("run " + run + " do not have JenkinsPipelineCause");
                return new io.kubernetes.client.extended.controller.reconciler.Result(false);
            }
            String namespace = cause.getNamespace();
            rootUrl = "";
            buildUrl = PipelineSyncRunListener.joinPaths(rootUrl, run.getUrl());
            logsUrl = PipelineSyncRunListener.joinPaths(buildUrl, "/consoleText");
            logsConsoleUrl = PipelineSyncRunListener.joinPaths(buildUrl, "/console");
            if (JenkinsUtils.fromMultiBranch(run)) {
                wfJob = (WorkflowJob)run.getParent();
                WorkflowMultiBranchProject multiWfJob = (WorkflowMultiBranchProject)wfJob.getParent();
                viewLogUrl = String.format("/blue/rest/organizations/jenkins/pipelines/%s/pipelines/%s/branches/%s/runs/%d/nodes/%%d/steps/%%d/log/", cause.getNamespace(), multiWfJob.getName(), wfJob.getName(), run.number);
                stagesUrl = String.format("/blue/rest/organizations/jenkins/pipelines/%s/pipelines/%s/branches/%s/runs/%d/nodes/", cause.getNamespace(), multiWfJob.getName(), wfJob.getName(), run.number);
                stagesLogUrl = String.format("/blue/rest/organizations/jenkins/pipelines/%s/pipelines/%s/branches/%s/runs/%d/nodes/%%d/log/", cause.getNamespace(), multiWfJob.getName(), wfJob.getName(), run.number);
                stepsLogUrl = String.format("/blue/rest/organizations/jenkins/pipelines/%s/pipelines/%s/branches/%s/runs/%d/nodes/%%d/log/", cause.getNamespace(), multiWfJob.getName(), wfJob.getName(), run.number);
                stepsUrl = String.format("/blue/rest/organizations/jenkins/pipelines/%s/pipelines/%s/branches/%s/runs/%d/nodes/%%d/steps/", cause.getNamespace(), multiWfJob.getName(), wfJob.getName(), run.number);
            } else {
                wfJob = run.getParent();
                viewLogUrl = String.format("/blue/rest/organizations/jenkins/pipelines/%s/pipelines/%s/runs/%d/nodes/%%d/steps/%%d/log/", cause.getNamespace(), wfJob.getName(), run.number);
                stagesLogUrl = String.format("/blue/rest/organizations/jenkins/pipelines/%s/pipelines/%s/runs/%d/nodes/%%d/log/", cause.getNamespace(), wfJob.getName(), run.number);
                stagesUrl = String.format("/blue/rest/organizations/jenkins/pipelines/%s/pipelines/%s/runs/%d/nodes/", cause.getNamespace(), wfJob.getName(), run.number);
                stepsLogUrl = String.format("/blue/rest/organizations/jenkins/pipelines/%s/pipelines/%s/runs/%d/nodes/%%d/log/", cause.getNamespace(), wfJob.getName(), run.number);
                stepsUrl = String.format("/blue/rest/organizations/jenkins/pipelines/%s/pipelines/%s/runs/%d/nodes/%%d/steps/", cause.getNamespace(), wfJob.getName(), run.number);
            }
            progressiveLogUrl = PipelineSyncRunListener.joinPaths(buildUrl, "/logText/progressiveText");
            logsBlueOceanUrl = null;
            try {
                ClassLoader cl;
                Jenkins jenkins = Jenkins.getInstance();
                PluginManager pluginMgr = jenkins.getPluginManager();
                if (pluginMgr != null && (cl = pluginMgr.uberClassLoader) != null) {
                    Class<?> weburlbldr = cl.loadClass("org.jenkinsci.plugins.blueoceandisplayurl.BlueOceanDisplayURLImpl");
                    Constructor<?> ctor = weburlbldr.getConstructor(new Class[0]);
                    Object displayURL = ctor.newInstance(new Object[0]);
                    Method getRunURLMethod = weburlbldr.getMethod("getRunURL", Run.class);
                    Object blueOceanURI = getRunURLMethod.invoke(displayURL, run);
                    logsBlueOceanUrl = blueOceanURI.toString();
                    logsBlueOceanUrl = logsBlueOceanUrl.replaceAll("http://unconfigured-jenkins-location/", "");
                }
            }
            catch (Throwable t) {
                if (!logger.isLoggable(Level.FINE)) break block24;
                logger.log(Level.FINE, "upsertPipeline", t);
            }
        }
        HashMap<String, BlueRun.BlueRunResult> blueRunResults = new HashMap<String, BlueRun.BlueRunResult>();
        PipelineJson pipeJson = new PipelineJson();
        HashMap<String, PipelineStage> stageMap = new HashMap<String, PipelineStage>();
        try {
            if (blueRun != null && blueRun.getNodes() != null) {
                for (BluePipelineNode node : blueRun.getNodes()) {
                    if (node == null) continue;
                    BlueRun.BlueRunResult result = node.getResult();
                    BlueRun.BlueRunState state = node.getStateObj();
                    PipelineStage pipeStage = new PipelineStage(node.getId(), node.getDisplayName(), state != null ? state.name() : "NOT_BUILT", result != null ? result.name() : "UNKNOWN", node.getStartTimeString(), node.getDurationInMillis(), 0L, node.getEdges());
                    stageMap.put(node.getDisplayName(), pipeStage);
                    pipeJson.addStage(pipeStage);
                    blueRunResults.put(node.getDisplayName(), node.getResult());
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to fetch stages from blue ocean API. " + e, e);
        }
        if (!wfRunExt.get_links().self.href.matches("^https?://.*$")) {
            wfRunExt.get_links().self.setHref(PipelineSyncRunListener.joinPaths(rootUrl, wfRunExt.get_links().self.href));
        }
        int newNumStages = wfRunExt.getStages().size();
        int newNumFlowNodes = 0;
        ArrayList<StageNodeExt> validStageList = new ArrayList<StageNodeExt>();
        ArrayList blueStages = new ArrayList();
        for (StageNodeExt stage : wfRunExt.getStages()) {
            PipelineStage pipeStage;
            BlueRun.BlueRunResult result = (BlueRun.BlueRunResult)blueRunResults.get(stage.getName());
            if (result == BlueRun.BlueRunResult.NOT_BUILT) {
                logger.info("skipping stage " + stage.getName() + " for the status JSON for pipeline run " + run.getDisplayName() + " because it was not executed (most likely because of a failure in another stage)");
                continue;
            }
            validStageList.add(stage);
            FlowNodeExt.FlowNodeLinks links = stage.get_links();
            if (!links.self.href.matches("^https?://.*$")) {
                links.self.setHref(PipelineSyncRunListener.joinPaths(rootUrl, links.self.href));
            }
            if (links.getLog() != null && !links.getLog().href.matches("^https?://.*$")) {
                links.getLog().setHref(PipelineSyncRunListener.joinPaths(rootUrl, links.getLog().href));
            }
            newNumFlowNodes += stage.getStageFlowNodes().size();
            for (AtomFlowNodeExt node : stage.getStageFlowNodes()) {
                FlowNodeExt.FlowNodeLinks nodeLinks = node.get_links();
                if (!nodeLinks.self.href.matches("^https?://.*$")) {
                    nodeLinks.self.setHref(PipelineSyncRunListener.joinPaths(rootUrl, nodeLinks.self.href));
                }
                if (nodeLinks.getLog() == null || nodeLinks.getLog().href.matches("^https?://.*$")) continue;
                nodeLinks.getLog().setHref(PipelineSyncRunListener.joinPaths(rootUrl, nodeLinks.getLog().href));
            }
            StatusExt status = stage.getStatus();
            if (status == null || (pipeStage = (PipelineStage)stageMap.get(stage.getName())) == null) continue;
            pipeStage.pause_duration_millis = stage.getPauseDurationMillis();
        }
        wfRunExt.setStages(validStageList);
        boolean needToUpdate = this.shouldUpdatePipeline(cause, newNumStages, newNumFlowNodes, wfRunExt.getStatus());
        if (!needToUpdate) {
            logger.fine("run " + run + " do not need to update.");
            return new io.kubernetes.client.extended.controller.reconciler.Result(true);
        }
        String json = null;
        try {
            json = new ObjectMapper().writeValueAsString((Object)wfRunExt);
        }
        catch (JsonProcessingException e) {
            logger.log(Level.SEVERE, "Failed to serialize workflow run. " + (Object)((Object)e), e);
        }
        String phase = this.runToPipelinePhase(run);
        long started = this.getStartTime(run);
        DateTime startTime = null;
        DateTime completionTime = null;
        DateTime updatedTime = DateTime.now();
        if (started > 0L) {
            startTime = new DateTime(started, DateTimeZone.getDefault());
            long duration = this.getDuration(run);
            if (duration > 0L) {
                completionTime = new DateTime(started + duration, DateTimeZone.getDefault());
            }
        }
        logger.log(Level.INFO, "Patching pipeline {0}/{1}: setting phase to {2}", new Object[]{cause.getNamespace(), cause.getName(), phase});
        V1alpha1Pipeline pipeline = (V1alpha1Pipeline)Clients.get(V1alpha1Pipeline.class).lister().namespace(cause.getNamespace()).get(cause.getName());
        if (pipeline == null) {
            logger.warning(() -> String.format("Pipeline name[%s], namesapce[%s] don't exists", cause.getName(), cause.getNamespace()));
            return new io.kubernetes.client.extended.controller.reconciler.Result(false);
        }
        V1alpha1Pipeline newPipeline = (V1alpha1Pipeline)DeepCopyUtils.deepCopy((Object)pipeline);
        String blueJson = this.toBlueJson(pipeJson);
        Map annotations = newPipeline.getMetadata().getAnnotations();
        annotations.put("alauda.io/jenkins-status-json", json);
        annotations.put("alauda.io/jenkins-stages-json", blueJson);
        annotations.put("alauda.io/jenkins-build-uri", buildUrl);
        annotations.put("alauda.io/jenkins-log-url", logsUrl);
        annotations.put("alauda.io/jenkins-console-log-url", logsConsoleUrl);
        annotations.put("alauda.io/jenkins-blueocean-log-url", logsBlueOceanUrl);
        annotations.put("alauda.io/jenkins-view-log", viewLogUrl);
        annotations.put("alauda.io/jenkins-stages", stagesUrl);
        annotations.put("alauda.io/jenkins-stages-log", stagesLogUrl);
        annotations.put("alauda.io/jenkins-steps", stepsUrl);
        annotations.put("alauda.io/jenkins-steps-log", stepsLogUrl);
        annotations.put("alauda.io/jenkins-progressive-log", progressiveLogUrl);
        newPipeline.getMetadata().setAnnotations(annotations);
        this.badgeHandle(run, annotations);
        V1alpha1PipelineStatus status = this.createPipelineStatus(newPipeline, phase, startTime, completionTime, updatedTime, blueJson, run, wfRunExt);
        newPipeline.setStatus(status);
        boolean succeed = Clients.get(V1alpha1Pipeline.class).update(pipeline, newPipeline);
        if (!succeed) {
            logger.fine(String.format("Failed updated pipeline: '%s/%s", newPipeline.getMetadata().getNamespace(), newPipeline.getMetadata().getName()));
            return new io.kubernetes.client.extended.controller.reconciler.Result(true);
        }
        logger.fine(String.format("updated pipeline: '%s/%s", newPipeline.getMetadata().getNamespace(), newPipeline.getMetadata().getName()));
        cause.setNumFlowNodes(newNumFlowNodes);
        cause.setNumStages(newNumStages);
        cause.setLastUpdateToAlaudaDevOps(TimeUnit.NANOSECONDS.toMillis(System.nanoTime()));
        return new io.kubernetes.client.extended.controller.reconciler.Result(false);
    }

    private void badgeHandle(@NotNull Run run, Map<String, String> annotations) {
        if (annotations == null) {
            return;
        }
        JSONArray jsonArray = new JSONArray();
        List actions = run.getAllActions();
        actions.stream().filter(action -> action instanceof BadgeAction).forEach(action -> {
            BadgeAction badgeAction = (BadgeAction)action;
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("id", (Object)badgeAction.getId());
            jsonObject.put("text", (Object)badgeAction.getText());
            jsonObject.put("displayName", (Object)badgeAction.getDisplayName());
            jsonObject.put("iconPath", (Object)badgeAction.getIconPath());
            jsonObject.put("iconFileName", (Object)badgeAction.getIconFileName());
            jsonObject.put("link", (Object)badgeAction.getLink());
            jsonObject.put("isTextOnly", (Object)badgeAction.isTextOnly());
            jsonArray.add((Object)jsonObject);
        });
        annotations.put("alauda.io/jenkins-badges", jsonArray.toString());
    }

    private V1alpha1PipelineStatus createPipelineStatus(V1alpha1Pipeline pipeline, String phase, DateTime startTime, DateTime completionTime, DateTime updatedTime, String blueJson, Run run, RunExt wfRunExt) {
        V1alpha1PipelineStatus status = pipeline.getStatus();
        if (status == null) {
            status = new V1alpha1PipelineStatus();
        }
        status.setPhase(phase);
        status.setStartedAt(startTime);
        status.setFinishedAt(completionTime);
        status.setUpdatedAt(updatedTime);
        V1alpha1PipelineStatusJenkins statusJenkins = status.getJenkins();
        if (statusJenkins == null) {
            statusJenkins = new V1alpha1PipelineStatusJenkinsBuilder().build();
        }
        status.setJenkins(statusJenkins);
        statusJenkins.setBuild(String.valueOf(this.getRunNumber(run)));
        if (blueJson != null) {
            statusJenkins.setStages(blueJson);
        }
        statusJenkins.setResult(this.getRunResult(run));
        statusJenkins.setStatus(wfRunExt.getStatus().name());
        return status;
    }

    private String getPendingActionsJson(WorkflowRun run) throws TimeoutException, InterruptedException {
        List executions;
        ArrayList<PendingInputActionsExt> pendingInputActions = new ArrayList<PendingInputActionsExt>();
        InputAction inputAction = (InputAction)run.getAction(InputAction.class);
        if (inputAction != null && (executions = inputAction.getExecutions()) != null && !executions.isEmpty()) {
            for (InputStepExecution inputStepExecution : executions) {
                pendingInputActions.add(PendingInputActionsExt.create((InputStepExecution)inputStepExecution, (WorkflowRun)run));
            }
        }
        try {
            return new ObjectMapper().writeValueAsString(pendingInputActions);
        }
        catch (JsonProcessingException e) {
            logger.log(Level.SEVERE, "Failed to serialize pending actions. " + (Object)((Object)e), e);
            return null;
        }
    }

    private long getStartTime(Run run) {
        return run.getStartTimeInMillis();
    }

    private long getDuration(Run run) {
        return run.getDuration();
    }

    @Deprecated
    private String runToPipelinePhase(Run run) {
        if (run != null && !run.hasntStartedYet()) {
            if (run.isBuilding()) {
                return "Running";
            }
            Result result = run.getResult();
            if (result != null) {
                if (result.equals(Result.SUCCESS)) {
                    return "Complete";
                }
                if (result.equals(Result.ABORTED)) {
                    return "Cancelled";
                }
                if (result.equals(Result.FAILURE)) {
                    return "Failed";
                }
                if (result.equals(Result.UNSTABLE)) {
                    return "Failed";
                }
                return "Queued";
            }
        }
        return "Pending";
    }

    private String getRunResult(Run run) {
        Result result = run.getResult();
        if (result != null) {
            return result.toString();
        }
        return Result.NOT_BUILT.toString();
    }

    private String getRunStatus(Run run) {
        if (run.hasntStartedYet()) {
            return "QUEUED";
        }
        if (run.isBuilding()) {
            return "RUNNING";
        }
        if (!run.isLogUpdated()) {
            return "FINISHED";
        }
        return "SKIPPED";
    }

    private int getRunNumber(Run run) {
        return run.getNumber();
    }

    private boolean shouldPollRun(Run run) {
        if (!AlaudaSyncGlobalConfiguration.get().isEnabled()) {
            return false;
        }
        if (!(run instanceof WorkflowRun)) {
            return false;
        }
        WorkflowJob job = (WorkflowJob)((WorkflowRun)run).getParent();
        ItemGroup parent = job.getParent();
        if (parent instanceof WorkflowMultiBranchProject) {
            WorkflowMultiBranchProject multiBranchProject = (WorkflowMultiBranchProject)parent;
            AlaudaJobProperty alaudaJobProperty = (AlaudaJobProperty)multiBranchProject.getProperties().get(MultiBranchProperty.class);
            return alaudaJobProperty != null;
        }
        WorkflowJobProperty alaudaJobProperty = WorkflowJobUtils.getAlaudaProperty((Job)job);
        return alaudaJobProperty != null;
    }

    public static String joinPaths(String ... strings) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < strings.length; ++i) {
            sb.append(strings[i]);
            if (i >= strings.length - 1) continue;
            sb.append("/");
        }
        String joined = sb.toString();
        return joined.replaceAll("/+", "/").replaceAll("/\\?", "?").replaceAll("/#", "#").replaceAll(":/", "://");
    }

    private static class PipelineStage {
        public String id;
        public String name;
        public String status;
        public String result;
        public String start_time;
        public Long duration_millis;
        public Long pause_duration_millis;
        public List<BluePipelineNode.Edge> edges;

        PipelineStage(String id, String name, String status, String result, String start_time, Long duration_millis, Long pause_duration_millis, List<BluePipelineNode.Edge> edges) {
            this.id = id;
            this.name = name;
            this.status = status;
            this.result = result;
            this.start_time = start_time;
            this.duration_millis = duration_millis;
            this.pause_duration_millis = pause_duration_millis;
            this.edges = edges;
        }
    }

    private static class PipelineJson {
        public String start_stage_id = null;
        public List<PipelineStage> stages = new ArrayList<PipelineStage>();

        public void addStage(PipelineStage stage) {
            if (this.start_stage_id == null) {
                this.start_stage_id = stage.id;
            }
            this.stages.add(stage);
        }
    }

    private static class BlueJsonStage {
        public StageNodeExt stage;
        public BlueRun.BlueRunResult result;
        public List<BluePipelineNode.Edge> edges;

        public BlueJsonStage(StageNodeExt stage, BlueRun.BlueRunResult result, List<BluePipelineNode.Edge> edges, List<BluePipelineStep> steps) {
            this.stage = stage;
            this.result = result;
            this.edges = edges;
        }
    }
}

