/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.sync.listener;

import hudson.Extension;
import hudson.model.Item;
import hudson.model.ItemGroup;
import io.alauda.devops.java.client.models.V1alpha1PipelineConfig;
import io.alauda.devops.java.client.utils.DeepCopyUtils;
import io.alauda.jenkins.devops.sync.AlaudaJobProperty;
import io.alauda.jenkins.devops.sync.MultiBranchProperty;
import io.alauda.jenkins.devops.sync.client.Clients;
import io.alauda.jenkins.devops.sync.listener.ItemEventHandler;
import io.alauda.jenkins.devops.sync.multiBranch.PullRequest;
import io.alauda.jenkins.devops.sync.util.PipelineGenerator;
import io.kubernetes.client.models.V1ObjectMeta;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.validation.constraints.NotNull;
import jenkins.scm.api.metadata.ObjectMetadataAction;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.multibranch.BranchJobProperty;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;

@Extension
@Restricted(value={DoNotUse.class})
public class MultiBranchWorkflowEventHandler
implements ItemEventHandler<WorkflowJob> {
    private static final Logger logger = Logger.getLogger(MultiBranchWorkflowEventHandler.class.getName());

    @Override
    public boolean accept(Item item) {
        if (item == null) {
            return false;
        }
        ItemGroup parent = item.getParent();
        return parent instanceof WorkflowMultiBranchProject;
    }

    @Override
    public void onCreated(WorkflowJob item) {
        BranchJobProperty pro = (BranchJobProperty)item.getProperty(BranchJobProperty.class);
        String scmURL = "";
        ObjectMetadataAction metadataAction = (ObjectMetadataAction)item.getAction(ObjectMetadataAction.class);
        if (metadataAction != null) {
            scmURL = metadataAction.getObjectUrl();
        }
        if (pro != null) {
            String name = pro.getBranch().getName();
            WorkflowMultiBranchProject parent = (WorkflowMultiBranchProject)item.getParent();
            PullRequest pr = PipelineGenerator.getPR((Item)item);
            if (pr != null) {
                pr.setUrl(scmURL);
                this.addPRAnnotation(parent, pr, name);
                logger.info(String.format("add a pr %s", name));
            } else {
                this.addBranchAnnotation(parent, name, scmURL);
                logger.info(String.format("add a branch %s", name));
            }
        }
    }

    @Override
    public void onUpdated(WorkflowJob item) {
        BranchJobProperty pro = (BranchJobProperty)item.getProperty(BranchJobProperty.class);
        String scmURL = "";
        ObjectMetadataAction metadataAction = (ObjectMetadataAction)item.getAction(ObjectMetadataAction.class);
        if (metadataAction != null) {
            scmURL = metadataAction.getObjectUrl();
        }
        if (pro != null) {
            String name = pro.getBranch().getName();
            WorkflowMultiBranchProject parent = (WorkflowMultiBranchProject)item.getParent();
            if (item.isDisabled()) {
                PullRequest pr = PipelineGenerator.getPR((Item)item);
                if (pr != null) {
                    this.delPRAnnotation(parent, name);
                    this.addStalePRAnnotation(parent, name);
                    logger.info(String.format("disable a pr %s", name));
                } else {
                    this.delBranchAnnotation(parent, name);
                    this.addStaleBranchAnnotation(parent, name);
                    logger.info(String.format("disable a branch %s", name));
                }
            } else {
                PullRequest pr = PipelineGenerator.getPR((Item)item);
                if (pr != null) {
                    pr.setUrl(scmURL);
                    this.delStalePRAnnotation(parent, name);
                    this.addPRAnnotation(parent, pr, name);
                    logger.info(String.format("enable a pr %s", name));
                } else {
                    this.delStaleBranchAnnotation(parent, name);
                    this.addBranchAnnotation(parent, name, scmURL);
                    logger.info(String.format("enable a branch %s", name));
                }
            }
        }
    }

    @Override
    public void onDeleted(WorkflowJob item) {
        BranchJobProperty pro = (BranchJobProperty)item.getProperty(BranchJobProperty.class);
        if (pro != null) {
            String name = pro.getBranch().getEncodedName();
            WorkflowMultiBranchProject parent = (WorkflowMultiBranchProject)item.getParent();
            PullRequest pr = PipelineGenerator.getPR((Item)item);
            if (pr != null) {
                this.delStalePRAnnotation(parent, name);
                logger.info(String.format("del a stale pr %s", name));
            } else {
                this.delStaleBranchAnnotation(parent, name);
                logger.info(String.format("del a stale branch %s", name));
            }
        }
    }

    private void addStaleBranchAnnotation(@NotNull WorkflowMultiBranchProject job, String branchName) {
        V1alpha1PipelineConfig pc = this.getPipelineConfig(job);
        if (pc == null) {
            return;
        }
        V1alpha1PipelineConfig newPc = (V1alpha1PipelineConfig)DeepCopyUtils.deepCopy((Object)pc);
        this.addStaleBranchAnnotation(newPc, branchName);
        Clients.get(V1alpha1PipelineConfig.class).update(pc, newPc);
    }

    private void addStalePRAnnotation(@NotNull WorkflowMultiBranchProject job, String prName) {
        V1alpha1PipelineConfig pc = this.getPipelineConfig(job);
        if (pc == null) {
            return;
        }
        V1alpha1PipelineConfig newPc = (V1alpha1PipelineConfig)DeepCopyUtils.deepCopy((Object)pc);
        this.addAnnotation(newPc, "alauda.io/jenkins.stale.pr", prName);
        Clients.get(V1alpha1PipelineConfig.class).update(pc, newPc);
    }

    private void addBranchAnnotation(@NotNull WorkflowMultiBranchProject job, String branchName, String scmURL) {
        V1alpha1PipelineConfig pc = this.getPipelineConfig(job);
        if (pc == null) {
            return;
        }
        V1alpha1PipelineConfig newPc = (V1alpha1PipelineConfig)DeepCopyUtils.deepCopy((Object)pc);
        this.addAnnotation(newPc, "alauda.io/jenkins.branch", branchName);
        this.setAnnotation(newPc, "alauda.io/jenkins." + branchName + ".url", scmURL);
        Clients.get(V1alpha1PipelineConfig.class).update(pc, newPc);
    }

    private void addPRAnnotation(@NotNull WorkflowMultiBranchProject job, PullRequest pr, String prName) {
        V1alpha1PipelineConfig pc = this.getPipelineConfig(job);
        if (pc == null) {
            return;
        }
        V1alpha1PipelineConfig newPc = (V1alpha1PipelineConfig)DeepCopyUtils.deepCopy((Object)pc);
        this.addAnnotation(newPc, "alauda.io/jenkins.pr", prName);
        this.setAnnotation(newPc, "alauda.io/jenkins." + prName, pr);
        Clients.get(V1alpha1PipelineConfig.class).update(pc, newPc);
    }

    private void addStaleBranchAnnotation(@NotNull V1alpha1PipelineConfig pc, String branchName) {
        this.addAnnotation(pc, "alauda.io/jenkins.stale.branch", branchName);
    }

    private void setAnnotation(@NotNull V1alpha1PipelineConfig pc, String annotation, Object obj) {
        V1ObjectMeta meta = pc.getMetadata();
        HashMap<String, String> annotations = meta.getAnnotations();
        if (annotations == null) {
            annotations = new HashMap<String, String>();
            meta.setAnnotations(annotations);
        }
        annotations.put(annotation, obj instanceof String ? obj.toString() : JSONObject.fromObject((Object)obj).toString());
    }

    private void delAnnotation(@NotNull V1alpha1PipelineConfig pc, String annotation) {
        V1ObjectMeta meta = pc.getMetadata();
        HashMap annotations = meta.getAnnotations();
        if (annotations == null) {
            annotations = new HashMap();
            meta.setAnnotations(annotations);
        }
        annotations.remove(annotation);
    }

    private void addAnnotation(@NotNull V1alpha1PipelineConfig pc, String annotation, String name) {
        JSONArray jsonArray;
        String branchJson;
        V1ObjectMeta meta = pc.getMetadata();
        HashMap<String, String> annotations = meta.getAnnotations();
        if (annotations == null) {
            annotations = new HashMap<String, String>();
            meta.setAnnotations(annotations);
        }
        if ((branchJson = (String)annotations.get(annotation)) == null) {
            jsonArray = new JSONArray();
        } else {
            try {
                jsonArray = JSONArray.fromObject((Object)branchJson);
            }
            catch (JSONException e) {
                e.printStackTrace();
                jsonArray = new JSONArray();
            }
        }
        if (!jsonArray.contains((Object)name)) {
            jsonArray.add((Object)name);
        }
        annotations.put(annotation, jsonArray.toString());
    }

    private void delPRAnnotation(@NotNull WorkflowMultiBranchProject job, String branchName) {
        V1alpha1PipelineConfig pc = this.getPipelineConfig(job);
        if (pc == null) {
            return;
        }
        String name = pc.getMetadata().getName();
        V1alpha1PipelineConfig newPc = (V1alpha1PipelineConfig)DeepCopyUtils.deepCopy((Object)pc);
        this.delAnnotation(newPc, "alauda.io/jenkins.pr", name);
        Clients.get(V1alpha1PipelineConfig.class).update(pc, newPc);
    }

    private void delBranchAnnotation(@NotNull WorkflowMultiBranchProject job, String branchName) {
        V1alpha1PipelineConfig pc = this.getPipelineConfig(job);
        if (pc == null) {
            return;
        }
        String name = pc.getMetadata().getName();
        V1alpha1PipelineConfig newPc = (V1alpha1PipelineConfig)DeepCopyUtils.deepCopy((Object)pc);
        this.delAnnotation(newPc, "alauda.io/jenkins.branch", name);
        Clients.get(V1alpha1PipelineConfig.class).update(pc, newPc);
    }

    private void delStalePRAnnotation(@NotNull WorkflowMultiBranchProject job, String prName) {
        V1alpha1PipelineConfig pc = this.getPipelineConfig(job);
        if (pc == null) {
            return;
        }
        V1alpha1PipelineConfig newPc = (V1alpha1PipelineConfig)DeepCopyUtils.deepCopy((Object)pc);
        this.delAnnotation(newPc, "alauda.io/jenkins.stale.pr", prName);
        this.delAnnotation(newPc, "alauda.io/jenkins." + prName);
        this.delAnnotation(newPc, "alauda.io/jenkins." + prName + ".url");
        Clients.get(V1alpha1PipelineConfig.class).update(pc, newPc);
    }

    private void delStaleBranchAnnotation(@NotNull WorkflowMultiBranchProject job, String branchName) {
        V1alpha1PipelineConfig pc = this.getPipelineConfig(job);
        if (pc == null) {
            return;
        }
        String name = pc.getMetadata().getName();
        V1alpha1PipelineConfig newPc = (V1alpha1PipelineConfig)DeepCopyUtils.deepCopy((Object)pc);
        this.delAnnotation(newPc, "alauda.io/jenkins.stale.branch", branchName);
        this.delAnnotation(newPc, "alauda.io/jenkins." + branchName + ".url");
        Clients.get(V1alpha1PipelineConfig.class).update(pc, newPc);
    }

    private void delAnnotation(@NotNull V1alpha1PipelineConfig pc, String annotation, String name) {
        V1ObjectMeta meta = pc.getMetadata();
        Map annotations = meta.getAnnotations();
        if (annotations == null) {
            return;
        }
        String branchJson = (String)annotations.get(annotation);
        if (branchJson == null) {
            return;
        }
        try {
            JSONArray jsonArray = JSONArray.fromObject((Object)branchJson);
            jsonArray.remove((Object)name);
            annotations.put(annotation, jsonArray.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private V1alpha1PipelineConfig getPipelineConfig(WorkflowMultiBranchProject job) {
        AlaudaJobProperty pro = (AlaudaJobProperty)job.getProperties().get(MultiBranchProperty.class);
        if (pro == null) {
            logger.warning(String.format("No AlaudaJobProperty in job %s.", job.getFullName()));
            return null;
        }
        String namespace = pro.getNamespace();
        String name = pro.getName();
        return (V1alpha1PipelineConfig)Clients.get(V1alpha1PipelineConfig.class).lister().namespace(namespace).get(name);
    }
}

