/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.sync.credential;

import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.common.IdCredentials;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import hudson.Extension;
import io.alauda.jenkins.plugins.credentials.SecretUtils;
import io.alauda.jenkins.plugins.credentials.convertor.CredentialsConversionException;
import io.alauda.jenkins.plugins.credentials.convertor.SecretToCredentialConverter;
import io.kubernetes.client.models.V1Secret;

@Extension
public class OAuth2CredentialsConverter
extends SecretToCredentialConverter {
    public boolean canConvert(String s) {
        return "devops.alauda.io/oauth2".equals(s);
    }

    public IdCredentials convert(V1Secret secret) throws CredentialsConversionException {
        SecretUtils.requireNonNull((Object)secret.getData(), (String)"devops.alauda.io/oauth2 definition contains no data");
        String accessTokenKey = SecretUtils.getNonNullSecretData((V1Secret)secret, (String)"accessTokenKey", (String)"devops.alauda.io/oauth2 is missing the accessTokenKey");
        String clientSecret = SecretUtils.getNonNullSecretData((V1Secret)secret, (String)"accessToken", (String)"devops.alauda.io/oauth2 is missing the accessToken");
        return new UsernamePasswordCredentialsImpl(CredentialsScope.GLOBAL, SecretUtils.getCredentialId((V1Secret)secret), SecretUtils.getCredentialDescription((V1Secret)secret), accessTokenKey, clientSecret);
    }
}

