/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.sync.controller;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.PluginManager;
import hudson.model.Label;
import hudson.model.UpdateSite;
import io.alauda.devops.java.client.apis.DevopsAlaudaIoV1alpha1Api;
import io.alauda.devops.java.client.models.V1alpha1BindingCondition;
import io.alauda.devops.java.client.models.V1alpha1Jenkins;
import io.alauda.devops.java.client.models.V1alpha1JenkinsList;
import io.alauda.devops.java.client.models.V1alpha1JenkinsStatus;
import io.alauda.devops.java.client.utils.DeepCopyUtils;
import io.alauda.jenkins.devops.sync.AlaudaSyncGlobalConfiguration;
import io.alauda.jenkins.devops.sync.client.JenkinsClient;
import io.alauda.jenkins.devops.sync.controller.ResourceSyncController;
import io.alauda.jenkins.devops.sync.controller.ResourceSyncManager;
import io.kubernetes.client.JSON;
import io.kubernetes.client.extended.controller.Controller;
import io.kubernetes.client.extended.controller.builder.ControllerBuilder;
import io.kubernetes.client.extended.controller.builder.ControllerManagerBuilder;
import io.kubernetes.client.extended.controller.reconciler.Reconciler;
import io.kubernetes.client.extended.controller.reconciler.Request;
import io.kubernetes.client.extended.controller.reconciler.Result;
import io.kubernetes.client.extended.workqueue.WorkQueue;
import io.kubernetes.client.informer.SharedIndexInformer;
import io.kubernetes.client.informer.SharedInformerFactory;
import io.kubernetes.client.informer.cache.Lister;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import jenkins.plugins.linkedjobs.actions.LabelDashboardAction;
import jenkins.plugins.linkedjobs.model.LabelAtomData;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class JenkinsController
implements ResourceSyncController {
    private static final Logger logger = LoggerFactory.getLogger(JenkinsController.class);
    private static final String CONTROLLER_NAME = "JenkinsController";

    @Override
    public void add(ControllerManagerBuilder managerBuilder, SharedInformerFactory factory) {
        DevopsAlaudaIoV1alpha1Api api = new DevopsAlaudaIoV1alpha1Api();
        SharedIndexInformer informer = factory.getExistingSharedIndexInformer(V1alpha1Jenkins.class);
        if (informer == null) {
            informer = factory.sharedIndexInformerFor(params -> api.listJenkinsCall(null, null, null, null, null, null, params.resourceVersion, params.timeoutSeconds, params.watch, null, null), V1alpha1Jenkins.class, V1alpha1JenkinsList.class, TimeUnit.MINUTES.toMillis(5L));
        }
        Controller controller = ControllerBuilder.defaultBuilder((SharedInformerFactory)factory).watch(workQueue -> ControllerBuilder.controllerWatchBuilder(V1alpha1Jenkins.class, (WorkQueue)workQueue).withWorkQueueKeyFunc(jenkins -> new Request(jenkins.getMetadata().getName())).build()).withWorkerCount(1).withName(CONTROLLER_NAME).withReconciler((Reconciler)new JenkinsReconciler((Lister<V1alpha1Jenkins>)new Lister(informer.getIndexer()))).build();
        managerBuilder.addController(controller);
    }

    private static class NodeList {
        private List<String> labels;

        private NodeList() {
        }

        public List<String> getLabels() {
            return this.labels;
        }

        public void setLabels(List<String> labels) {
            this.labels = labels;
        }
    }

    private static class PluginStatus {
        private String name;
        private String version;
        private String description;
        private String status;
        private boolean updatable;

        private PluginStatus() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public boolean isUpdatable() {
            return this.updatable;
        }

        public void setUpdatable(boolean updatable) {
            this.updatable = updatable;
        }
    }

    private static class PluginList {
        private List<PluginStatus> plugins;

        private PluginList() {
        }

        public List<PluginStatus> getPlugins() {
            return this.plugins;
        }

        public void setPlugins(List<PluginStatus> plugins) {
            this.plugins = plugins;
        }
    }

    private class JenkinsReconciler
    implements Reconciler {
        private Lister<V1alpha1Jenkins> lister;

        public JenkinsReconciler(Lister<V1alpha1Jenkins> lister) {
            this.lister = lister;
        }

        public Result reconcile(Request request) {
            String configuredJenkinsServiceName;
            String jenkinsName = request.getName();
            if (!jenkinsName.equals(configuredJenkinsServiceName = AlaudaSyncGlobalConfiguration.get().getJenkinsService())) {
                logger.debug("[{}] Jenkins '{}' not matched the configured Jenkins Service '{}', will skip it", new Object[]{JenkinsController.CONTROLLER_NAME, jenkinsName, configuredJenkinsServiceName});
                return new Result(false);
            }
            V1alpha1Jenkins jenkins = (V1alpha1Jenkins)this.lister.get(jenkinsName);
            if (jenkins == null) {
                logger.error("[{}] Jenkins '{}' has been deleted, will stop syncing resource", (Object)JenkinsController.CONTROLLER_NAME, (Object)jenkinsName);
                ResourceSyncManager.getSyncManager().restart();
                return new Result(false);
            }
            V1alpha1Jenkins jenkinsCopy = (V1alpha1Jenkins)DeepCopyUtils.deepCopy((Object)jenkins);
            logger.debug("[{}] Add labels status to Jenkins '{}'", (Object)JenkinsController.CONTROLLER_NAME, (Object)jenkinsCopy);
            this.addLabelsCondition(jenkinsCopy);
            logger.debug("[{}] Add plugins status to Jenkins '{}'", (Object)JenkinsController.CONTROLLER_NAME, (Object)jenkinsCopy);
            this.addPluginsCondition(jenkinsCopy);
            logger.debug("[{}] Add warnings status to Jenkins '{}'", (Object)JenkinsController.CONTROLLER_NAME, (Object)jenkinsCopy);
            this.addWarningsCondition(jenkinsCopy);
            boolean succeed = JenkinsClient.getInstance().updateJenkins(jenkins, jenkinsCopy);
            if (!succeed) {
                new Result(true);
            }
            return new Result(false);
        }

        private void addLabelsCondition(V1alpha1Jenkins jenkins) {
            logger.debug("Starting find all active labels from Jenkins");
            ExtensionList labelActions = ExtensionList.lookup(LabelDashboardAction.class);
            List<Object> labels = new LinkedList();
            if (labelActions.size() == 0) {
                logger.warn("Cannot to get labels from Label Linked Jobs plugin, reason: unable to load LabelDashboardAction");
            } else {
                LabelDashboardAction labelDashboardAction = (LabelDashboardAction)labelActions.get(0);
                labelDashboardAction.getRefresh();
                labels.addAll(labelDashboardAction.getLabelsData().stream().map(LabelAtomData::getLabel).collect(Collectors.toList()));
            }
            labels.addAll(Jenkins.getInstance().getLabels().stream().flatMap(label -> label.listAtoms().stream()).map(Label::getName).collect(Collectors.toList()));
            labels = labels.stream().distinct().collect(Collectors.toList());
            logger.debug("Found {} labels", (Object)labels.size());
            NodeList nodeList = new NodeList();
            nodeList.setLabels(labels);
            this.addJenkinsStatusCondition(jenkins, new JSON().serialize((Object)nodeList), "nodes");
        }

        private void addPluginsCondition(V1alpha1Jenkins jenkins) {
            logger.debug("Starting to list plugin status");
            List<PluginStatus> pluginStatusList = this.getPluginsStatus();
            logger.debug("Found {} plugins", (Object)pluginStatusList.size());
            PluginList pluginList = new PluginList();
            pluginList.setPlugins(pluginStatusList);
            this.addJenkinsStatusCondition(jenkins, new JSON().serialize((Object)pluginList), "plugins");
        }

        private void addJenkinsStatusCondition(V1alpha1Jenkins jenkins, String status, String conditionName) {
            LinkedList<V1alpha1BindingCondition> conditions;
            V1alpha1JenkinsStatus jenkinsStatus = jenkins.getStatus();
            if (jenkinsStatus == null) {
                jenkins.setStatus(new V1alpha1JenkinsStatus());
            }
            if ((conditions = jenkins.getStatus().getConditions()) == null) {
                conditions = new LinkedList<V1alpha1BindingCondition>();
                jenkins.getStatus().setConditions(conditions);
            }
            Optional<V1alpha1BindingCondition> conditionOptional = conditions.stream().filter(c -> conditionName.equals(c.getName())).findAny();
            V1alpha1BindingCondition condition = null;
            if (conditionOptional.isPresent()) {
                condition = conditionOptional.get();
            } else {
                condition = new V1alpha1BindingCondition();
                condition.setName(conditionName);
                condition.setType("jenkins-status");
                conditions.add(condition);
            }
            condition.setMessage(status);
            condition.setLastAttempt(new DateTime());
        }

        private void addWarningsCondition(V1alpha1Jenkins jenkins) {
        }

        private List<PluginStatus> getPluginsStatus() {
            PluginManager pluginManager = Jenkins.getInstance().getPluginManager();
            LinkedList<PluginStatus> pluginStatusList = new LinkedList<PluginStatus>();
            pluginManager.getFailedPlugins().forEach(failedPlugin -> {
                PluginStatus pluginStatus = new PluginStatus();
                pluginStatus.setName(failedPlugin.name);
                pluginStatus.setDescription(failedPlugin.cause.getMessage());
                pluginStatus.setStatus("failed");
                pluginStatusList.add(pluginStatus);
            });
            pluginManager.getPlugins().forEach(plugin -> {
                PluginStatus pluginStatus = new PluginStatus();
                pluginStatus.setName(plugin.getLongName());
                UpdateSite.Plugin pluginInfo = plugin.getInfo();
                if (pluginInfo != null) {
                    pluginStatus.setDescription(pluginInfo.excerpt);
                }
                pluginStatus.setVersion(plugin.getVersion());
                pluginStatus.setStatus(plugin.isActive() ? "active" : "inactive");
                pluginStatus.setUpdatable(plugin.hasUpdate());
                pluginStatusList.add(pluginStatus);
            });
            return pluginStatusList;
        }
    }
}

