/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.sync.client;

import com.cloudbees.hudson.plugins.folder.AbstractFolderProperty;
import com.cloudbees.hudson.plugins.folder.Folder;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import hudson.BulkChange;
import hudson.model.AbstractItem;
import hudson.model.Actionable;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Queue;
import hudson.model.Saveable;
import hudson.model.TopLevelItem;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.util.XStream2;
import io.alauda.devops.java.client.apis.DevopsAlaudaIoV1alpha1Api;
import io.alauda.devops.java.client.models.V1alpha1Jenkins;
import io.alauda.devops.java.client.models.V1alpha1Pipeline;
import io.alauda.devops.java.client.models.V1alpha1PipelineConfig;
import io.alauda.devops.java.client.models.V1alpha1PipelineConfigStatus;
import io.alauda.devops.java.client.utils.DeepCopyUtils;
import io.alauda.devops.java.client.utils.PatchGenerator;
import io.alauda.jenkins.devops.sync.AlaudaFolderProperty;
import io.alauda.jenkins.devops.sync.JenkinsPipelineCause;
import io.alauda.jenkins.devops.sync.MultiBranchProperty;
import io.alauda.jenkins.devops.sync.PipelineConfigProjectProperty;
import io.alauda.jenkins.devops.sync.WorkflowJobProperty;
import io.alauda.jenkins.devops.sync.client.Clients;
import io.alauda.jenkins.devops.sync.exception.PipelineConfigConvertException;
import io.alauda.jenkins.devops.sync.mapper.PipelineConfigMapper;
import io.alauda.jenkins.devops.sync.util.JenkinsUtils;
import io.alauda.jenkins.devops.sync.util.NamespaceName;
import io.alauda.jenkins.devops.sync.util.PipelineConfigUtils;
import io.alauda.jenkins.devops.sync.util.PipelineUtils;
import io.kubernetes.client.ApiException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.xml.transform.stream.StreamSource;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.lang3.StringUtils;
import org.apache.tools.ant.filters.StringInputStream;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JenkinsClient {
    private Logger logger = LoggerFactory.getLogger((String)JenkinsClient.class.getName());
    private Map<NamespaceName, TopLevelItem> cachedJobMap = new ConcurrentHashMap<NamespaceName, TopLevelItem>();
    private Jenkins jenkins = Jenkins.getInstance();
    private PipelineConfigMapper mapper = new PipelineConfigMapper();
    private Set<NamespaceName> deleteInProgress = new HashSet<NamespaceName>();
    private static JenkinsClient instance = new JenkinsClient();
    private static final Pattern PIPELINE_CONFIG_EXACT_PATTERN = Pattern.compile("(.*)(-\\d+)");

    public static JenkinsClient getInstance() {
        return instance;
    }

    private JenkinsClient() {
    }

    @CheckForNull
    public Item getItem(NamespaceName namespaceName) {
        TopLevelItem item = this.cachedJobMap.get(namespaceName);
        if (item != null) {
            return item;
        }
        try (ACLContext ignored = ACL.as((Authentication)ACL.SYSTEM);){
            String jobPath = this.mapper.jenkinsJobPath(namespaceName.getNamespace(), namespaceName.getName());
            Item item2 = this.jenkins.getItemByFullName(jobPath);
            return item2;
        }
    }

    @CheckForNull
    public WorkflowJob getJob(NamespaceName namespaceName) {
        Item item = this.getItem(namespaceName);
        if (item == null) {
            return null;
        }
        if (item instanceof WorkflowJob) {
            return (WorkflowJob)item;
        }
        return null;
    }

    @CheckForNull
    public WorkflowMultiBranchProject getMultiBranchProject(NamespaceName namespaceName) {
        Item item = this.getItem(namespaceName);
        if (item == null) {
            return null;
        }
        if (item instanceof WorkflowMultiBranchProject) {
            return (WorkflowMultiBranchProject)item;
        }
        return null;
    }

    @CheckForNull
    public WorkflowJob getJob(V1alpha1Pipeline pipeline, V1alpha1PipelineConfig pipelineConfig) {
        Item item = this.getItem(new NamespaceName(pipelineConfig.getMetadata().getNamespace(), pipelineConfig.getMetadata().getName()));
        if (item == null) {
            return null;
        }
        if (item instanceof WorkflowJob) {
            return (WorkflowJob)item;
        }
        if (item instanceof WorkflowMultiBranchProject) {
            WorkflowMultiBranchProject project = (WorkflowMultiBranchProject)item;
            String branchName = (String)pipeline.getMetadata().getAnnotations().get("alauda.io/multiBranchName");
            if (StringUtils.isEmpty((CharSequence)branchName)) {
                return null;
            }
            try (ACLContext ignore = ACL.as((Authentication)ACL.SYSTEM);){
                WorkflowJob workflowJob = (WorkflowJob)project.getItemByBranchName(branchName);
                return workflowJob;
            }
        }
        return null;
    }

    public boolean hasSyncedJenkinsJob(V1alpha1PipelineConfig pipelineConfig) {
        String name;
        String namespace = pipelineConfig.getMetadata().getNamespace();
        NamespaceName namespaceName = new NamespaceName(namespace, name = pipelineConfig.getMetadata().getName());
        Item item = this.getItem(namespaceName);
        if (item == null) {
            return false;
        }
        if (item instanceof WorkflowJob) {
            WorkflowJob job = (WorkflowJob)item;
            WorkflowJobProperty property = this.getWorkflowJobProperty(job);
            if (property == null) {
                return false;
            }
            return pipelineConfig.getMetadata().getResourceVersion().equals(property.getResourceVersion());
        }
        if (item instanceof WorkflowMultiBranchProject) {
            WorkflowMultiBranchProject job = (WorkflowMultiBranchProject)item;
            MultiBranchProperty property = this.getMultiBranchProperty(job);
            if (property == null) {
                return false;
            }
            return pipelineConfig.getMetadata().getResourceVersion().equals(property.getResourceVersion());
        }
        return false;
    }

    @CheckForNull
    public WorkflowJobProperty getWorkflowJobProperty(@Nonnull WorkflowJob job) {
        WorkflowJobProperty wfJobProperty = (WorkflowJobProperty)job.getProperty(WorkflowJobProperty.class);
        if (wfJobProperty == null) {
            return (WorkflowJobProperty)job.getProperty(PipelineConfigProjectProperty.class);
        }
        return wfJobProperty;
    }

    @CheckForNull
    public MultiBranchProperty getMultiBranchProperty(@Nonnull WorkflowMultiBranchProject job) {
        return (MultiBranchProperty)job.getProperties().get(MultiBranchProperty.class);
    }

    public boolean upsertJob(V1alpha1PipelineConfig pipelineConfig) throws IOException, PipelineConfigConvertException {
        String namespace = pipelineConfig.getMetadata().getNamespace();
        String name = pipelineConfig.getMetadata().getName();
        NamespaceName namespaceName = new NamespaceName(namespace, name);
        this.logger.debug("Starting upsert Jenkins job");
        V1alpha1PipelineConfigStatus status = pipelineConfig.getStatus();
        if (status == null || !"Syncing".equals(status.getPhase())) {
            Item item = this.getItem(namespaceName);
            this.logger.debug("Phase of PipelineConfig '{}/{}' is {}, won't update it", new Object[]{namespace, name, status == null ? "Unknown" : status.getPhase()});
            if (item == null) {
                this.logger.warn("Unable to find correspondent Jenkins job for '{}/{}', not job found in jenkins, will try to create a job", (Object)namespaceName.getNamespace(), (Object)namespaceName.getName());
                V1alpha1PipelineConfig pipelineConfigCopy = (V1alpha1PipelineConfig)DeepCopyUtils.deepCopy((Object)pipelineConfig);
                pipelineConfigCopy.getStatus().setPhase("Syncing");
                Clients.get(V1alpha1PipelineConfig.class).update(pipelineConfig, pipelineConfigCopy);
                return false;
            }
            if (!(item instanceof WorkflowJob) && !(item instanceof WorkflowMultiBranchProject)) {
                this.logger.warn("Unable to find correspondent Jenkins job for '{}/{}', expect WorkflowJob or WorkflowMultiBranchProject but found {}", new Object[]{namespaceName.getNamespace(), namespaceName.getName(), item.getClass().getName()});
                throw new PipelineConfigConvertException(new String[]{String.format("Unexpect Jenkins job %s found in Jenkins", item.getClass().getName())});
            }
            TopLevelItem job = (TopLevelItem)item;
            if (this.cachedJobMap.putIfAbsent(namespaceName, job) == null) {
                this.logger.debug("Added PipelineConfig '{}/{}', phase {} to in-memory cache map", new Object[]{namespace, name, status != null ? status.getPhase() : "Unknown"});
            }
            return false;
        }
        this.logger.debug("Will upsertJob");
        try (ACLContext ignored = ACL.as((Authentication)ACL.SYSTEM);){
            Item jobInJenkins = this.getItem(namespaceName);
            if (jobInJenkins != null) {
                this.logger.debug("Found correspondent Jenkins job {} for PipelineConfig '{}/{}'", new Object[]{jobInJenkins.getDisplayName(), namespace, name});
            }
            TopLevelItem jobInMemory = this.mapper.mapTo(pipelineConfig);
            StringInputStream jobStream = new StringInputStream(new XStream2().toXML((Object)jobInMemory));
            if (jobInJenkins == null) {
                ItemGroup parent = jobInMemory.getParent();
                if (parent instanceof Folder) {
                    ((Folder)parent).createProjectFromXML(this.mapper.jenkinsJobName(namespace, name), (InputStream)jobStream).save();
                }
            } else {
                ((AbstractItem)jobInJenkins).updateByXml(new StreamSource((InputStream)jobStream));
            }
            Item item = this.getItem(namespaceName);
            if (item == null) {
                throw new PipelineConfigConvertException(new String[]{String.format("Failed to create Jenkins job for PipelineConfig '%s/%s'", namespace, name)});
            }
            TopLevelItem job = (TopLevelItem)item;
            if (this.cachedJobMap.putIfAbsent(namespaceName, job) == null) {
                this.logger.debug("Added PipelineConfig '{}/{}', phase {} to in-memory cache map", new Object[]{namespace, name, status.getPhase() != null ? status.getPhase() : "Unknown"});
            }
        }
        return true;
    }

    /*
     * Loose catch block
     */
    public boolean deleteJob(NamespaceName namespaceName) throws IOException, InterruptedException {
        TopLevelItem job = this.cachedJobMap.remove(namespaceName);
        if (job == null) {
            Item item = this.getItem(namespaceName);
            if (item == null) {
                this.logger.warn("Unable to delete correspondent Jenkins job for '{}/{}', not job found in jenkins", (Object)namespaceName.getNamespace(), (Object)namespaceName.getName());
                return false;
            }
            if (!(item instanceof WorkflowJob) && !(item instanceof WorkflowMultiBranchProject)) {
                this.logger.warn("Unable to delete correspondent Jenkins job for '{}/{}', except WorkflowJob or WorkflowMultiBranchProject but found {}", new Object[]{namespaceName.getNamespace(), namespaceName.getName(), item.getClass().getName()});
                return false;
            }
            job = (TopLevelItem)item;
        }
        try {
            try (ACLContext ignored = ACL.as((Authentication)ACL.SYSTEM);){
                this.deleteInProgress.add(namespaceName);
                job.delete();
                boolean bl = true;
                return bl;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.deleteInProgress.remove(namespaceName);
        }
    }

    public boolean deletePipeline(NamespaceName pipelineNamespaceName) {
        String namespace = pipelineNamespaceName.getNamespace();
        String name = pipelineNamespaceName.getName();
        this.cancelPipeline(pipelineNamespaceName);
        V1alpha1PipelineConfig pipelineConfig = this.getPipelineConfigFromPipeline(pipelineNamespaceName);
        if (pipelineConfig == null) {
            this.logger.error("Unable to cancel pipeline '{}/{}', reason: cannot find pipelineConfig", (Object)namespace, (Object)name);
            return false;
        }
        if (PipelineConfigUtils.isMultiBranch(pipelineConfig)) {
            WorkflowMultiBranchProject multiBranchProject = this.getMultiBranchProject(new NamespaceName(namespace, pipelineConfig.getMetadata().getName()));
            if (multiBranchProject == null) {
                this.logger.error("Unable to cancel pipeline, reason: cannot find correspondent multi-branch job");
                return false;
            }
            boolean canceled = false;
            try (ACLContext ignore = ACL.as((Authentication)ACL.SYSTEM);){
                for (WorkflowJob job : multiBranchProject.getItems()) {
                    canceled = this.deletePipeline(pipelineNamespaceName, job);
                }
            }
            return canceled;
        }
        WorkflowJob job = this.getJob(new NamespaceName(namespace, pipelineConfig.getMetadata().getName()));
        if (job == null) {
            this.logger.error("Unable to cancel pipeline, reason: cannot find correspondent workflow job");
            return false;
        }
        return this.cancelPipeline(pipelineNamespaceName, job);
    }

    public boolean deletePipeline(NamespaceName namespaceName, WorkflowJob job) {
        try (ACLContext ignore = ACL.as((Authentication)ACL.SYSTEM);){
            for (WorkflowRun run : job.getBuilds()) {
                JenkinsPipelineCause cause = PipelineUtils.findAlaudaCause((Actionable)run);
                if (cause == null || !cause.getName().equals(namespaceName.getName()) || !cause.getNamespace().equals(namespaceName.getNamespace())) continue;
                JenkinsUtils.deleteRun(run);
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public boolean cancelPipeline(NamespaceName pipelineNamespaceName) {
        String namespace = pipelineNamespaceName.getNamespace();
        String name = pipelineNamespaceName.getName();
        V1alpha1PipelineConfig pipelineConfig = this.getPipelineConfigFromPipeline(pipelineNamespaceName);
        if (pipelineConfig == null) {
            this.logger.error("Unable to cancel pipeline '{}/{}', reason: cannot find pipelineConfig", (Object)namespace, (Object)name);
            return false;
        }
        try (ACLContext ignore = ACL.as((Authentication)ACL.SYSTEM);){
            Queue pipelineQueue = this.jenkins.getQueue();
            for (Queue.Item item : pipelineQueue.getItems()) {
                for (JenkinsPipelineCause cause : PipelineUtils.findAllAlaudaCauses((Actionable)item)) {
                    if (!cause.getNamespace().equals(namespace) || !cause.getName().equals(name)) continue;
                    boolean bl = pipelineQueue.cancel(item);
                    return bl;
                }
            }
        }
        if (PipelineConfigUtils.isMultiBranch(pipelineConfig)) {
            WorkflowMultiBranchProject multiBranchProject = this.getMultiBranchProject(new NamespaceName(namespace, pipelineConfig.getMetadata().getName()));
            if (multiBranchProject == null) {
                this.logger.error("Unable to cancel pipeline, reason: cannot find correspondent multi-branch job");
                return false;
            }
            boolean canceled = false;
            ACLContext ignore = ACL.as((Authentication)ACL.SYSTEM);
            Object object = null;
            try {
                for (WorkflowJob job : multiBranchProject.getItems()) {
                    canceled = this.cancelPipeline(pipelineNamespaceName, job);
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (ignore != null) {
                    if (object != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ignore.close();
                    }
                }
            }
            return canceled;
        }
        WorkflowJob job = this.getJob(new NamespaceName(namespace, pipelineConfig.getMetadata().getName()));
        if (job == null) {
            this.logger.error("Unable to cancel pipeline, reason: cannot find correspondent workflow job");
            return false;
        }
        return this.cancelPipeline(pipelineNamespaceName, job);
    }

    public boolean cancelPipeline(NamespaceName namespaceName, WorkflowJob job) {
        try (ACLContext ignore = ACL.as((Authentication)ACL.SYSTEM);){
            for (WorkflowRun run : job.getBuilds()) {
                JenkinsPipelineCause cause = PipelineUtils.findAlaudaCause((Actionable)run);
                if (cause == null || !cause.getName().equals(namespaceName.getName()) || !cause.getNamespace().equals(namespaceName.getNamespace()) || !run.hasntStartedYet() && !run.isBuilding()) continue;
                JenkinsUtils.terminateRun(run);
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public V1alpha1PipelineConfig getPipelineConfigFromPipeline(NamespaceName namespaceName) {
        String namespace = namespaceName.getNamespace();
        String name = namespaceName.getName();
        Matcher pipelineConfigNameMatcher = PIPELINE_CONFIG_EXACT_PATTERN.matcher(name);
        if (!pipelineConfigNameMatcher.matches()) {
            this.logger.error("Unable to exact pipelineConfig name from Pipeline '{}/{}'", (Object)namespace, (Object)name);
            return null;
        }
        String pipelineConfigName = pipelineConfigNameMatcher.group(1);
        return (V1alpha1PipelineConfig)Clients.get(V1alpha1PipelineConfig.class).lister().namespace(namespace).get(pipelineConfigName);
    }

    public Folder getFolder(String folderName) {
        try (ACLContext ignored = ACL.as((Authentication)ACL.SYSTEM);){
            Item folder = this.jenkins.getItemByFullName(folderName);
            if (folder == null) {
                Folder folder2 = null;
                return folder2;
            }
            if (!(folder instanceof Folder)) {
                Folder folder3 = null;
                return folder3;
            }
            Folder folder4 = (Folder)folder;
            return folder4;
        }
    }

    public Folder upsertFolder(String folderName) throws IOException {
        try (ACLContext ignored = ACL.as((Authentication)ACL.SYSTEM);){
            Folder folder = this.getFolder(folderName);
            if (folder != null) {
                AlaudaFolderProperty alaPro = (AlaudaFolderProperty)folder.getProperties().get(AlaudaFolderProperty.class);
                if (alaPro == null) {
                    folder.addProperty((AbstractFolderProperty)new AlaudaFolderProperty());
                } else {
                    alaPro.setDirty(false);
                }
                folder.save();
                Folder folder2 = folder;
                return folder2;
            }
            folder = new Folder((ItemGroup)this.jenkins, folderName);
            folder.setDescription("Folder for the Alauda DevOps project: " + folderName);
            folder.addProperty((AbstractFolderProperty)new AlaudaFolderProperty());
            BulkChange bk = new BulkChange((Saveable)folder);
            StringInputStream jobStream = new StringInputStream(new XStream2().toXML((Object)folder));
            this.jenkins.createProjectFromXML(folderName, (InputStream)jobStream).save();
            bk.commit();
            folder = this.getFolder(folderName);
            if (folder != null) {
                Folder folder3 = folder;
                return folder3;
            }
        }
        return null;
    }

    public Jenkins getJenkins() {
        return this.jenkins;
    }

    public boolean isDeleteInProgress(String namespace, String name) {
        return this.deleteInProgress.add(new NamespaceName(namespace, name));
    }

    public boolean updateJenkins(V1alpha1Jenkins oldJenkins, V1alpha1Jenkins newJenkins) {
        String patch;
        String name = oldJenkins.getMetadata().getName();
        try {
            patch = new PatchGenerator().generatePatchBetween((Object)oldJenkins, (Object)newJenkins);
        }
        catch (IOException e) {
            this.logger.warn("Failed to update Jenkins '{}', unable to generate patch, reason: {}", (Object)name, (Object)e.getMessage());
            return false;
        }
        this.logger.debug("Patch: {}", (Object)patch);
        LinkedList body = new LinkedList();
        JsonArray arr = (JsonArray)new Gson().fromJson(patch, JsonArray.class);
        arr.forEach(jsonElement -> body.add(jsonElement.getAsJsonObject()));
        DevopsAlaudaIoV1alpha1Api api = new DevopsAlaudaIoV1alpha1Api();
        try {
            api.patchJenkins(name, body, null, null);
        }
        catch (ApiException e) {
            this.logger.warn("Failed to update Jenkins '{}', reason: {}", (Object)name, (Object)e.getMessage());
            return false;
        }
        return true;
    }
}

