/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.sync.action;

import hudson.Extension;
import hudson.model.UnprotectedRootAction;
import hudson.util.HttpResponses;
import io.alauda.jenkins.devops.sync.util.JenkinsUtils;
import javax.annotation.CheckForNull;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
public class JenkinsfileFormatAction
implements UnprotectedRootAction {
    public static final String FORMATTER_URL = "alaudaFormatter";

    @RequirePOST
    public HttpResponse doFormatJenkinsfile(StaplerRequest req) {
        JSONObject result = new JSONObject();
        String jenkinsfile = req.getParameter("jenkinsfile");
        if (!StringUtils.isEmpty((CharSequence)jenkinsfile)) {
            try {
                String formattedJenkinsfile = JenkinsUtils.formatJenkinsfile(jenkinsfile);
                result.accumulate("result", (Object)"success");
                result.accumulate("jenkinsfile", (Object)formattedJenkinsfile);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.reportFailure(result, e.getMessage());
            }
        } else {
            this.reportFailure(result, "No content found for 'jenkinsfile' parameter");
        }
        return HttpResponses.okJSON((JSONObject)result);
    }

    private void reportFailure(JSONObject result, String message) {
        JSONArray errors = new JSONArray();
        JSONObject o = new JSONObject();
        o.accumulate("error", (Object)message);
        errors.add((Object)o);
        this.reportFailure(result, errors);
    }

    private void reportFailure(JSONObject result, JSONArray errors) {
        result.accumulate("result", (Object)"failure");
        result.accumulate("errors", (Object)errors);
    }

    @CheckForNull
    public String getIconFileName() {
        return null;
    }

    @CheckForNull
    public String getDisplayName() {
        return null;
    }

    @CheckForNull
    public String getUrlName() {
        return FORMATTER_URL;
    }
}

