/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.sync;

import hudson.model.BooleanParameterDefinition;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.StringParameterDefinition;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.UserRemoteConfig;
import hudson.scm.SCM;
import hudson.scm.SubversionSCM;
import hudson.triggers.SCMTrigger;
import hudson.triggers.TimerTrigger;
import io.alauda.devops.java.client.models.V1alpha1Condition;
import io.alauda.devops.java.client.models.V1alpha1PipelineConfig;
import io.alauda.devops.java.client.models.V1alpha1PipelineConfigSpec;
import io.alauda.devops.java.client.models.V1alpha1PipelineParameter;
import io.alauda.devops.java.client.models.V1alpha1PipelineParameterBuilder;
import io.alauda.devops.java.client.models.V1alpha1PipelineSource;
import io.alauda.devops.java.client.models.V1alpha1PipelineSourceGit;
import io.alauda.devops.java.client.models.V1alpha1PipelineSourceSvn;
import io.alauda.devops.java.client.models.V1alpha1PipelineStrategy;
import io.alauda.devops.java.client.models.V1alpha1PipelineStrategyJenkins;
import io.alauda.devops.java.client.models.V1alpha1PipelineTrigger;
import io.alauda.devops.java.client.models.V1alpha1PipelineTriggerBuilder;
import io.alauda.devops.java.client.models.V1alpha1PipelineTriggerCron;
import io.alauda.devops.java.client.models.V1alpha1PipelineTriggerFluent;
import io.alauda.jenkins.devops.sync.util.AlaudaUtils;
import io.alauda.jenkins.devops.sync.util.CredentialsUtils;
import io.alauda.jenkins.devops.sync.util.NamespaceName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.branch.Branch;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.cps.CpsScmFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.multibranch.BranchJobProperty;

public abstract class PipelineConfigToJobMapper {
    private static final Logger LOGGER = Logger.getLogger(PipelineConfigToJobMapper.class.getName());

    private PipelineConfigToJobMapper() {
    }

    public static FlowDefinition mapPipelineConfigToFlow(V1alpha1PipelineConfig pc) throws IOException {
        if (!AlaudaUtils.isPipelineStrategyPipelineConfig(pc)) {
            return null;
        }
        V1alpha1PipelineConfigSpec spec = pc.getSpec();
        V1alpha1PipelineSource source = null;
        String jenkinsfile = null;
        String jenkinsfilePath = null;
        if (spec != null) {
            V1alpha1PipelineStrategyJenkins pipelineStrategyJenkins;
            source = spec.getSource();
            V1alpha1PipelineStrategy strategy = spec.getStrategy();
            if (strategy != null && (pipelineStrategyJenkins = strategy.getJenkins()) != null) {
                jenkinsfile = pipelineStrategyJenkins.getJenkinsfile();
                jenkinsfilePath = pipelineStrategyJenkins.getJenkinsfilePath();
            }
        }
        if (StringUtils.isBlank(jenkinsfile)) {
            if (AlaudaUtils.isValidSource(source)) {
                if (jenkinsfilePath == null) {
                    jenkinsfilePath = "Jenkinsfile";
                }
                SCM scm = PipelineConfigToJobMapper.createSCM(pc);
                return new CpsScmFlowDefinition(scm, jenkinsfilePath);
            }
            V1alpha1Condition condition = new V1alpha1Condition();
            condition.setReason("invalid source");
            condition.setMessage("please check git uri");
            pc.getStatus().getConditions().add(condition);
            LOGGER.warning("PipelineConfig does not contain source repository information - cannot map PipelineConfig to Jenkins job");
            return null;
        }
        return new CpsFlowDefinition(jenkinsfile, true);
    }

    private static V1alpha1PipelineTrigger findPipelineTriggers(@Nonnull V1alpha1PipelineConfig pipelineConfig, @Nonnull String type) {
        List triggers = pipelineConfig.getSpec().getTriggers();
        if (triggers == null) {
            return null;
        }
        for (V1alpha1PipelineTrigger trigger : triggers) {
            if (!trigger.getType().equals(type)) continue;
            return trigger;
        }
        return null;
    }

    private static void updateTrigger(WorkflowJob job, V1alpha1PipelineConfig pipelineConfig) {
        V1alpha1PipelineTrigger cronTrigger;
        Map triggers = job.getTriggers();
        if (triggers == null) {
            return;
        }
        List pipelineConfigTriggers = pipelineConfig.getSpec().getTriggers();
        if (pipelineConfigTriggers == null) {
            pipelineConfig.getSpec().setTriggers(new ArrayList());
            cronTrigger = null;
        } else {
            pipelineConfigTriggers.clear();
            Optional<V1alpha1PipelineTrigger> triggerOptional = pipelineConfigTriggers.stream().filter(trigger -> "cron".equals(trigger.getType())).findFirst();
            cronTrigger = triggerOptional.orElse(null);
        }
        triggers.forEach((desc, trigger) -> {
            V1alpha1PipelineTrigger pipelineTrigger = null;
            if (trigger instanceof SCMTrigger) {
                pipelineTrigger = ((V1alpha1PipelineTriggerBuilder)((V1alpha1PipelineTriggerFluent.CodeChangeNested)((V1alpha1PipelineTriggerFluent.CodeChangeNested)((V1alpha1PipelineTriggerBuilder)new V1alpha1PipelineTriggerBuilder().withType("codeChange")).withNewCodeChange().withEnabled(Boolean.valueOf(true))).withPeriodicCheck(trigger.getSpec())).endCodeChange()).build();
            } else if (trigger instanceof TimerTrigger) {
                if (cronTrigger == null) {
                    pipelineTrigger = ((V1alpha1PipelineTriggerBuilder)((V1alpha1PipelineTriggerFluent.CronNested)((V1alpha1PipelineTriggerFluent.CronNested)((V1alpha1PipelineTriggerBuilder)new V1alpha1PipelineTriggerBuilder().withType("cron")).withNewCron().withEnabled(Boolean.valueOf(true))).withRule(trigger.getSpec())).endCron()).build();
                } else {
                    V1alpha1PipelineTriggerCron cron = new V1alpha1PipelineTriggerCron();
                    cron.setEnabled(Boolean.valueOf(true));
                    cron.setRule(trigger.getSpec());
                    cronTrigger.setCron(cron);
                    pipelineTrigger = cronTrigger;
                }
            }
            if (pipelineTrigger != null) {
                pipelineConfig.getSpec().getTriggers().add(pipelineTrigger);
            } else {
                LOGGER.warning(() -> "Not support trigger type : " + trigger.getClass());
            }
        });
    }

    public static boolean updatePipelineConfigFromJob(WorkflowJob job, V1alpha1PipelineConfig pipelineConfig) {
        Branch branch;
        V1alpha1PipelineStrategy strategy;
        NamespaceName namespaceName = new NamespaceName(pipelineConfig.getMetadata().getNamespace(), pipelineConfig.getMetadata().getName());
        V1alpha1PipelineStrategyJenkins pipelineStrategyJenkins = null;
        V1alpha1PipelineConfigSpec spec = pipelineConfig.getSpec();
        if (spec != null) {
            strategy = spec.getStrategy();
            if (strategy == null) {
                LOGGER.warning(() -> "No available JenkinsPipelineStrategy in the PipelineConfig " + namespaceName);
                return false;
            }
        } else {
            LOGGER.warning("Not spec in PipelineConfig");
            return false;
        }
        pipelineStrategyJenkins = strategy.getJenkins();
        PipelineConfigToJobMapper.updateTrigger(job, pipelineConfig);
        PipelineConfigToJobMapper.updateParameters(job, pipelineConfig);
        FlowDefinition definition = job.getDefinition();
        if (definition instanceof CpsScmFlowDefinition) {
            CpsScmFlowDefinition cpsScmFlowDefinition = (CpsScmFlowDefinition)definition;
            String scriptPath = cpsScmFlowDefinition.getScriptPath();
            if (scriptPath != null && scriptPath.trim().length() > 0) {
                SCM scm;
                boolean rc = false;
                V1alpha1PipelineSource source = AlaudaUtils.getOrCreatePipelineSource(pipelineConfig);
                if (!scriptPath.equals(pipelineStrategyJenkins.getJenkinsfilePath())) {
                    LOGGER.log(Level.FINE, "updating PipelineConfig " + namespaceName + " jenkinsfile path to " + scriptPath + " from ");
                    rc = true;
                    pipelineStrategyJenkins.setJenkinsfilePath(scriptPath);
                }
                if ((scm = cpsScmFlowDefinition.getScm()) instanceof GitSCM) {
                    PipelineConfigToJobMapper.populateFromGitSCM(pipelineConfig, source, (GitSCM)scm, null);
                    LOGGER.log(Level.FINE, "updating bc " + namespaceName);
                    rc = true;
                } else if (scm instanceof SubversionSCM) {
                    PipelineConfigToJobMapper.populateFromSvnSCM(pipelineConfig, source, (SubversionSCM)scm);
                    LOGGER.log(Level.FINE, "updating bc " + namespaceName);
                    rc = true;
                } else {
                    LOGGER.warning(() -> "Not support scm type: " + scm);
                }
                return rc;
            }
            return false;
        }
        if (definition instanceof CpsFlowDefinition) {
            CpsFlowDefinition cpsFlowDefinition = (CpsFlowDefinition)definition;
            String jenkinsfile = cpsFlowDefinition.getScript();
            if (jenkinsfile != null && jenkinsfile.trim().length() > 0 && !jenkinsfile.equals(pipelineStrategyJenkins.getJenkinsfile())) {
                LOGGER.log(Level.FINE, "updating PipelineConfig " + namespaceName + " jenkinsfile to " + jenkinsfile + " where old jenkinsfile was " + pipelineStrategyJenkins.getJenkinsfile());
                pipelineStrategyJenkins.setJenkinsfile(jenkinsfile);
                return true;
            }
            return false;
        }
        BranchJobProperty property = (BranchJobProperty)job.getProperty(BranchJobProperty.class);
        if (property != null && (branch = property.getBranch()) != null) {
            String ref = branch.getName();
            SCM scm = branch.getScm();
            V1alpha1PipelineSource source = AlaudaUtils.getOrCreatePipelineSource(pipelineConfig);
            if (scm instanceof GitSCM && PipelineConfigToJobMapper.populateFromGitSCM(pipelineConfig, source, (GitSCM)scm, ref)) {
                if (StringUtils.isEmpty((String)pipelineStrategyJenkins.getJenkinsfilePath())) {
                    pipelineStrategyJenkins.setJenkinsfilePath("Jenkinsfile");
                }
                return true;
            }
        }
        LOGGER.warning("Cannot update PipelineConfig " + namespaceName + " as the definition is of class " + (definition == null ? "null" : definition.getClass().getName()));
        return false;
    }

    private static void updateParameters(WorkflowJob job, V1alpha1PipelineConfig pipelineConfig) {
        V1alpha1PipelineConfigSpec spec = pipelineConfig.getSpec();
        if (spec.getParameters() == null) {
            spec.setParameters(new ArrayList());
        } else {
            spec.getParameters().clear();
        }
        ParametersDefinitionProperty paramsDefPro = (ParametersDefinitionProperty)job.getProperty(ParametersDefinitionProperty.class);
        if (paramsDefPro == null) {
            LOGGER.log(Level.FINE, "No parameters define property for job {0}", job);
            return;
        }
        List paramDefs = paramsDefPro.getParameterDefinitions();
        if (paramDefs == null || paramDefs.size() == 0) {
            LOGGER.log(Level.FINE, "No parameters defined for job {0}", job);
            return;
        }
        for (ParameterDefinition def : paramDefs) {
            spec.getParameters().add(PipelineConfigToJobMapper.convertTo(def));
        }
    }

    public static boolean isSupportParamType(@Nonnull ParameterDefinition paramDef) {
        return StringParameterDefinition.class.equals(paramDef.getClass()) || BooleanParameterDefinition.class.equals(paramDef.getClass());
    }

    @Nonnull
    private static V1alpha1PipelineParameter convertTo(ParameterDefinition def) {
        if (!PipelineConfigToJobMapper.isSupportParamType(def)) {
            String errDesc = "Not support type:" + def.getType() + ", please fix these.";
            def = new StringParameterDefinition(def.getName(), "", errDesc);
        }
        String value = "";
        ParameterValue defVal = def.getDefaultParameterValue();
        if (defVal != null && defVal.getValue() != null) {
            value = defVal.getValue().toString();
        }
        return ((V1alpha1PipelineParameterBuilder)((V1alpha1PipelineParameterBuilder)((V1alpha1PipelineParameterBuilder)((V1alpha1PipelineParameterBuilder)new V1alpha1PipelineParameterBuilder().withType(PipelineConfigToJobMapper.paramType(def))).withName(def.getName())).withValue(value)).withDescription(def.getDescription())).build();
    }

    private static String paramType(@Nonnull ParameterDefinition parameterDefinition) {
        return parameterDefinition.getType();
    }

    private static boolean populateFromGitSCM(V1alpha1PipelineConfig pipelineConfig, V1alpha1PipelineSource source, GitSCM gitSCM, String ref) {
        URIish urIish;
        String gitUrl;
        RemoteConfig remoteConfig;
        List urIs;
        if (source.getGit() == null) {
            source.setGit(new V1alpha1PipelineSourceGit());
        }
        source.setSourceType("GIT");
        List repositories = gitSCM.getRepositories();
        if (repositories != null && repositories.size() > 0 && (urIs = (remoteConfig = (RemoteConfig)repositories.get(0)).getURIs()) != null && urIs.size() > 0 && (gitUrl = (urIish = (URIish)urIs.get(0)).toString()) != null && gitUrl.length() > 0) {
            List branches;
            if (StringUtils.isEmpty((String)ref) && (branches = gitSCM.getBranches()) != null && branches.size() > 0) {
                BranchSpec branchSpec = (BranchSpec)branches.get(0);
                String branch = branchSpec.getName();
                while (branch.startsWith("*") || branch.startsWith("/")) {
                    branch = branch.substring(1);
                }
                if (!branch.isEmpty()) {
                    ref = branch;
                }
            }
            AlaudaUtils.updateGitSourceUrl(pipelineConfig, gitUrl, ref);
            return true;
        }
        return false;
    }

    private static boolean populateFromSvnSCM(V1alpha1PipelineConfig pipelineConfig, V1alpha1PipelineSource source, SubversionSCM subversionSCM) {
        if (source.getSvn() == null) {
            source.setSvn(new V1alpha1PipelineSourceSvn());
        }
        source.setSourceType("SVN");
        SubversionSCM.ModuleLocation[] locations = subversionSCM.getLocations();
        if (locations != null && locations.length > 0) {
            SubversionSCM.ModuleLocation location = locations[0];
            String url = location.getURL();
            AlaudaUtils.updateSvnSourceUrl(pipelineConfig, url);
            return true;
        }
        return false;
    }

    private static SCM createSCM(V1alpha1PipelineConfig pc) throws IOException {
        V1alpha1PipelineSource source = pc.getSpec().getSource();
        if (AlaudaUtils.isValidGitSource(source) && (source.getSourceType().equals("GIT") || source.getSourceType().equals(""))) {
            return PipelineConfigToJobMapper.createGitSCM(pc, source);
        }
        if (AlaudaUtils.isValidSvnSource(source) && source.getSourceType().equals("SVN")) {
            return PipelineConfigToJobMapper.createSvnSCM(pc, source);
        }
        return null;
    }

    private static GitSCM createGitSCM(V1alpha1PipelineConfig pc, V1alpha1PipelineSource source) throws IOException {
        V1alpha1PipelineSourceGit gitSource = source.getGit();
        String branchRef = gitSource.getRef();
        List<Object> branchSpecs = Collections.emptyList();
        if (StringUtils.isNotBlank((String)branchRef)) {
            branchSpecs = Collections.singletonList(new BranchSpec(branchRef));
        }
        String credentialId = CredentialsUtils.getSCMSourceCredentialsId(pc);
        List<UserRemoteConfig> configs = Collections.singletonList(new UserRemoteConfig(gitSource.getUri(), null, null, credentialId));
        return new GitSCM(configs, branchSpecs, Boolean.valueOf(false), Collections.emptyList(), null, null, Collections.emptyList());
    }

    private static SubversionSCM createSvnSCM(V1alpha1PipelineConfig pc, V1alpha1PipelineSource source) throws IOException {
        V1alpha1PipelineSourceSvn svnSource = source.getSvn();
        String credentialId = CredentialsUtils.getSCMSourceCredentialsId(pc);
        return new SubversionSCM(svnSource.getUri(), credentialId, ".");
    }
}

