/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.sync;

import hudson.Extension;
import io.alauda.jenkins.devops.sync.PrivateGitProviderMultiBranch;
import io.alauda.jenkins.devops.sync.constants.CodeRepoServices;
import java.lang.reflect.InvocationTargetException;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.trait.SCMHeadAuthority;
import jenkins.scm.api.trait.SCMSourceTrait;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
@Restricted(value={NoExternalUse.class})
public class GitLabProviderMultiBranch
implements PrivateGitProviderMultiBranch {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitLabProviderMultiBranch.class);

    @Override
    public boolean accept(String type) {
        return CodeRepoServices.Gitlab.name().equals(type);
    }

    @Override
    public SCMSource getSCMSource(String server, String repoOwner, String repository) {
        try {
            Class<?> scmSource = this.loadClass("io.jenkins.plugins.gitlabbranchsource.GitLabSCMSource");
            return (SCMSource)scmSource.getConstructor(String.class, String.class, String.class).newInstance(server, repoOwner, repository);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.warn("Exception happened while getSCMSource", (Throwable)e);
            return null;
        }
    }

    @Override
    public SCMSourceTrait getBranchDiscoverTrait(int code) {
        try {
            Class<?> discoverBranchClz = this.loadClass("io.jenkins.plugins.gitlabbranchsource.BranchDiscoveryTrait");
            return (SCMSourceTrait)discoverBranchClz.getConstructor(Integer.TYPE).newInstance(code);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.warn("Exception happened while getBranchDiscoverTrait", (Throwable)e);
            return null;
        }
    }

    @Override
    public SCMSourceTrait getOriginPRTrait(int code) {
        try {
            Class<?> discoverBranchClz = this.loadClass("io.jenkins.plugins.gitlabbranchsource.OriginMergeRequestDiscoveryTrait");
            return (SCMSourceTrait)discoverBranchClz.getConstructor(Integer.TYPE).newInstance(code);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.warn("Exception happened while getOriginPRTrait", (Throwable)e);
            return null;
        }
    }

    @Override
    public SCMSourceTrait getForkPRTrait(int code) {
        try {
            Class<?> discoverBranchClz = this.loadClass("io.jenkins.plugins.gitlabbranchsource.ForkMergeRequestDiscoveryTrait");
            Class<?> trustClz = this.loadClass("io.jenkins.plugins.gitlabbranchsource.ForkMergeRequestDiscoveryTrait$TrustPermission");
            return (SCMSourceTrait)discoverBranchClz.getConstructor(Integer.TYPE, SCMHeadAuthority.class).newInstance(code, trustClz.newInstance());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.warn("Exception happened while getForkPRTrait", (Throwable)e);
            return null;
        }
    }
}

