/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.sync;

import hudson.Extension;
import hudson.model.AdministrativeMonitor;
import hudson.util.HttpResponses;
import io.alauda.jenkins.devops.sync.controller.ResourceSyncManager;
import java.io.IOException;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
@Symbol(value={"alaudaSyncSetting"})
public class AlaudaSyncSettingMonitor
extends AdministrativeMonitor {
    public static final String ID = "AlaudaSyncSetting";
    private String message;

    static AlaudaSyncSettingMonitor get(Jenkins j) {
        return (AlaudaSyncSettingMonitor)j.getAdministrativeMonitor(ID);
    }

    public AlaudaSyncSettingMonitor() {
        super(ID);
    }

    public String getDisplayName() {
        return ID;
    }

    public boolean isActivated() {
        boolean isStarted = ResourceSyncManager.getSyncManager().isStarted();
        this.message = ResourceSyncManager.getSyncManager().getPluginStatus();
        if (!isStarted && StringUtils.isEmpty((CharSequence)this.message)) {
            this.message = "Resource Sync Manger has not start yet";
        }
        return !isStarted || !StringUtils.isEmpty((CharSequence)this.message);
    }

    @RequirePOST
    public HttpResponse doAct(StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (req.hasParameter("no")) {
            this.disable(true);
            return HttpResponses.redirectViaContextPath((String)"/manage");
        }
        return HttpResponses.redirectViaContextPath((String)"/configure");
    }

    public String getMessage() {
        return this.message;
    }
}

