/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.testing;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMultiset;
import org.testng.Assert;

public final class Assertions {
    private Assertions() {
    }

    public static void assertContains(String actual, String expectedPart) {
        Assertions.assertContains(actual, expectedPart, null);
    }

    public static void assertContainsAllOf(String actual, String ... expectedParts) {
        for (String expected : expectedParts) {
            Assertions.assertContains(actual, expected, null);
        }
    }

    public static void assertContains(String actual, String expectedPart, String message) {
        Assert.assertNotNull((Object)actual, (String)"actual is null");
        Assert.assertNotNull((Object)expectedPart, (String)"expectedPart is null");
        if (actual.contains(expectedPart)) {
            return;
        }
        Assertions.fail("%sexpected:<%s> to contain <%s>", Assertions.toMessageString(message), actual, expectedPart);
    }

    public static void assertEqualsIgnoreCase(String actual, String expected) {
        Assertions.assertEqualsIgnoreCase(actual, expected, null);
    }

    public static void assertEqualsIgnoreCase(String actual, String expected, String message) {
        Assert.assertNotNull((Object)actual, (String)"actual is null");
        if (actual.equalsIgnoreCase(expected)) {
            return;
        }
        Assertions.fail("%sexpected:<%s> to equal ignoring case <%s>", Assertions.toMessageString(message), actual, expected);
    }

    public static void assertNotEquals(Object actual, Object expected) {
        Assertions.assertNotEquals(actual, expected, null);
    }

    public static void assertNotEquals(Object actual, Object expected, String message) {
        if (actual == null ? expected != null : !actual.equals(expected)) {
            return;
        }
        Assertions.fail("%sexpected:<%s> to not equal <%s>", Assertions.toMessageString(message), actual, expected);
    }

    public static <T extends Comparable<T>> void assertGreaterThan(T actual, T expected) {
        Assertions.assertGreaterThan(actual, expected, null);
    }

    public static <T extends Comparable<T>> void assertGreaterThan(T actual, T expected, String message) {
        Assert.assertNotNull(actual, (String)"actual is null");
        try {
            if (actual.compareTo(expected) > 0) {
                if (expected.compareTo(actual) >= 0) {
                    Assertions.fail("%scomparison symmetry: <%s> is greater than <%s>, but <%s> is not less than <%s>", Assertions.toMessageString(message), actual, expected, expected, actual);
                }
                return;
            }
        }
        catch (ClassCastException e) {
            Assertions.fail(e, "%sexpected:<%s> to be greater than <%s>, but %s is not comparable %s", Assertions.toMessageString(message), actual, expected, actual.getClass().getName(), expected.getClass().getName());
        }
        Assertions.fail("%sexpected:<%s> to be greater than <%s>", Assertions.toMessageString(message), actual, expected);
    }

    public static <T extends Comparable<T>> void assertGreaterThanOrEqual(T actual, T expected) {
        Assertions.assertGreaterThanOrEqual(actual, expected, null);
    }

    public static <T extends Comparable<T>> void assertGreaterThanOrEqual(T actual, T expected, String message) {
        Assert.assertNotNull(actual, (String)"actual is null");
        try {
            int compareValue = actual.compareTo(expected);
            if (compareValue >= 0) {
                int reverseCompareValue = expected.compareTo(actual);
                if (reverseCompareValue > 0 || compareValue == 0 && reverseCompareValue != 0) {
                    Assertions.fail("%scomparison symmetry: <%s> is greater than or equal to <%s>, but <%s> is not less than or equal to<%s>", Assertions.toMessageString(message), actual, expected, expected, actual);
                }
                return;
            }
        }
        catch (ClassCastException e) {
            Assertions.fail(e, "%sexpected:<%s> to be greater than or equal to <%s>, but %s is not comparable %s", Assertions.toMessageString(message), actual, expected, actual.getClass().getName(), expected.getClass().getName());
        }
        Assertions.fail("%sexpected:<%s> to be greater than or equal to <%s>", Assertions.toMessageString(message), actual, expected);
    }

    public static <T extends Comparable<T>> void assertLessThan(T actual, T expected) {
        Assertions.assertLessThan(actual, expected, null);
    }

    public static <T extends Comparable<T>> void assertLessThan(T actual, T expected, String message) {
        Assert.assertNotNull(actual, (String)"actual is null");
        try {
            if (actual.compareTo(expected) < 0) {
                if (expected.compareTo(actual) <= 0) {
                    Assertions.fail("%scomparison symmetry: <%s> is less than <%s>, but <%s> is not greater than <%s>", Assertions.toMessageString(message), actual, expected, expected, actual);
                }
                return;
            }
        }
        catch (ClassCastException e) {
            Assertions.fail(e, "%sexpected:<%s> to be less than <%s>, but %s is not comparable %s", Assertions.toMessageString(message), actual, expected, actual.getClass().getName(), expected.getClass().getName());
        }
        Assertions.fail("%sexpected:<%s> to be less than <%s>", Assertions.toMessageString(message), actual, expected);
    }

    public static <T extends Comparable<T>> void assertLessThanOrEqual(T actual, T expected) {
        Assertions.assertLessThanOrEqual(actual, expected, null);
    }

    public static <T extends Comparable<T>> void assertLessThanOrEqual(T actual, T expected, String message) {
        Assert.assertNotNull(actual, (String)"actual is null");
        try {
            int compareValue = actual.compareTo(expected);
            if (compareValue <= 0) {
                int reverseCompareValue = expected.compareTo(actual);
                if (reverseCompareValue < 0 || compareValue == 0 && reverseCompareValue != 0) {
                    Assertions.fail("%scomparison symmetry: <%s> is less than or equal to <%s>, but <%s> is not greater than or equal to <%s>", Assertions.toMessageString(message), actual, expected, expected, actual);
                }
                return;
            }
        }
        catch (ClassCastException e) {
            Assertions.fail(e, "%sexpected:<%s> to be less than or equal to <%s>, but %s is not comparable %s", Assertions.toMessageString(message), actual, expected, actual.getClass().getName(), expected.getClass().getName());
        }
        Assertions.fail("%sexpected:<%s> to be less than or equal to <%s>", Assertions.toMessageString(message), actual, expected);
    }

    public static <T extends Comparable<T>> void assertBetweenInclusive(T actual, T lowerBound, T upperBound) {
        Assertions.assertBetweenInclusive(actual, lowerBound, upperBound, null);
    }

    public static <T extends Comparable<T>> void assertBetweenInclusive(T actual, T lowerBound, T upperBound, String message) {
        Assert.assertNotNull(actual, (String)"actual is null");
        try {
            if (actual.compareTo(lowerBound) >= 0 && actual.compareTo(upperBound) <= 0) {
                return;
            }
        }
        catch (ClassCastException e) {
            Assertions.fail(e, "%sexpected:<%s> to be between <%s> and <%s> inclusive, but %s is not comparable with %s or %s", Assertions.toMessageString(message), actual, lowerBound, upperBound, actual.getClass().getName(), lowerBound.getClass().getName(), upperBound.getClass().getName());
        }
        Assertions.fail("%sexpected:<%s> to be between <%s> and <%s> inclusive", Assertions.toMessageString(message), actual, lowerBound, upperBound);
    }

    public static <T extends Comparable<T>> void assertBetweenExclusive(T actual, T lowerBound, T upperBound) {
        Assertions.assertBetweenExclusive(actual, lowerBound, upperBound, null);
    }

    public static <T extends Comparable<T>> void assertBetweenExclusive(T actual, T lowerBound, T upperBound, String message) {
        Assert.assertNotNull(actual, (String)"actual is null");
        try {
            if (actual.compareTo(lowerBound) > 0 && actual.compareTo(upperBound) < 0) {
                return;
            }
        }
        catch (ClassCastException e) {
            Assertions.fail(e, "%sexpected:<%s> to be between <%s> and <%s> exclusive, but %s is not comparable with %s or %s", Assertions.toMessageString(message), actual, lowerBound, upperBound, actual.getClass().getName(), lowerBound.getClass().getName(), upperBound.getClass().getName());
        }
        Assertions.fail("%sexpected:<%s> to be between <%s> and <%s> exclusive", Assertions.toMessageString(message), actual, lowerBound, upperBound);
    }

    public static void assertInstanceOf(Object actual, Class<?> expectedType) {
        Assertions.assertInstanceOf(actual, expectedType, null);
    }

    public static void assertInstanceOf(Object actual, Class<?> expectedType, String message) {
        Assert.assertNotNull((Object)actual, (String)"actual is null");
        Assert.assertNotNull(expectedType, (String)"expectedType is null");
        if (expectedType.isInstance(actual)) {
            return;
        }
        Assertions.fail("%sexpected:<%s> to be an instance of <%s>", Assertions.toMessageString(message), actual, expectedType.getName());
    }

    public static void assertEqualsIgnoreOrder(Iterable<?> actual, Iterable<?> expected) {
        Assertions.assertEqualsIgnoreOrder(actual, expected, null);
    }

    public static void assertEqualsIgnoreOrder(Iterable<?> actual, Iterable<?> expected, String message) {
        Assert.assertNotNull(actual, (String)"actual is null");
        Assert.assertNotNull(expected, (String)"expected is null");
        ImmutableMultiset actualSet = ImmutableMultiset.copyOf(actual);
        ImmutableMultiset expectedSet = ImmutableMultiset.copyOf(expected);
        if (!actualSet.equals((Object)expectedSet)) {
            Joiner joiner = Joiner.on((String)"\n      ");
            Assertions.fail("%sexpected: collections to be equal (ignoring order).%nActual:%n      %s%nExpected:%n      %s", Assertions.toMessageString(message), joiner.join(actual), joiner.join(expected));
        }
    }

    private static String toMessageString(String message) {
        return message == null ? "" : message + " ";
    }

    private static void fail(String format, Object ... args) {
        String message = String.format(format, args);
        Assert.fail((String)message);
    }

    private static void fail(Throwable e, String format, Object ... args) {
        String message = String.format(format, args);
        Assert.fail((String)message, (Throwable)e);
    }
}

