/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.server.tracing;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.semconv.ClientAttributes;
import io.opentelemetry.semconv.HttpAttributes;
import io.opentelemetry.semconv.NetworkAttributes;
import io.opentelemetry.semconv.ServerAttributes;
import io.opentelemetry.semconv.UrlAttributes;
import io.opentelemetry.semconv.UserAgentAttributes;
import io.opentelemetry.semconv.incubating.HttpIncubatingAttributes;
import io.opentelemetry.semconv.incubating.TlsIncubatingAttributes;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.util.Locale;
import java.util.Objects;

public final class TracingServletFilter
implements Filter {
    static final AttributeKey<Boolean> EXCEPTION_ESCAPED = AttributeKey.booleanKey((String)"exception.escaped");
    static final String REQUEST_SPAN = "airlift.trace-span";
    private final TextMapPropagator propagator;
    private final Tracer tracer;

    @Inject
    public TracingServletFilter(OpenTelemetry openTelemetry, Tracer tracer) {
        this.propagator = openTelemetry.getPropagators().getTextMapPropagator();
        this.tracer = Objects.requireNonNull(tracer, "tracer is null");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String userAgent;
        String target;
        HttpServletRequest httpRequest;
        block23: {
            block22: {
                if (!(request instanceof HttpServletRequest)) break block22;
                httpRequest = (HttpServletRequest)request;
                if (response instanceof HttpServletResponse) break block23;
            }
            chain.doFilter(request, response);
            return;
        }
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        Context parent = this.propagator.extract(Context.root(), (Object)httpRequest, (TextMapGetter)ServletTextMapGetter.INSTANCE);
        String method = httpRequest.getMethod().toUpperCase(Locale.ENGLISH);
        SpanBuilder spanBuilder = this.tracer.spanBuilder(method + " " + httpRequest.getRequestURI()).setParent(parent).setSpanKind(SpanKind.SERVER).setAttribute(HttpAttributes.HTTP_REQUEST_METHOD, (Object)method).setAttribute(UrlAttributes.URL_SCHEME, (Object)httpRequest.getScheme()).setAttribute(ServerAttributes.SERVER_ADDRESS, (Object)httpRequest.getServerName()).setAttribute(ServerAttributes.SERVER_PORT, (Object)TracingServletFilter.getPort(httpRequest)).setAttribute(ClientAttributes.CLIENT_ADDRESS, (Object)request.getRemoteAddr()).setAttribute(NetworkAttributes.NETWORK_PROTOCOL_NAME, (Object)"http");
        String sessionId = (String)request.getAttribute("jakarta.servlet.request.ssl_session_id");
        if (sessionId != null) {
            spanBuilder.setAttribute(TlsIncubatingAttributes.TLS_ESTABLISHED, (Object)true);
            spanBuilder.setAttribute(TlsIncubatingAttributes.TLS_CIPHER, (Object)((String)request.getAttribute("jakarta.servlet.request.cipher_suite")));
        }
        if (request.getProtocol().equalsIgnoreCase("HTTP/1.1")) {
            spanBuilder.setAttribute(NetworkAttributes.NETWORK_PROTOCOL_VERSION, (Object)"1.1");
        } else if (request.getProtocol().equalsIgnoreCase("HTTP/2.0")) {
            spanBuilder.setAttribute(NetworkAttributes.NETWORK_PROTOCOL_VERSION, (Object)"2.0");
        }
        if (request.getContentLengthLong() > 0L) {
            spanBuilder.setAttribute(HttpIncubatingAttributes.HTTP_REQUEST_BODY_SIZE, (Object)request.getContentLengthLong());
        }
        if (!Strings.isNullOrEmpty((String)(target = TracingServletFilter.getTarget(httpRequest)))) {
            spanBuilder.setAttribute(UrlAttributes.URL_PATH, (Object)target);
        }
        if (!Strings.isNullOrEmpty((String)(userAgent = httpRequest.getHeader("User-Agent")))) {
            spanBuilder.setAttribute(UserAgentAttributes.USER_AGENT_ORIGINAL, (Object)userAgent);
        }
        Span span = spanBuilder.startSpan();
        request.setAttribute(REQUEST_SPAN, (Object)span);
        try (Scope ignored = span.makeCurrent();){
            chain.doFilter(request, (ServletResponse)new TracingHttpServletResponse(httpResponse, span));
        }
        catch (Throwable t) {
            span.setStatus(StatusCode.ERROR, t.getMessage());
            span.recordException(t, Attributes.of(EXCEPTION_ESCAPED, (Object)true));
            throw t;
        }
        finally {
            span.end();
        }
    }

    private static String getTarget(HttpServletRequest request) {
        Object target = Strings.nullToEmpty((String)request.getRequestURI());
        if (request.getQueryString() != null) {
            target = (String)target + "?" + request.getQueryString();
        }
        return target;
    }

    private static long getPort(HttpServletRequest request) {
        int port = request.getServerPort();
        if (port > 0) {
            return port;
        }
        return switch (Strings.nullToEmpty((String)request.getScheme()).toLowerCase(Locale.ENGLISH)) {
            case "http" -> 80L;
            case "https" -> 443L;
            default -> -1L;
        };
    }

    private static class ServletTextMapGetter
    implements TextMapGetter<HttpServletRequest> {
        public static final ServletTextMapGetter INSTANCE = new ServletTextMapGetter();

        private ServletTextMapGetter() {
        }

        public Iterable<String> keys(HttpServletRequest request) {
            return request.getHeaderNames()::asIterator;
        }

        public String get(HttpServletRequest request, String key) {
            return Objects.requireNonNull(request).getHeader(key);
        }
    }

    private static class TracingHttpServletResponse
    extends HttpServletResponseWrapper {
        private final Span span;

        public TracingHttpServletResponse(HttpServletResponse delegate, Span span) {
            super(delegate);
            this.span = Objects.requireNonNull(span, "span is null");
        }

        public void sendError(int statusCode, String msg) throws IOException {
            this.span.setAttribute(HttpAttributes.HTTP_RESPONSE_STATUS_CODE, statusCode);
            this.span.setStatus(StatusCode.ERROR, msg);
            super.sendError(statusCode, msg);
        }

        public void sendError(int statusCode) throws IOException {
            this.span.setAttribute(HttpAttributes.HTTP_RESPONSE_STATUS_CODE, statusCode);
            this.span.setStatus(StatusCode.ERROR);
            super.sendError(statusCode);
        }

        public void setStatus(int statusCode) {
            this.span.setAttribute(HttpAttributes.HTTP_RESPONSE_STATUS_CODE, statusCode);
            super.setStatus(statusCode);
        }

        public void setHeader(String name, String value) {
            if (name.equalsIgnoreCase("Content-Length")) {
                this.span.setAttribute(HttpIncubatingAttributes.HTTP_RESPONSE_BODY_SIZE, (Object)Long.parseLong(value));
            }
            super.setHeader(name, value);
        }

        public void addHeader(String name, String value) {
            if (name.equalsIgnoreCase("Content-Length")) {
                this.span.setAttribute(HttpIncubatingAttributes.HTTP_RESPONSE_BODY_SIZE, (Object)Long.parseLong(value));
            }
            super.addHeader(name, value);
        }

        public void setIntHeader(String name, int value) {
            if (name.equalsIgnoreCase("Content-Length")) {
                this.span.setAttribute(HttpIncubatingAttributes.HTTP_RESPONSE_BODY_SIZE, value);
            }
            super.setIntHeader(name, value);
        }

        public void addIntHeader(String name, int value) {
            if (name.equalsIgnoreCase("Content-Length")) {
                this.span.setAttribute(HttpIncubatingAttributes.HTTP_RESPONSE_BODY_SIZE, value);
            }
            super.addIntHeader(name, value);
        }

        public void setContentLength(int length) {
            this.span.setAttribute(HttpIncubatingAttributes.HTTP_RESPONSE_BODY_SIZE, length);
            super.setContentLength(length);
        }

        public void setContentLengthLong(long length) {
            this.span.setAttribute(HttpIncubatingAttributes.HTTP_RESPONSE_BODY_SIZE, (Object)length);
            super.setContentLengthLong(length);
        }
    }
}

