/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.server;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.airlift.configuration.ConfigBinder;
import io.airlift.discovery.client.AnnouncementHttpServerInfo;
import io.airlift.http.server.EnableCaseSensitiveHeaderCache;
import io.airlift.http.server.EnableLegacyUriCompliance;
import io.airlift.http.server.EnableVirtualThreads;
import io.airlift.http.server.HttpServer;
import io.airlift.http.server.HttpServerBinder;
import io.airlift.http.server.HttpServerConfig;
import io.airlift.http.server.HttpServerInfo;
import io.airlift.http.server.HttpServerProvider;
import io.airlift.http.server.HttpsConfig;
import io.airlift.http.server.LocalAnnouncementHttpServerInfo;
import io.airlift.http.server.tracing.TracingServletFilter;
import jakarta.servlet.Filter;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.weakref.jmx.guice.ExportBinder;

public class HttpServerModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        binder.disableCircularProxies();
        binder.bind(HttpServer.class).toProvider(HttpServerProvider.class).in(Scopes.SINGLETON);
        OptionalBinder.newOptionalBinder((Binder)binder, HttpServer.ClientCertificate.class).setDefault().toInstance((Object)HttpServer.ClientCertificate.NONE);
        ExportBinder.newExporter((Binder)binder).export(HttpServer.class).withGeneratedName();
        binder.bind(HttpServerInfo.class).in(Scopes.SINGLETON);
        OptionalBinder.newOptionalBinder((Binder)binder, (Key)Key.get(Boolean.class, EnableVirtualThreads.class)).setDefault().toInstance((Object)false);
        OptionalBinder.newOptionalBinder((Binder)binder, (Key)Key.get(Boolean.class, EnableLegacyUriCompliance.class)).setDefault().toInstance((Object)false);
        Multibinder.newSetBinder((Binder)binder, Filter.class).addBinding().to(TracingServletFilter.class).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)binder, HttpServerBinder.HttpResourceBinding.class);
        OptionalBinder.newOptionalBinder((Binder)binder, SslContextFactory.Server.class);
        OptionalBinder.newOptionalBinder((Binder)binder, (Key)Key.get(Boolean.class, EnableCaseSensitiveHeaderCache.class)).setDefault().toInstance((Object)false);
        ConfigBinder.configBinder((Binder)binder).bindConfig(HttpServerConfig.class);
        OptionalBinder.newOptionalBinder((Binder)binder, HttpsConfig.class);
        OptionalBinder.newOptionalBinder((Binder)binder, ByteBufferPool.class);
        binder.bind(AnnouncementHttpServerInfo.class).to(LocalAnnouncementHttpServerInfo.class).in(Scopes.SINGLETON);
        this.install(ConditionalModule.conditionalModule(HttpServerConfig.class, HttpServerConfig::isHttpsEnabled, moduleBinder -> ConfigBinder.configBinder((Binder)moduleBinder).bindConfig(HttpsConfig.class)));
    }
}

