/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.configuration.ConfigDefaults;
import io.airlift.http.client.GlobalFilter;
import io.airlift.http.client.HttpClientConfig;
import io.airlift.http.client.HttpClientModule;
import io.airlift.http.client.HttpRequestFilter;
import io.airlift.http.client.HttpStatusListener;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Objects;
import org.eclipse.jetty.io.ByteBufferPool;

public class HttpClientBinder {
    private final Binder binder;
    private final Multibinder<HttpRequestFilter> globalFilterBinder;
    private final Multibinder<HttpStatusListener> globalStatusListenerBinder;
    private final OptionalBinder<ByteBufferPool> byteBufferPool;

    private HttpClientBinder(Binder binder) {
        this.binder = binder.skipSources(new Class[]{this.getClass()});
        this.globalFilterBinder = Multibinder.newSetBinder((Binder)binder, HttpRequestFilter.class, GlobalFilter.class);
        this.globalStatusListenerBinder = Multibinder.newSetBinder((Binder)binder, HttpStatusListener.class, GlobalFilter.class);
        this.byteBufferPool = OptionalBinder.newOptionalBinder((Binder)binder, ByteBufferPool.class);
    }

    public static HttpClientBinder httpClientBinder(Binder binder) {
        return new HttpClientBinder(binder);
    }

    public HttpClientBindingBuilder bindHttpClient(String name, Class<? extends Annotation> annotation) {
        HttpClientModule module = new HttpClientModule(name, annotation);
        this.binder.install((Module)module);
        return new HttpClientBindingBuilder(module, (Multibinder<HttpRequestFilter>)Multibinder.newSetBinder((Binder)this.binder, (Key)Key.get(HttpRequestFilter.class, annotation)), (Multibinder<HttpStatusListener>)Multibinder.newSetBinder((Binder)this.binder, (Key)Key.get(HttpStatusListener.class, annotation)), (OptionalBinder<ByteBufferPool>)OptionalBinder.newOptionalBinder((Binder)this.binder, (Key)Key.get(ByteBufferPool.class, annotation)));
    }

    public LinkedBindingBuilder<HttpRequestFilter> addGlobalFilterBinding() {
        return this.globalFilterBinder.addBinding();
    }

    public LinkedBindingBuilder<HttpStatusListener> addGlobalStatusListenerBinding() {
        return this.globalStatusListenerBinder.addBinding();
    }

    public HttpClientBinder bindGlobalFilter(Class<? extends HttpRequestFilter> filterClass) {
        this.globalFilterBinder.addBinding().to(filterClass).in(Scopes.SINGLETON);
        return this;
    }

    public HttpClientBinder bindByteBufferPool(ByteBufferPool byteBufferPool) {
        this.byteBufferPool.setBinding().toInstance((Object)byteBufferPool);
        return this;
    }

    public HttpClientBinder bindGlobalFilter(HttpRequestFilter filter) {
        this.globalFilterBinder.addBinding().toInstance((Object)filter);
        return this;
    }

    public static class HttpClientBindingBuilder {
        private final HttpClientModule module;
        private final Multibinder<HttpRequestFilter> filterBinder;
        private final Multibinder<HttpStatusListener> statusListenerBinder;
        private final OptionalBinder<ByteBufferPool> byteBufferPoolBinder;

        public HttpClientBindingBuilder(HttpClientModule module, Multibinder<HttpRequestFilter> filterBinder, Multibinder<HttpStatusListener> statusListenerBinder, OptionalBinder<ByteBufferPool> byteBufferPoolBinder) {
            this.module = Objects.requireNonNull(module, "module is null");
            this.filterBinder = Objects.requireNonNull(filterBinder, "multibinder is null");
            this.statusListenerBinder = Objects.requireNonNull(statusListenerBinder, "statusListenerBinder is null");
            this.byteBufferPoolBinder = Objects.requireNonNull(byteBufferPoolBinder, "byteBufferPoolBinder is null");
        }

        public HttpClientBindingBuilder withAlias(Class<? extends Annotation> alias) {
            this.module.addAlias(alias);
            return this;
        }

        public HttpClientBindingBuilder withAliases(Collection<Class<? extends Annotation>> aliases) {
            for (Class<? extends Annotation> annotation : aliases) {
                this.module.addAlias(annotation);
            }
            return this;
        }

        public HttpClientBindingBuilder withConfigDefaults(ConfigDefaults<HttpClientConfig> configDefaults) {
            this.module.withConfigDefaults(configDefaults);
            return this;
        }

        public LinkedBindingBuilder<HttpRequestFilter> addFilterBinding() {
            return this.filterBinder.addBinding();
        }

        public HttpClientBindingBuilder withFilter(Class<? extends HttpRequestFilter> filterClass) {
            this.filterBinder.addBinding().to(filterClass);
            return this;
        }

        public HttpClientBindingBuilder withByteBufferPool(Class<? extends ByteBufferPool> byteBufferPoolClass) {
            this.byteBufferPoolBinder.setBinding().to(byteBufferPoolClass);
            return this;
        }

        public HttpClientBindingBuilder withByteBufferPool(ByteBufferPool byteBufferPool) {
            this.byteBufferPoolBinder.setDefault().toInstance((Object)byteBufferPool);
            return this;
        }

        public LinkedBindingBuilder<HttpStatusListener> addStatusListenerBinding() {
            return this.statusListenerBinder.addBinding();
        }

        public HttpClientBindingBuilder withStatusListener(Class<? extends HttpStatusListener> listenerClass) {
            this.addStatusListenerBinding().to(listenerClass);
            return this;
        }
    }
}

