/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.configuration;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.inject.Binding;
import com.google.inject.ConfigurationException;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.spi.DefaultElementVisitor;
import com.google.inject.spi.Element;
import com.google.inject.spi.ElementVisitor;
import com.google.inject.spi.Message;
import com.google.inject.spi.ProviderInstanceBinding;
import io.airlift.configuration.ConfigurationFactory;
import io.airlift.configuration.ConfigurationProvider;
import io.airlift.configuration.ElementsIterator;
import io.airlift.configuration.WarningsMonitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ConfigurationValidator {
    private final ConfigurationFactory configurationFactory;
    private final WarningsMonitor warningsMonitor;

    public ConfigurationValidator(ConfigurationFactory configurationFactory, WarningsMonitor warningsMonitor) {
        this.configurationFactory = configurationFactory;
        this.warningsMonitor = warningsMonitor;
    }

    public List<Message> validate(Module ... modules) {
        return this.validate((Iterable<? extends Module>)ImmutableList.copyOf((Object[])modules));
    }

    public List<Message> validate(Iterable<? extends Module> modules) {
        final ArrayList messages = Lists.newArrayList();
        ElementsIterator elementsIterator = new ElementsIterator(modules);
        for (Element element : elementsIterator) {
            element.acceptVisitor((ElementVisitor)new DefaultElementVisitor<Void>(){

                public <T> Void visit(Binding<T> binding) {
                    ProviderInstanceBinding providerInstanceBinding;
                    Provider provider;
                    if (binding instanceof ProviderInstanceBinding && (provider = (providerInstanceBinding = (ProviderInstanceBinding)binding).getProviderInstance()) instanceof ConfigurationProvider) {
                        ConfigurationProvider configurationProvider = (ConfigurationProvider)provider;
                        configurationProvider.setConfigurationFactory(ConfigurationValidator.this.configurationFactory);
                        configurationProvider.setWarningsMonitor(ConfigurationValidator.this.warningsMonitor);
                        try {
                            configurationProvider.get();
                        }
                        catch (ConfigurationException e) {
                            for (Message message : e.getErrorMessages()) {
                                messages.add(new Message(Collections.singletonList(binding.getSource()), message.getMessage(), message.getCause()));
                            }
                        }
                    }
                    return null;
                }
            });
        }
        return messages;
    }
}

