/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.configuration;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.Provider;
import io.airlift.configuration.ConfigurationFactory;
import io.airlift.configuration.ConfigurationMetadata;
import io.airlift.configuration.WarningsMonitor;

public class ConfigurationProvider<T>
implements Provider<T> {
    private final Key<T> key;
    private final Class<T> configClass;
    private final String prefix;
    private ConfigurationFactory configurationFactory;
    private WarningsMonitor warningsMonitor;

    public ConfigurationProvider(Key<T> key, Class<T> configClass, String prefix) {
        Preconditions.checkNotNull(key, (Object)"key");
        Preconditions.checkNotNull(configClass, (Object)"configClass");
        this.key = key;
        this.configClass = configClass;
        this.prefix = prefix;
    }

    @Inject
    public void setConfigurationFactory(ConfigurationFactory configurationFactory) {
        this.configurationFactory = configurationFactory;
    }

    @Inject(optional=true)
    public void setWarningsMonitor(WarningsMonitor warningsMonitor) {
        this.warningsMonitor = warningsMonitor;
    }

    public Key<T> getKey() {
        return this.key;
    }

    public Class<T> getConfigClass() {
        return this.configClass;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public ConfigurationMetadata<T> getConfigurationMetadata() {
        return ConfigurationMetadata.getConfigurationMetadata(this.configClass);
    }

    public T get() {
        Preconditions.checkNotNull((Object)this.configurationFactory, (Object)"configurationFactory");
        return this.configurationFactory.build(this, this.warningsMonitor);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigurationProvider that = (ConfigurationProvider)o;
        return this.key.equals(that.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }
}

