/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.configuration;

import com.google.common.collect.Lists;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.spi.Element;
import com.google.inject.spi.Elements;
import java.util.Iterator;
import java.util.List;

class ElementsIterator
implements Module,
Iterable<Element> {
    private final List<Element> boundElements;
    private final List<Element> elements;

    public ElementsIterator(Module ... modules) {
        this.elements = Elements.getElements((Module[])modules);
        this.boundElements = Lists.newArrayList(this.elements);
    }

    public void configure(Binder binder) {
        Module baseModule = Elements.getModule(this.boundElements);
        binder.install(baseModule);
    }

    public void unbindElement(Element element) {
        if (element == null) {
            throw new IllegalStateException();
        }
        this.boundElements.remove(element);
    }

    @Override
    public Iterator<Element> iterator() {
        return this.elements.iterator();
    }
}

