/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.springframework.boot;

import io.agroal.springframework.boot.AgroalDataSource;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.jta.JtaTransactionManager;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={AgroalDataSource.class})
@ConditionalOnMissingBean(value={DataSource.class})
@ConditionalOnProperty(name={"spring.datasource.type"}, havingValue="io.agroal.springframework.boot.AgroalDataSource", matchIfMissing=true)
public class AgroalDataSourceConfiguration {
    @Autowired(required=false)
    public JtaTransactionManager jtaPlatform;

    @Bean
    @ConfigurationProperties(prefix="spring.datasource.agroal")
    public AgroalDataSource dataSource(DataSourceProperties properties) {
        AgroalDataSource dataSource = (AgroalDataSource)((Object)properties.initializeDataSourceBuilder().type(AgroalDataSource.class).build());
        dataSource.setName(properties.determineDatabaseName());
        if (this.jtaPlatform != null && this.jtaPlatform.getTransactionManager() != null && this.jtaPlatform.getTransactionSynchronizationRegistry() != null) {
            dataSource.setJtaTransactionIntegration(this.jtaPlatform);
        }
        return dataSource;
    }
}

