/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.utils;

import android.content.Context;
import android.os.Process;
import android.view.WindowManager;
import io.agora.rtc.internal.RtcEngineImpl;

public class AgoraUtils {
    private static final String TAG = "AgoraUtils";

    public static boolean ensureNativeLibsInitialized() {
        return RtcEngineImpl.initializeNativeLibs();
    }

    public static int getFrameOrientation(int n2, int n3, boolean bl, boolean bl2) {
        int n4;
        if (bl) {
            n4 = (n3 + n2) % 360;
            if (bl2) {
                n4 = (360 - n4) % 360;
            }
        } else {
            n4 = (n3 - n2 + 360) % 360;
        }
        return n4;
    }

    public static int getDisplayRotation(Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        int n2 = windowManager.getDefaultDisplay().getRotation();
        switch (n2) {
            case 0: {
                return 0;
            }
            case 1: {
                return 90;
            }
            case 2: {
                return 180;
            }
            case 3: {
                return 270;
            }
        }
        return 0;
    }

    public static String getAppStorageDir(Context context) {
        if (context == null) {
            return null;
        }
        int n2 = context.checkPermission("android.permission.READ_EXTERNAL_STORAGE", Process.myPid(), Process.myUid());
        if (n2 == 0) {
            return "/sdcard/" + context.getApplicationInfo().packageName;
        }
        return null;
    }
}

