/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.audio;

import android.content.Context;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.os.Build;
import io.agora.rtc.internal.Logging;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;

public class MediaCodecAudioDecoder {
    private Context mContext = null;
    private MediaCodec mMediaCodec = null;
    private MediaExtractor mExtractor = null;
    private MediaFormat mTrackFormat = null;
    private boolean mDecodedDataReady = false;
    private boolean eoInputStream = false;
    private boolean eoOutputStream = false;
    private int mSampleRate = 44100;
    private int mChannels = 2;
    private long mFileLength;
    private int mRetryCount = 0;
    private static int MAX_DECODER_RETRY_COUNT = 300;
    private static int HTTP_REQUEST_TIMEOUT = 400;
    private ByteBuffer[] mInputBuffers;
    private ByteBuffer[] mOutputBuffers;
    private ByteBuffer mDecodedRAWBuffer;
    private MediaCodec mAACDecoder = null;
    private ByteBuffer mAACOutputBuffer = ByteBuffer.allocateDirect(4096);
    private String TAG = "MediaCodec Audio Decoder";

    public boolean createStreaming(String string) {
        try {
            int n2;
            Object object;
            Logging.i(this.TAG, "Try to decode audio file : " + string);
            this.mRetryCount = 0;
            String string2 = "/assets/";
            boolean bl = string.startsWith(string2);
            boolean bl2 = string.toLowerCase().startsWith("http");
            this.mExtractor = new MediaExtractor();
            if (bl) {
                if (this.mContext == null) {
                    return false;
                }
                object = this.mContext.getAssets().openFd(string.substring(string2.length()));
                this.mExtractor.setDataSource(object.getFileDescriptor(), object.getStartOffset(), object.getLength());
            } else if (bl2) {
                try {
                    HttpURLConnection.setFollowRedirects(false);
                    object = (HttpURLConnection)new URL(string).openConnection();
                    ((URLConnection)object).setConnectTimeout(HTTP_REQUEST_TIMEOUT);
                    ((URLConnection)object).setReadTimeout(HTTP_REQUEST_TIMEOUT);
                    ((URLConnection)object).connect();
                    if (((HttpURLConnection)object).getResponseCode() != 200) {
                        return false;
                    }
                    this.mExtractor.setDataSource(string);
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    Logging.e(this.TAG, "Connect timeout on URL : " + string);
                    return false;
                }
                catch (IOException iOException) {
                    Logging.e(this.TAG, "Connect IOException on URL : " + string);
                    return false;
                }
            } else {
                this.mExtractor.setDataSource(string);
            }
            int n3 = this.mExtractor.getTrackCount();
            for (n2 = 0; n2 < n3; ++n2) {
                this.mExtractor.unselectTrack(n2);
            }
            for (n2 = 0; n2 < n3; ++n2) {
                this.mTrackFormat = this.mExtractor.getTrackFormat(n2);
                String string3 = this.mTrackFormat.getString("mime");
                if (!string3.contains("audio/")) continue;
                this.mExtractor.selectTrack(n2);
                this.mMediaCodec = MediaCodec.createDecoderByType((String)string3);
                this.mMediaCodec.configure(this.mTrackFormat, null, null, 0);
                break;
            }
            if (this.mMediaCodec != null) {
                this.mMediaCodec.start();
            }
            this.mChannels = this.mTrackFormat.getInteger("channel-count");
            this.mSampleRate = this.mTrackFormat.getInteger("sample-rate");
            if (this.mSampleRate == 22050) {
                this.mSampleRate = 22000;
            } else if (this.mSampleRate == 11025) {
                this.mSampleRate = 11000;
            }
            this.mFileLength = this.mTrackFormat.getLong("durationUs");
        }
        catch (Exception exception) {
            Logging.e(this.TAG, "Error when creating aac audio file decoder");
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public int getChannelCount() {
        return this.mChannels;
    }

    public int getSampleRate() {
        return this.mSampleRate;
    }

    public long getFileLength() {
        return this.mFileLength;
    }

    public long getCurrentFilePosition() {
        return this.mExtractor.getSampleTime();
    }

    public void setCurrentFilePosition(long l2) {
        this.mExtractor.seekTo(l2, 2);
    }

    public boolean getDecodeDataReadyFlag() {
        return this.mDecodedDataReady;
    }

    public void releaseStreaming() {
        try {
            if (this.mMediaCodec != null) {
                this.mMediaCodec.stop();
                this.mMediaCodec.release();
                this.mMediaCodec = null;
            }
            if (this.mExtractor != null) {
                this.mExtractor.release();
                this.mExtractor = null;
            }
        }
        catch (Exception exception) {
            Logging.e(this.TAG, "Error when releasing audio file stream");
            exception.printStackTrace();
        }
        this.eoOutputStream = false;
        this.eoInputStream = false;
    }

    public void rewindStreaming() {
        try {
            this.mExtractor.seekTo(0L, 1);
            this.mMediaCodec.flush();
        }
        catch (Exception exception) {
            Logging.e(this.TAG, "Error when rewinding audio file stream");
            exception.printStackTrace();
        }
        this.eoInputStream = false;
        this.eoOutputStream = false;
        this.mDecodedDataReady = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean decodeFrame() {
        try {
            int n2;
            if (!this.eoInputStream && (n2 = this.mMediaCodec.dequeueInputBuffer(0L)) >= 0) {
                ByteBuffer byteBuffer;
                if (Build.VERSION.SDK_INT >= 21) {
                    byteBuffer = this.mMediaCodec.getInputBuffer(n2);
                } else {
                    this.mInputBuffers = this.mMediaCodec.getInputBuffers();
                    byteBuffer = this.mInputBuffers[n2];
                }
                int n3 = this.mExtractor.readSampleData(byteBuffer, 0);
                if (n3 <= 0) {
                    n3 = 0;
                    this.eoInputStream = true;
                }
                long l2 = this.mExtractor.getSampleTime();
                int n4 = this.mExtractor.getSampleFlags();
                if (this.eoInputStream) {
                    n4 |= 4;
                }
                this.mMediaCodec.queueInputBuffer(n2, 0, n3, l2, n4);
                this.mExtractor.advance();
            }
            if (this.eoOutputStream) return this.eoOutputStream;
            MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
            int n5 = this.mMediaCodec.dequeueOutputBuffer(bufferInfo, 0L);
            this.mDecodedDataReady = false;
            switch (n5) {
                case -3: {
                    return this.eoOutputStream;
                }
                case -2: {
                    return this.eoOutputStream;
                }
                case -1: {
                    ++this.mRetryCount;
                    if (this.mRetryCount < MAX_DECODER_RETRY_COUNT) return this.eoOutputStream;
                    Logging.e(this.TAG, "EAGAIN count=" + this.mRetryCount + " presentationTimeUs=" + bufferInfo.presentationTimeUs + " totalUs=" + this.mFileLength + " Force EOS");
                    this.eoOutputStream = true;
                    return this.eoOutputStream;
                }
                default: {
                    this.mRetryCount = 0;
                    if (n5 < 0) return this.eoOutputStream;
                    if ((bufferInfo.flags & 4) == 4) {
                        this.eoOutputStream = true;
                    }
                    if (Build.VERSION.SDK_INT >= 21) {
                        ByteBuffer byteBuffer = this.mMediaCodec.getOutputBuffer(n5);
                        this.cloneByteBuffer(byteBuffer);
                    } else {
                        this.mOutputBuffers = this.mMediaCodec.getOutputBuffers();
                        ByteBuffer byteBuffer = this.mOutputBuffers[n5];
                        this.cloneByteBufferByLength(byteBuffer, bufferInfo.size);
                    }
                    this.mMediaCodec.releaseOutputBuffer(n5, false);
                    this.mDecodedDataReady = true;
                }
            }
            return this.eoOutputStream;
        }
        catch (Exception exception) {
            Logging.e(this.TAG, "Error when decoding audio file stream");
            exception.printStackTrace();
        }
        return this.eoOutputStream;
    }

    private boolean checkInfoChange() {
        if (Build.VERSION.SDK_INT < 19) {
            return false;
        }
        try {
            MediaFormat mediaFormat = this.mMediaCodec.getOutputFormat();
            int n2 = mediaFormat.getInteger("sample-rate");
            if (n2 == 22050) {
                n2 = 22000;
            } else if (n2 == 11025) {
                n2 = 11000;
            }
            int n3 = mediaFormat.getInteger("channel-count");
            boolean bl = this.mSampleRate != n2 || this.mChannels != n3;
            this.mSampleRate = n2;
            this.mChannels = n3;
            return bl;
        }
        catch (Exception exception) {
            Logging.e(this.TAG, "Error when checking file's new format");
            exception.printStackTrace();
            return false;
        }
    }

    private void cloneByteBuffer(ByteBuffer byteBuffer) {
        try {
            if (this.mDecodedRAWBuffer == null || this.mDecodedRAWBuffer.limit() != byteBuffer.limit()) {
                if (this.mDecodedRAWBuffer != null) {
                    this.mDecodedRAWBuffer.clear();
                    this.mDecodedRAWBuffer = null;
                }
                this.mDecodedRAWBuffer = ByteBuffer.allocateDirect(byteBuffer.limit());
            }
            this.mDecodedRAWBuffer.position(0);
            this.mDecodedRAWBuffer.put(byteBuffer);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void cloneByteBufferByLength(ByteBuffer byteBuffer, int n2) {
        try {
            if (this.mDecodedRAWBuffer == null || this.mDecodedRAWBuffer.capacity() < n2) {
                if (this.mDecodedRAWBuffer != null) {
                    this.mDecodedRAWBuffer.clear();
                    this.mDecodedRAWBuffer = null;
                }
                this.mDecodedRAWBuffer = ByteBuffer.allocateDirect(n2);
            }
            this.mDecodedRAWBuffer.position(0);
            byteBuffer.limit(n2);
            this.mDecodedRAWBuffer.put(byteBuffer);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean checkAACSupported() {
        boolean bl;
        block5: {
            bl = true;
            try {
                if (Build.VERSION.SDK_INT >= 21) {
                    MediaCodecInfo[] mediaCodecInfoArray;
                    MediaCodecList mediaCodecList = new MediaCodecList(1);
                    for (MediaCodecInfo mediaCodecInfo : mediaCodecInfoArray = mediaCodecList.getCodecInfos()) {
                        String string;
                        if (mediaCodecInfo.isEncoder() || !(string = mediaCodecInfo.getName().toLowerCase()).contains("nvidia")) continue;
                        bl = false;
                        break block5;
                    }
                    break block5;
                }
                int n2 = MediaCodecList.getCodecCount();
                for (int i2 = 0; i2 < n2; ++i2) {
                    String string;
                    MediaCodecInfo mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)i2);
                    if (mediaCodecInfo.isEncoder() || !(string = mediaCodecInfo.getName().toLowerCase()).contains("nvidia")) continue;
                    bl = false;
                    break;
                }
            }
            catch (Exception exception) {
                Logging.e(this.TAG, "Error when checking aac codec availability");
                exception.printStackTrace();
                return false;
            }
        }
        return bl;
    }

    public boolean createAACStreaming(int n2) {
        try {
            this.mAACDecoder = MediaCodec.createDecoderByType((String)"audio/mp4a-latm");
            MediaFormat mediaFormat = MediaFormat.createAudioFormat((String)"audio/mp4a-latm", (int)n2, (int)1);
            mediaFormat.setInteger("sample-rate", n2);
            mediaFormat.setInteger("channel-count", 1);
            byte[] byArray = new byte[]{18, -120};
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            mediaFormat.setByteBuffer("csd-0", byteBuffer);
            this.mAACDecoder.configure(mediaFormat, null, null, 0);
            if (this.mAACDecoder != null) {
                this.mAACDecoder.start();
            }
        }
        catch (Exception exception) {
            Logging.e(this.TAG, "Error when creating aac decode stream");
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public void releaseAACStreaming() {
        try {
            if (this.mAACDecoder != null) {
                this.mAACDecoder.stop();
                this.mAACDecoder.release();
                this.mAACDecoder = null;
            }
        }
        catch (Exception exception) {
            Logging.e(this.TAG, "Error when releasing aac decode stream");
            exception.printStackTrace();
        }
    }

    public int decodeAACFrame(byte[] byArray) {
        int n2 = 0;
        try {
            Object object;
            Object object2;
            int n3 = this.mAACDecoder.dequeueInputBuffer(200L);
            if (n3 >= 0) {
                if (Build.VERSION.SDK_INT >= 21) {
                    object2 = this.mAACDecoder.getInputBuffer(n3);
                } else {
                    object = this.mAACDecoder.getInputBuffers();
                    object2 = object[n3];
                }
                ((ByteBuffer)object2).clear();
                ((ByteBuffer)object2).put(byArray);
                this.mAACDecoder.queueInputBuffer(n3, 0, byArray.length, 0L, 0);
            }
            object2 = new MediaCodec.BufferInfo();
            n3 = this.mAACDecoder.dequeueOutputBuffer((MediaCodec.BufferInfo)object2, 0L);
            switch (n3) {
                case -3: {
                    break;
                }
                case -2: {
                    break;
                }
                case -1: {
                    break;
                }
                default: {
                    if (n3 >= 0) {
                        if (Build.VERSION.SDK_INT >= 21) {
                            object = this.mAACDecoder.getOutputBuffer(n3);
                        } else {
                            ByteBuffer[] byteBufferArray = this.mAACDecoder.getOutputBuffers();
                            object = byteBufferArray[n3];
                        }
                        n2 = ((MediaCodec.BufferInfo)object2).size;
                        this.mAACOutputBuffer.position(0);
                        ((ByteBuffer)object).limit(n2);
                        this.mAACOutputBuffer.put((ByteBuffer)object);
                        this.mAACDecoder.releaseOutputBuffer(n3, false);
                    }
                    break;
                }
            }
        }
        catch (Exception exception) {
            Logging.e(this.TAG, "Error when decoding aac stream");
            exception.printStackTrace();
        }
        return n2;
    }
}

