/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.audio;

import android.content.Context;
import com.huawei.multimedia.audiokit.interfaces.HwAudioKaraokeFeatureKit;
import com.huawei.multimedia.audiokit.interfaces.HwAudioKit;
import com.huawei.multimedia.audiokit.interfaces.IAudioKitCallback;
import io.agora.rtc.audio.IHardwareEarback;
import io.agora.rtc.internal.Logging;

class HuaweiHardwareEarback
implements IHardwareEarback {
    private static final String TAG = "HuaweiHardwareEarback";
    private Context mContext = null;
    private HwAudioKit mHwAudioKit = null;
    private HwAudioKaraokeFeatureKit mHwAudioKaraokeFeatureKit = null;
    private boolean mInited = false;
    private boolean mEarbackEnabled = false;
    private int latency = 0;
    private int volume = 0;

    public HuaweiHardwareEarback(Context context) {
        Logging.d(TAG, ">>ctor");
        this.mContext = context;
        this.initialize();
    }

    @Override
    public void initialize() {
        if (this.mContext == null) {
            Logging.e(TAG, "mContext is null!");
            return;
        }
        Logging.d(TAG, ">>initialize");
        this.mHwAudioKit = new HwAudioKit(this.mContext, new IAudioKitCallback(){

            @Override
            public void onResult(int n2) {
                switch (n2) {
                    case 0: {
                        Logging.i(HuaweiHardwareEarback.TAG, "IAudioKitCallback: HwAudioKit init success");
                        break;
                    }
                    case 1000: {
                        HuaweiHardwareEarback.this.mInited = true;
                        Logging.i(HuaweiHardwareEarback.TAG, "IAudioKitCallback: HwAudioKaraokeFeatureKit init success ");
                        break;
                    }
                    case 2: {
                        Logging.i(HuaweiHardwareEarback.TAG, "IAudioKitCallback: audio kit not installed");
                        break;
                    }
                    default: {
                        Logging.e(HuaweiHardwareEarback.TAG, "IAudioKitCallback: onResult error number " + n2);
                    }
                }
            }
        });
        this.mHwAudioKit.initialize();
        this.mHwAudioKaraokeFeatureKit = (HwAudioKaraokeFeatureKit)this.mHwAudioKit.createFeature(HwAudioKit.FeatureType.HWAUDIO_FEATURE_KARAOKE);
    }

    @Override
    public boolean isHardwareEarbackSupported() {
        if (!this.mInited) {
            return false;
        }
        Logging.d(TAG, ">>isHardwareEarbackSupported");
        boolean bl = this.mHwAudioKaraokeFeatureKit.isKaraokeFeatureSupport();
        Logging.d(TAG, "isSupported " + bl);
        return bl;
    }

    @Override
    public synchronized int setHardwareEarbackVolume(int n2) {
        if (!this.mInited) {
            return -7;
        }
        Logging.d(TAG, ">>setHardwareEarbackVolume " + n2);
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > 100) {
            n2 = 100;
        }
        int n3 = this.mHwAudioKaraokeFeatureKit.setParameter(HwAudioKaraokeFeatureKit.ParameName.CMD_SET_VOCAL_VOLUME_BASE, n2);
        if (n3 != 0) {
            Logging.e(TAG, "setParameter error number " + n3);
            return -1;
        }
        this.volume = n2;
        return 0;
    }

    @Override
    public synchronized int enableEarbackFeature(boolean bl) {
        if (!this.mInited) {
            return -7;
        }
        Logging.d(TAG, ">>enableEarbackFeature " + bl);
        if (!this.mHwAudioKaraokeFeatureKit.isKaraokeFeatureSupport()) {
            Logging.e(TAG, "karaoke not supported");
            return -1;
        }
        int n2 = this.mHwAudioKaraokeFeatureKit.enableKaraokeFeature(bl);
        if (n2 != 0) {
            Logging.e(TAG, "enableKaraokeFeature failed ret " + n2);
            return -1;
        }
        this.mEarbackEnabled = bl;
        if (this.mEarbackEnabled) {
            this.latency = this.mHwAudioKaraokeFeatureKit.getKaraokeLatency();
            Logging.i(TAG, "latency " + this.latency);
        }
        return 0;
    }

    @Override
    public void destroy() {
        Logging.d(TAG, ">>destroy");
        this.mHwAudioKaraokeFeatureKit.destroy();
        this.mHwAudioKit.destroy();
    }

    protected void finalize() throws Throwable {
        Logging.d(TAG, ">>finalize");
        this.destroy();
        super.finalize();
    }
}

