/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.audio;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Configuration;
import android.media.AudioManager;
import android.media.AudioRecord;
import android.media.AudioRecordingConfiguration;
import android.media.AudioTimestamp;
import android.media.AudioTrack;
import android.media.MediaRouter;
import android.media.audiofx.AcousticEchoCanceler;
import android.media.audiofx.AudioEffect;
import android.os.Build;
import android.os.LocaleList;
import android.os.Process;
import android.util.DisplayMetrics;
import io.agora.rtc.audio.HardwareEarbackController;
import io.agora.rtc.internal.Logging;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.locks.ReentrantLock;

class AudioDevice {
    final String TAG = "AudioDevice Java";
    private final int _MaxRecPlay10msBlocks = 4;
    private AudioTrack _audioTrack = null;
    private AudioRecord _audioRecord = null;
    private Context _context;
    private AudioManager _audioManager;
    private ByteBuffer _playBuffer;
    private ByteBuffer _recBuffer;
    private byte[] _tempBufPlay;
    private byte[] _tempBufRec;
    private final ReentrantLock _playLock = new ReentrantLock();
    private final ReentrantLock _recLock = new ReentrantLock();
    private boolean _doPlayInit = true;
    private boolean _doRecInit = true;
    private boolean _isRecording = false;
    private boolean _isPlaying = false;
    private int _bufferedRecSamples = 0;
    private int _bufferedPlaySamples = 0;
    private int _playPosition = 0;
    private int _playbackSampleRate = 0;
    private int _playBufSize = 0;
    private int _playbackRestartCount = 0;
    private int _recordSampleRate = 0;
    private int _recordChannel = 0;
    private int _playChannel = 0;
    private int _recordBufSize = 0;
    private int _recordSource = 0;
    private int _recordRestartCount = 0;
    private boolean _renderStart = false;
    private long _firstRenderTS = 0L;
    private int _playPreviousUnderrun = 0;
    private long _recDelay = 10L;
    private long _lastRecDelay = 0L;
    private long _recStartTS = 0L;
    private int _recStartDelay = 0;
    private AcousticEchoCanceler aec = null;
    private boolean useBuiltInAEC = false;
    private int _streamType = 0;
    private int playWriten = 0;
    private int maxDelay = 0;
    private int totalDelay = 0;

    AudioDevice() {
        try {
            this._playBuffer = ByteBuffer.allocateDirect(7680);
            this._recBuffer = ByteBuffer.allocateDirect(7680);
        }
        catch (Exception exception) {
            Logging.e("AudioDevice Java", "failed to allocate bytebuffer", exception);
        }
        this._tempBufPlay = new byte[7680];
        this._tempBufRec = new byte[7680];
        if (this._context != null) {
            HardwareEarbackController.getInstance(this._context);
        }
    }

    private boolean BuiltInAECIsAvailable() {
        try {
            if (Build.VERSION.SDK_INT >= 17) {
                return AcousticEchoCanceler.isAvailable();
            }
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            Logging.e("AudioDevice Java", "Unable to create AEC object ", exceptionInInitializerError);
        }
        catch (Exception exception) {
            Logging.e("AudioDevice Java", "Unable to query Audio Effect: Acoustic Echo Cancellation");
        }
        return false;
    }

    private int GetPreferedSampleRate() {
        int n2 = 0;
        try {
            if (this._audioManager == null && this._context != null) {
                this._audioManager = (AudioManager)this._context.getSystemService("audio");
            }
            String string = this._audioManager.getProperty("android.media.property.OUTPUT_SAMPLE_RATE");
            n2 = Integer.parseInt(string);
        }
        catch (Exception exception) {
            Logging.e("AudioDevice Java", "GetPreferedSampleRate error", exception);
        }
        if (n2 == 0) {
            n2 = 16000;
        }
        return n2;
    }

    private boolean EnableBuiltInAEC(boolean bl) {
        if (Build.VERSION.SDK_INT <= 18) {
            return false;
        }
        this.useBuiltInAEC = bl;
        if (this.aec != null) {
            int n2 = this.aec.setEnabled(bl);
            if (n2 != 0) {
                Logging.e("AudioDevice Java", "AcousticEchoCanceler.setEnabled failed");
                return false;
            }
            Logging.e("AudioDevice Java", "AcousticEchoCanceler.getEnabled: " + this.aec.getEnabled());
        }
        return true;
    }

    private boolean BuiltInAECIsEnabled() {
        return this.useBuiltInAEC;
    }

    private int InitRecording(int n2, int n3, int n4) {
        int n5 = AudioRecord.getMinBufferSize((int)n3, (int)(n4 == 2 ? 12 : 16), (int)2);
        Logging.d("AudioDevice Java", "Java minimum recording buffer size is " + n5);
        int n6 = n5;
        this._bufferedRecSamples = 5 * n3 / 200;
        if (this.aec != null) {
            this.aec.release();
            this.aec = null;
        }
        if (this._audioRecord != null) {
            this._audioRecord.release();
            this._audioRecord = null;
        }
        try {
            this._audioRecord = new AudioRecord(n2, n3, n4 == 2 ? 12 : 16, 2, n6);
        }
        catch (Exception exception) {
            Logging.e("AudioDevice Java", "Unable to new AudioRecord: ", exception);
            return -1;
        }
        if (this._audioRecord.getState() != 1) {
            Logging.e("AudioDevice Java", "Java recording not initialized " + n3);
            return -2;
        }
        this._recordSampleRate = n3;
        this._recordChannel = n4;
        this._recordSource = n2;
        this._recordBufSize = n6;
        this._recordRestartCount = 0;
        Logging.d("AudioDevice Java", "Java recording sample rate set to " + n3);
        Logging.d("AudioDevice Java", "AcousticEchoCanceler.isAvailable: " + this.BuiltInAECIsAvailable());
        if (!this.BuiltInAECIsAvailable()) {
            return this._bufferedRecSamples;
        }
        this.aec = AcousticEchoCanceler.create((int)this._audioRecord.getAudioSessionId());
        if (this.aec == null) {
            Logging.e("AudioDevice Java", "AcousticEchoCanceler.create failed");
        } else {
            AudioEffect.Descriptor descriptor = this.aec.getDescriptor();
            if (null == descriptor) {
                Logging.e("AudioDevice Java", "getDescriptor() failed");
            } else {
                Logging.d("AudioDevice Java", "AcousticEchoCanceler name: " + descriptor.name + ", implementor: " + descriptor.implementor + ", uuid: " + descriptor.uuid);
            }
            this.EnableBuiltInAEC(this.useBuiltInAEC);
        }
        return this._bufferedRecSamples;
    }

    private int StartRecording() {
        try {
            if (this._audioRecord == null) {
                return -2;
            }
            this._audioRecord.startRecording();
            Logging.e("AudioDevice Java", "Recording start time " + System.nanoTime());
            this._recStartTS = System.nanoTime();
            this._recStartDelay = 0;
            this._recDelay = 10L;
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e("AudioDevice Java", "failed to startRecording", illegalStateException);
            return -1;
        }
        catch (Exception exception) {
            Logging.e("AudioDevice Java", "failed to startRecording Exception", exception);
            return -2;
        }
        this._isRecording = true;
        return 0;
    }

    private int CheckAudioStatus(int n2) {
        int n3 = 0;
        if (Build.VERSION.SDK_INT >= 24) {
            if (this._audioManager == null) {
                if (this._context != null) {
                    this._audioManager = (AudioManager)this._context.getSystemService("audio");
                } else {
                    Logging.e("AudioDevice Java", "CheckAudioStatus error");
                    return -1;
                }
            }
            if (n2 == 0) {
                if (this._context.checkPermission("android.permission.RECORD_AUDIO", Process.myPid(), Process.myUid()) != 0) {
                    n3 = 1027;
                    Logging.e("AudioDevice Java", "CheckAudioStatus Microphone Permission denied");
                    return n3;
                }
                if (this._audioManager != null) {
                    int n4 = -1;
                    if (this._audioRecord != null) {
                        n4 = this._audioRecord.getAudioSessionId();
                    }
                    List list = this._audioManager.getActiveRecordingConfigurations();
                    for (AudioRecordingConfiguration audioRecordingConfiguration : list) {
                        if (audioRecordingConfiguration.getClientAudioSessionId() == n4) continue;
                        n3 = 1033;
                    }
                } else {
                    Logging.e("AudioDevice Java", "CheckAudioStatus unkonwn error");
                    return -1;
                }
            }
        }
        return n3;
    }

    private int InitPlayback(int n2, int n3, int n4, int n5) {
        this._streamType = n4;
        int n6 = n5 * n2 * n3 * 2 / 1000;
        int n7 = AudioTrack.getMinBufferSize((int)n2, (int)(n3 == 2 ? 12 : 4), (int)2);
        Logging.d("AudioDevice Java", "Java minimum playback buffer size is " + n7 + ", profiledMiniOutBufferSize is " + n6 + " stream type " + this._streamType);
        int n8 = n7;
        if (n8 < n6) {
            n8 = n6;
        }
        this._bufferedPlaySamples = 0;
        Logging.d("AudioDevice Java", "Java playback buffer size is " + n8 + ", duration is " + n8 * 1000 / (n2 * n3 * 2) + " ms");
        if (this._audioTrack != null) {
            this._audioTrack.release();
            this._audioTrack = null;
        }
        try {
            this._audioTrack = new AudioTrack(this._streamType, n2, n3 == 2 ? 12 : 4, 2, n8, 1);
        }
        catch (Exception exception) {
            Logging.e("AudioDevice Java", "Unable to new AudioTrack: ", exception);
            return -1;
        }
        this._playbackSampleRate = n2;
        this._playChannel = n3;
        this._playBufSize = n8;
        this._playbackRestartCount = 0;
        if (this._audioTrack.getState() != 1) {
            Logging.e("AudioDevice Java", "Java playback not initialized " + n2);
            return -1;
        }
        Logging.d("AudioDevice Java", "Java play sample rate is set to " + n2);
        if (this._audioManager == null && this._context != null) {
            this._audioManager = (AudioManager)this._context.getSystemService("audio");
        }
        if (this._audioManager == null) {
            return 0;
        }
        return this._audioManager.getStreamMaxVolume(this._streamType);
    }

    private int StartPlayback() {
        this._firstRenderTS = 0L;
        this._renderStart = false;
        try {
            this.playWriten = 0;
            this._audioTrack.play();
            this.maxDelay = 0;
            this.totalDelay = 0;
        }
        catch (IllegalStateException illegalStateException) {
            illegalStateException.printStackTrace();
            return -1;
        }
        catch (Exception exception) {
            Logging.e("AudioDevice Java", "startplayback fail", exception);
            return -1;
        }
        this._isPlaying = true;
        return 0;
    }

    private int StopRecording() {
        this._recLock.lock();
        try {
            if (this._audioRecord.getRecordingState() == 3) {
                this._audioRecord.stop();
            }
            if (this.aec != null) {
                this.aec.release();
                this.aec = null;
            }
            this._audioRecord.release();
            this._audioRecord = null;
        }
        catch (Exception exception) {
            Logging.e("AudioDevice Java", "error in StopRecording ", exception);
        }
        finally {
            if (this._audioRecord != null) {
                this._audioRecord.release();
                this._audioRecord = null;
            }
            this._doRecInit = true;
            this._recLock.unlock();
        }
        this._isRecording = false;
        return 0;
    }

    private int StopPlayback() {
        this._firstRenderTS = 0L;
        this._playLock.lock();
        try {
            if (Build.VERSION.SDK_INT >= 21) {
                this._audioTrack.setVolume(0.0f);
            } else {
                this._audioTrack.setStereoVolume(0.0f, 0.0f);
            }
            if (this._audioTrack.getPlayState() == 3) {
                this._audioTrack.stop();
                this._audioTrack.flush();
            }
            this._audioTrack.release();
            this._audioTrack = null;
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e("AudioDevice Java", "Unable to stop playback: ", illegalStateException);
            int n2 = -1;
            return n2;
        }
        catch (Exception exception) {
            Logging.e("AudioDevice Java", "Stop playback fail", exception);
        }
        finally {
            if (this._audioTrack != null) {
                this._audioTrack.flush();
                this._audioTrack.release();
                this._audioTrack = null;
            }
            this._doPlayInit = true;
            this._playLock.unlock();
        }
        this._isPlaying = false;
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int PlayAudio(int n2) {
        int n3;
        block19: {
            n3 = 0;
            this._playLock.lock();
            try {
                if (this._audioTrack == null) {
                    int n4 = -2;
                    return n4;
                }
                if (this._doPlayInit) {
                    try {
                        Process.setThreadPriority((int)-19);
                    }
                    catch (Exception exception) {
                        Logging.e("AudioDevice Java", "Set play thread priority failed: ", exception);
                    }
                    this._doPlayInit = false;
                }
                int n5 = 0;
                this._playBuffer.get(this._tempBufPlay);
                n5 = this._audioTrack.write(this._tempBufPlay, 0, n2);
                this._playBuffer.rewind();
                this._bufferedPlaySamples += n5 >> 1;
                this.playWriten += n5;
                int n6 = this._audioTrack.getPlaybackHeadPosition() * this._playChannel;
                int n7 = this.maxDelay = (this.playWriten / 2 - n6) / 2 / 48 > this.maxDelay ? (this.playWriten / 2 - n6) / 2 / 48 : this.maxDelay;
                if (this._firstRenderTS == 0L) {
                    this._firstRenderTS = System.currentTimeMillis();
                }
                if (n6 > 0 && !this._renderStart) {
                    this._firstRenderTS = System.currentTimeMillis() - this._firstRenderTS;
                    Logging.e("AudioDevice Java", "caculated the first render TS = " + this._firstRenderTS + " pos = " + n6 / 2 / 48 + "ms delay " + (this._firstRenderTS + (long)this.maxDelay));
                    this._renderStart = true;
                }
                if (this._renderStart) {
                    this.totalDelay = (int)this._firstRenderTS + this.maxDelay;
                }
                if (n6 < this._playPosition) {
                    this._playPosition = 0;
                }
                this._bufferedPlaySamples -= n6 - this._playPosition;
                this._playPosition = n6;
                if (!this._isRecording) {
                    n3 = this._bufferedPlaySamples;
                }
                if (n5 == n2) break block19;
                if (this._playbackRestartCount > 20) {
                    int n8 = n5;
                    return n8;
                }
                Logging.e("AudioDevice Java", "Error writing AudioTrack! Restart AudioTrack " + this._playbackRestartCount);
                ++this._playbackRestartCount;
                this._audioTrack.stop();
                this._audioTrack.release();
                this._audioTrack = null;
                try {
                    this._audioTrack = new AudioTrack(this._streamType, this._playbackSampleRate, this._playChannel == 2 ? 12 : 4, 2, this._playBufSize, 1);
                    this._audioTrack.play();
                }
                catch (Exception exception) {
                    Logging.e("AudioDevice Java", "restart audio fail", exception);
                }
                int n9 = n5;
                return n9;
            }
            catch (Exception exception) {
                Logging.e("AudioDevice Java", "PlayAudio got fatal error ", exception);
            }
            finally {
                this._playLock.unlock();
            }
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int RecordAudio(int n2) {
        this._recLock.lock();
        int n3 = this._bufferedPlaySamples;
        try {
            if (this._audioRecord == null) {
                int n4 = -4;
                return n4;
            }
            if (this._doRecInit) {
                try {
                    Process.setThreadPriority((int)-19);
                }
                catch (Exception exception) {
                    Logging.e("AudioDevice Java", "Set rec thread priority failed: ", exception);
                }
                this._doRecInit = false;
            }
            int n5 = 0;
            this._recBuffer.rewind();
            n5 = this._audioRecord.read(this._tempBufRec, 0, n2);
            this._recBuffer.put(this._tempBufRec);
            if (this._recDelay == 10L) {
                if (Build.VERSION.SDK_INT >= 24) {
                    AudioTimestamp audioTimestamp = new AudioTimestamp();
                    this._audioRecord.getTimestamp(audioTimestamp, 0);
                    this._recDelay = (System.nanoTime() - audioTimestamp.nanoTime) / 1000L / 1000L;
                    if (this._recDelay > 50L) {
                        this._recDelay = 10L;
                    }
                } else {
                    this._recDelay = 10L;
                }
                if (this._recStartDelay == 0) {
                    this._recStartDelay = (int)(System.nanoTime() - this._recStartTS) / 1000 / 1000;
                }
                this._recDelay += (long)this._recStartDelay;
            }
            if (this._lastRecDelay != this._recDelay) {
                if (Build.VERSION.SDK_INT >= 23) {
                    int n6 = this._audioRecord.getBufferSizeInFrames();
                    Logging.i("AudioDevice Java", "frames  " + n6 + " recDelay " + this._recDelay + " caculated frames delay " + n6 / (this._audioRecord.getSampleRate() / 1000));
                } else {
                    Logging.i("AudioDevice Java", "_recDelay: " + this._recDelay);
                }
                this._lastRecDelay = this._recDelay;
            }
            if (n5 != n2) {
                if (this._recordRestartCount % 10 == 0) {
                    Logging.e("AudioDevice Java", "Error reading AudioRecord! AudioRecord.read returns " + n5);
                }
                ++this._recordRestartCount;
                this._audioRecord.stop();
                this._audioRecord.release();
                this._audioRecord = null;
                this._audioRecord = new AudioRecord(this._recordSource, this._recordSampleRate, this._recordChannel == 2 ? 12 : 16, 2, this._recordBufSize);
                this._audioRecord.startRecording();
                this._recStartTS = System.nanoTime();
                this._recStartDelay = 0;
                int n7 = n5;
                return n7;
            }
        }
        catch (Exception exception) {
            n3 = -10;
            Logging.e("AudioDevice Java", "RecordAudio try failed: ", exception);
        }
        finally {
            this._recLock.unlock();
        }
        return n3;
    }

    private int GetUnderrunCount() {
        if (Build.VERSION.SDK_INT >= 24) {
            return this.GetUnderrunCountOnNougatOrHigher();
        }
        return this.GetUnderrunCountOnLowerThanNougat();
    }

    @TargetApi(value=24)
    private int GetUnderrunCountOnNougatOrHigher() {
        int n2 = 0;
        int n3 = 0;
        if (Build.VERSION.SDK_INT >= 24) {
            try {
                n3 = this._audioTrack.getUnderrunCount();
            }
            catch (Exception exception) {
                Logging.e("AudioDevice Java", "getUnderrun fail ", exception);
            }
            n2 = n3 - this._playPreviousUnderrun;
            if (n2 < 0) {
                n2 = 0;
            }
            this._playPreviousUnderrun = n3;
            if (n2 > 0) {
                Logging.d("AudioDevice Java", "Android AudioTrack underrun count: " + n2);
            }
        }
        return n2;
    }

    private int GetUnderrunCountOnLowerThanNougat() {
        return -1;
    }

    private int QuerySpeakerStatus() {
        if (this._audioManager == null && this._context != null) {
            this._audioManager = (AudioManager)this._context.getSystemService("audio");
        }
        try {
            if (Build.VERSION.SDK_INT >= 26) {
                MediaRouter mediaRouter = (MediaRouter)this._context.getSystemService("media_router");
                MediaRouter.RouteInfo routeInfo = mediaRouter.getSelectedRoute(1);
                routeInfo.getName().toString().compareToIgnoreCase("phone");
                Configuration configuration = this._context.getResources().getConfiguration();
                LocaleList localeList = configuration.getLocales();
                DisplayMetrics displayMetrics = this._context.getResources().getDisplayMetrics();
                configuration.setLocale(Locale.ENGLISH);
                int n2 = -1;
                this._context.getResources().updateConfiguration(configuration, displayMetrics);
                if (routeInfo.getName(this._context).toString().compareToIgnoreCase("phone") == 0) {
                    Logging.e("AudioDevice Java", "speaker");
                } else if (routeInfo.getName(this._context).toString().compareToIgnoreCase("headset") == 0) {
                    Logging.e("AudioDevice Java", "headset");
                    n2 = 0;
                } else if (routeInfo.getName(this._context).toString().compareToIgnoreCase("bluetooth") == 0) {
                    Logging.e("AudioDevice Java", "bluetooth");
                    n2 = 5;
                }
                configuration.setLocales(localeList);
                this._context.getResources().updateConfiguration(configuration, displayMetrics);
                if (n2 != -1) {
                    return n2;
                }
            }
        }
        catch (Exception exception) {
            Logging.e("error in Query audio route ");
            exception.printStackTrace();
        }
        if (this._audioManager == null) {
            Logging.e("AudioDevice Java", "Could not get audio routing - no audio manager");
            return -1;
        }
        if (this._audioManager.isBluetoothA2dpOn()) {
            return 5;
        }
        if (this._audioManager.isSpeakerphoneOn()) {
            return 3;
        }
        if (this._audioManager.isBluetoothScoOn()) {
            return 5;
        }
        if (this._audioManager.isWiredHeadsetOn()) {
            return 0;
        }
        return 1;
    }

    private int SetPlayoutSpeaker(boolean bl) {
        if (this._audioManager == null && this._context != null) {
            this._audioManager = (AudioManager)this._context.getSystemService("audio");
        }
        if (this._audioManager == null) {
            Logging.e("AudioDevice Java", "Could not change audio routing - no audio manager");
            return -1;
        }
        this._audioManager.setSpeakerphoneOn(bl);
        return 0;
    }

    private int SetPlayoutVolume(int n2) {
        if (this._audioManager == null && this._context != null) {
            this._audioManager = (AudioManager)this._context.getSystemService("audio");
        }
        int n3 = -1;
        if (this._audioManager != null) {
            int n4 = this._audioManager.getStreamMaxVolume(this._streamType);
            n2 = n2 >= 255 ? n4 : n2 * n4 / 255;
            this._audioManager.setStreamVolume(this._streamType, n2, 0);
            n3 = 0;
        }
        return n3;
    }

    private int GetPlayoutVolume() {
        if (this._audioManager == null && this._context != null) {
            this._audioManager = (AudioManager)this._context.getSystemService("audio");
        }
        int n2 = -1;
        if (this._audioManager != null) {
            n2 = this._audioManager.getStreamVolume(this._streamType);
        }
        return n2;
    }

    private int GetPlayoutMaxVolume() {
        if (this._audioManager == null && this._context != null) {
            this._audioManager = (AudioManager)this._context.getSystemService("audio");
        }
        int n2 = -1;
        if (this._audioManager != null) {
            n2 = this._audioManager.getStreamMaxVolume(this._streamType);
        }
        return n2;
    }

    private int SetAudioMode(int n2) {
        try {
            if (this._audioManager == null && this._context != null) {
                this._audioManager = (AudioManager)this._context.getSystemService("audio");
            }
            if (this._audioManager == null) {
                Logging.e("AudioDevice Java", "Could not change audio routing - no audio manager");
                return -1;
            }
            int n3 = this._audioManager.getStreamMaxVolume(3);
            int n4 = this._audioManager.getStreamVolume(3);
            int n5 = this._audioManager.getStreamMaxVolume(0);
            int n6 = this._audioManager.getStreamVolume(0);
            int n7 = n3 - n5;
            double d2 = (double)n5 / (double)n3;
            if (this._audioManager.getMode() == n2) {
                return 0;
            }
            if (this._isPlaying) {
                Logging.e("AudioDevice Java", "_audioManager.getMode() = " + this._audioManager.getMode() + " target mode = " + n2 + "factorX = " + n7 + "mMediaMaxVolume=" + n3 + "mCommMaxVolume=" + n5 + "mCurrMediaVolume=" + n4 + "mCurrCommVolume=" + n6 + "delta" + d2);
                if (n2 == 3) {
                    int n8 = n6;
                    n8 = n7 < 12 ? (n4 - n7 < 1 ? 1 : n4 - n7) : (int)((double)n4 * d2 + 0.5);
                    n8 = n8 < 1 ? 1 : n8;
                    Logging.d("[Java AudioDevice] set voice call vol = " + n8);
                    this._audioManager.setStreamVolume(0, n8, 0);
                } else if (n2 == 0) {
                    int n9 = n4;
                    n9 = n7 < 12 ? (n6 + n7 < n3 ? n6 + n7 : n3) : (int)((double)n6 / d2 + 0.5);
                    n9 = n9 < 1 ? 1 : n9;
                    this._audioManager.setStreamVolume(3, n9, 0);
                    Logging.d("[Java AudioDevice] set music vol = " + n9);
                }
            }
            switch (n2) {
                case 0: {
                    this._audioManager.setMode(0);
                    break;
                }
                case 1: {
                    this._audioManager.setMode(1);
                    break;
                }
                case 2: {
                    this._audioManager.setMode(2);
                    break;
                }
                case 3: {
                    this._audioManager.setMode(3);
                    break;
                }
                default: {
                    this._audioManager.setMode(0);
                    break;
                }
            }
        }
        catch (Exception exception) {
            Logging.e("AudioDevice Java", "set audio mode failed! ");
        }
        return 0;
    }

    private int GetAudioMode() {
        if (this._audioManager == null && this._context != null) {
            this._audioManager = (AudioManager)this._context.getSystemService("audio");
        }
        if (this._audioManager == null) {
            Logging.e("AudioDevice Java", "Could not change audio routing - no audio manager");
            return -1;
        }
        return this._audioManager.getMode();
    }

    private int GetNativeSampleRate() {
        String string;
        int n2 = 44100;
        if (this._audioManager == null && this._context != null) {
            this._audioManager = (AudioManager)this._context.getSystemService("audio");
        }
        if (this._audioManager == null) {
            Logging.w("AudioDevice Java", "Could not set audio mode - no audio manager");
            return n2;
        }
        if (Build.VERSION.SDK_INT >= 17 && (string = this._audioManager.getProperty("android.media.property.OUTPUT_SAMPLE_RATE")) != null) {
            n2 = Integer.parseInt(string);
        }
        return n2;
    }

    private int GetNativePlayDelay() {
        if (this._recDelay < 0L) {
            this._recDelay = -1L;
        }
        if (this.totalDelay < 0) {
            this.totalDelay = -1;
        }
        return this.totalDelay + (int)this._recDelay;
    }

    private boolean isHardwareEarbackSupported() {
        boolean bl = false;
        if (this._context != null) {
            bl = HardwareEarbackController.getInstance(this._context).isHardwareEarbackSupported();
        }
        return bl;
    }

    private int enableHardwareEarback(boolean bl) {
        Logging.i("AudioDevice Java", "enableHardwareEarback " + bl);
        int n2 = -1;
        n2 = HardwareEarbackController.getInstance(this._context).enableHardwareEarback(bl);
        Logging.i("AudioDevice Java", "enableHardwareEarback " + bl + " ret " + n2);
        return n2;
    }

    private int setHardwareEarbackVolume(int n2) {
        int n3 = -1;
        if (this._context != null) {
            n3 = HardwareEarbackController.getInstance(this._context).setHardwareEarbackVolume(n2);
        }
        return n3;
    }
}

