/*
 * Decompiled with CFR 0.152.
 */
package com.coloros.ocs.base.task;

import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import com.coloros.ocs.base.task.OnCanceledListener;
import com.coloros.ocs.base.task.OnFailureListener;
import com.coloros.ocs.base.task.OnSuccessListener;
import com.coloros.ocs.base.task.Task;
import com.coloros.ocs.base.task.TaskExecutors;
import com.coloros.ocs.base.task.TaskImpl;
import com.coloros.ocs.base.task.o;
import com.coloros.ocs.base.task.p;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class Tasks {
    public static <TResult> Task<TResult> forResult(TResult tresult) {
        TResult TResult;
        TaskImpl<TResult> taskImpl = new TaskImpl<TResult>();
        taskImpl.setResult(TResult);
        return taskImpl;
    }

    public static <TResult> Task<TResult> forException(@NonNull Exception exc) {
        Exception exception;
        TaskImpl taskImpl = new TaskImpl();
        taskImpl.setException(exception);
        return taskImpl;
    }

    public static <TResult> Task<TResult> forCanceled() {
        TaskImpl taskImpl = new TaskImpl();
        taskImpl.tryCancel();
        return taskImpl;
    }

    public static <TResult> Task<TResult> call(@NonNull Callable<TResult> callable) {
        Callable<TResult> callable2;
        return Tasks.call(TaskExecutors.MAIN_THREAD, callable2);
    }

    /*
     * WARNING - void declaration
     */
    public static <TResult> Task<TResult> call(@NonNull Executor executor, @NonNull Callable<TResult> callable) {
        void var1_1;
        Executor executor2;
        com.coloros.ocs.base.a.c.a(executor, (Object)"Executor must not be null");
        com.coloros.ocs.base.a.c.a(callable, (Object)"Callback must not be null");
        TaskImpl taskImpl = new TaskImpl();
        executor2.execute(new com.coloros.ocs.base.task.a(taskImpl, (Callable)var1_1));
        return taskImpl;
    }

    public static <TResult> TResult await(@NonNull Task<TResult> task) throws ExecutionException, InterruptedException {
        Task<TResult> task2;
        com.coloros.ocs.base.a.c.b("Must not be called on the main application thread");
        com.coloros.ocs.base.a.c.a(task, (Object)"Task must not be null");
        if (task.isComplete()) {
            return Tasks.a(task);
        }
        b b2 = new b(0);
        Tasks.a(task, b2);
        b2.a.await();
        return Tasks.a(task2);
    }

    /*
     * WARNING - void declaration
     */
    public static <TResult> TResult await(@NonNull Task<TResult> task, long timeout, @NonNull TimeUnit timeUnit) throws ExecutionException, InterruptedException, TimeoutException {
        void var1_1;
        void var3_2;
        com.coloros.ocs.base.a.c.b("Must not be called on the main application thread");
        com.coloros.ocs.base.a.c.a(task, (Object)"Task must not be null");
        com.coloros.ocs.base.a.c.a(timeUnit, (Object)"TimeUnit must not be null");
        if (task.isComplete()) {
            return Tasks.a(task);
        }
        b b2 = new b(0);
        Tasks.a(task, b2);
        void var2_4 = var3_2;
        void var5_5 = var1_1;
        if (b2.a.await((long)var5_5, (TimeUnit)var2_4)) {
            Task<TResult> task2;
            return Tasks.a(task2);
        }
        throw new TimeoutException("Timed out waiting for Task");
    }

    public static Task<Void> whenAll(Collection<? extends Task<?>> collection) {
        Iterator<? extends Task<?>> iterator;
        if (collection.isEmpty()) {
            return Tasks.forResult(null);
        }
        Object object = collection.iterator();
        while (object.hasNext()) {
            if (object.next() != null) continue;
            throw new NullPointerException("null tasks are not accepted");
        }
        object = new TaskImpl();
        a a2 = new a(collection.size(), (TaskImpl<Void>)object);
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Tasks.a((Task)iterator.next(), a2);
        }
        return object;
    }

    public static Task<Void> whenAll(Task<?> ... taskArr) {
        Task<?>[] taskArray;
        if (taskArr.length == 0) {
            return Tasks.forResult(null);
        }
        return Tasks.whenAll(Arrays.asList(taskArray));
    }

    public static <TResult> Task<List<TResult>> whenAllSuccess(Collection<? extends Task<?>> collection) {
        Collection<? extends Task<?>> collection2;
        return Tasks.whenAll(collection).continueWith(new p(collection2));
    }

    public static <TResult> Task<List<TResult>> whenAllSuccess(Task<?> ... taskArr) {
        return Tasks.whenAllSuccess(Arrays.asList(taskArr));
    }

    public static Task<List<Task<?>>> whenAllComplete(Collection<? extends Task<?>> collection) {
        Collection<? extends Task<?>> collection2;
        return Tasks.whenAll(collection).continueWithTask(new o(collection2));
    }

    public static Task<List<Task<?>>> whenAllComplete(Task<?> ... taskArr) {
        return Tasks.whenAllComplete(Arrays.asList(taskArr));
    }

    private static <TResult> TResult a(Task<TResult> task) throws ExecutionException {
        if (task.isSuccessful()) {
            return task.getResult();
        }
        if (task.isCanceled()) {
            throw new CancellationException("Task is already canceled");
        }
        throw new ExecutionException(task.getException());
    }

    private static <TResult> void a(Task<TResult> task, c c2) {
        task.addOnSuccessListener(TaskExecutors.CURRENT_THREAD, c2);
        task.addOnFailureListener(TaskExecutors.CURRENT_THREAD, c2);
        task.addOnCanceledListener(TaskExecutors.CURRENT_THREAD, c2);
    }

    private Tasks() {
    }

    static final class a
    implements c {
        private final Object a = new Object();
        private TaskImpl<Void> b;
        @GuardedBy(value="mLock")
        private Exception c;
        private volatile int d;
        @GuardedBy(value="mLock")
        private volatile int e;
        @GuardedBy(value="mLock")
        private volatile int f;
        @GuardedBy(value="mLock")
        private volatile int g;
        @GuardedBy(value="mLock")
        private volatile boolean h;

        public a(int n2, TaskImpl<Void> taskImpl) {
            this.d = n2;
            this.b = taskImpl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public final void onFailure(@NonNull Exception exc) {
            Object object = this.a;
            synchronized (object) {
                void var1_1;
                ++this.f;
                this.c = var1_1;
                this.a();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void onSuccess(Object obj) {
            Object object = this.a;
            synchronized (object) {
                ++this.e;
                this.a();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void onCanceled() {
            Object object = this.a;
            synchronized (object) {
                ++this.g;
                this.h = true;
                this.a();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @GuardedBy(value="mLock")
        private void a() {
            Object object = this.a;
            synchronized (object) {
                if (this.e + this.f + this.g != this.d) {
                    return;
                }
                if (this.c != null) {
                    TaskImpl<Void> taskImpl = this.b;
                    int n2 = this.f;
                    taskImpl.setException(new ExecutionException(n2 + " out of " + this.d + " underlying tasks failed", this.c));
                } else if (this.h) {
                    this.b.tryCancel();
                } else {
                    this.b.setResult(null);
                }
                return;
            }
        }
    }

    static interface c
    extends OnCanceledListener,
    OnFailureListener,
    OnSuccessListener<Object> {
    }

    static final class b
    implements c {
        CountDownLatch a = new CountDownLatch(1);

        private b() {
        }

        @Override
        public final void onSuccess(Object obj) {
            this.a.countDown();
        }

        @Override
        public final void onFailure(@NonNull Exception exc) {
            this.a.countDown();
        }

        @Override
        public final void onCanceled() {
            this.a.countDown();
        }

        b(byte by) {
            this();
        }
    }
}

