/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.ss.gltool;

import android.graphics.Matrix;
import android.opengl.GLES20;
import android.util.Log;
import io.agora.rtc.ss.gltool.EglBase;
import io.agora.rtc.ss.gltool.GlRectDrawer;
import io.agora.rtc.ss.gltool.GlTextureFrameBuffer;
import io.agora.rtc.ss.gltool.TextureBufferHelper;
import io.agora.rtc.ss.gltool.VideoFrameDrawer;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;

public class VideoFrameProducer {
    private static final String TAG = VideoFrameProducer.class.getSimpleName();
    private static final List<String> EGL_EXCEPTION_MODELS = Arrays.asList("DUA-AL00", "Y83A", "M1816");
    private TextureBufferHelper textureBufferHelper;
    private GlRectDrawer textureDrawer;
    private VideoFrameDrawer videoFrameDrawer;
    private GlTextureFrameBuffer textureFrameBuffer;
    private boolean glPrepared = false;
    private boolean forceUseI420Rotate = false;

    public void dispose() {
        if (this.textureBufferHelper != null) {
            this.textureBufferHelper.invoke(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    if (VideoFrameProducer.this.textureDrawer != null) {
                        VideoFrameProducer.this.textureDrawer.release();
                        VideoFrameProducer.this.textureDrawer = null;
                    }
                    if (VideoFrameProducer.this.videoFrameDrawer != null) {
                        VideoFrameProducer.this.videoFrameDrawer.release();
                        VideoFrameProducer.this.videoFrameDrawer = null;
                    }
                    if (VideoFrameProducer.this.textureFrameBuffer != null) {
                        VideoFrameProducer.this.textureFrameBuffer.release();
                        VideoFrameProducer.this.textureFrameBuffer = null;
                    }
                    return null;
                }
            });
            this.textureBufferHelper.dispose();
            this.textureBufferHelper = null;
        }
        this.glPrepared = false;
    }

    public TexIdFrame copyTexture(EglBase.Context eglContext, final int width, final int height, final int textureId, final float[] fm) {
        boolean isTextureBuffer = true;
        if (!this.glPrepared) {
            this.glPrepared = this.prepareGl(eglContext);
        }
        return this.textureBufferHelper.invoke(new Callable<TexIdFrame>(){

            @Override
            public TexIdFrame call() throws Exception {
                if (VideoFrameProducer.this.textureBufferHelper.isTextureInUse()) {
                    return null;
                }
                int viewportWidth = width;
                int viewportHeight = height;
                VideoFrameProducer.this.textureFrameBuffer.setSize(viewportWidth, viewportHeight);
                GLES20.glBindFramebuffer((int)36160, (int)VideoFrameProducer.this.textureFrameBuffer.getFrameBufferId());
                Matrix matrix = new Matrix();
                matrix.setValues(fm);
                GLES20.glClear((int)16384);
                VideoFrameProducer.this.videoFrameDrawer.drawFrame(textureId, matrix, 1, VideoFrameProducer.this.textureDrawer, null, width, height);
                GLES20.glBindFramebuffer((int)36160, (int)0);
                GLES20.glFlush();
                TexIdFrame texIdFrame = new TexIdFrame(VideoFrameProducer.this.textureFrameBuffer.getTextureId());
                return texIdFrame;
            }
        });
    }

    private boolean prepareGl(EglBase.Context eglContext) {
        this.textureBufferHelper = TextureBufferHelper.create("textureRotator", eglContext);
        if (this.textureBufferHelper == null) {
            Log.e((String)TAG, (String)"Failed to create texture buffer helper!");
            return false;
        }
        this.textureBufferHelper.invoke(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                VideoFrameProducer.this.textureDrawer = new GlRectDrawer();
                VideoFrameProducer.this.videoFrameDrawer = new VideoFrameDrawer();
                VideoFrameProducer.this.textureFrameBuffer = new GlTextureFrameBuffer(6408);
                return null;
            }
        });
        return true;
    }

    public class TexIdFrame {
        public int texId;

        TexIdFrame(int tex) {
            this.texId = tex;
        }
    }
}

