/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.ss.gltool;

import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import io.agora.rtc.ss.gltool.EglBase;
import io.agora.rtc.ss.gltool.EglBase10;
import io.agora.rtc.ss.gltool.EglBase14;
import io.agora.rtc.utils.ThreadUtils;
import java.util.concurrent.Callable;

public class TextureBufferHelper {
    private static final String TAG = "TextureBufferHelper";
    private final Handler handler;
    private final EglBase eglBase;
    private int numOfTextureInUse = 0;
    private boolean isQuitting = false;

    public static TextureBufferHelper create(final String threadName, final EglBase.Context sharedContext) {
        HandlerThread thread = new HandlerThread(threadName);
        thread.start();
        final Handler handler = new Handler(thread.getLooper());
        return (TextureBufferHelper)ThreadUtils.invokeAtFrontUninterruptibly((Handler)handler, (Callable)new Callable<TextureBufferHelper>(){

            @Override
            public TextureBufferHelper call() {
                try {
                    return new TextureBufferHelper(sharedContext, handler);
                }
                catch (RuntimeException e) {
                    Log.e((String)TextureBufferHelper.TAG, (String)(threadName + " create failure"), (Throwable)e);
                    return null;
                }
            }
        });
    }

    private TextureBufferHelper(EglBase.Context sharedContext, Handler handler) {
        if (handler.getLooper().getThread() != Thread.currentThread()) {
            throw new IllegalStateException("TextureBufferHelper must be created on the handler thread");
        }
        this.handler = handler;
        this.eglBase = EglBase14.isEGL14Supported() && (sharedContext == null || sharedContext instanceof EglBase14.Context) ? new EglBase14((EglBase14.Context)sharedContext, EglBase.CONFIG_PIXEL_BUFFER) : new EglBase10((EglBase10.Context)sharedContext, EglBase.CONFIG_PIXEL_BUFFER);
        try {
            this.eglBase.createDummyPbufferSurface();
            this.eglBase.makeCurrent();
        }
        catch (RuntimeException e) {
            this.eglBase.release();
            handler.getLooper().quit();
            throw e;
        }
    }

    public Handler getHandler() {
        return this.handler;
    }

    public EglBase getEglBase() {
        return this.eglBase;
    }

    public <V> V invoke(Callable<V> callable) {
        return (V)ThreadUtils.invokeAtFrontUninterruptibly((Handler)this.handler, callable);
    }

    private void returnTextureFrame() {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                TextureBufferHelper.this.numOfTextureInUse--;
                if (TextureBufferHelper.this.isQuitting) {
                    TextureBufferHelper.this.release();
                }
            }
        });
    }

    public boolean isTextureInUse() {
        return this.numOfTextureInUse > 0;
    }

    public void dispose() {
        Log.d((String)TAG, (String)"dispose()");
        ThreadUtils.invokeAtFrontUninterruptibly((Handler)this.handler, (Runnable)new Runnable(){

            @Override
            public void run() {
                TextureBufferHelper.this.isQuitting = true;
                if (!TextureBufferHelper.this.isTextureInUse()) {
                    TextureBufferHelper.this.release();
                }
            }
        });
    }

    private void release() {
        if (this.handler.getLooper().getThread() != Thread.currentThread()) {
            throw new IllegalStateException("Wrong thread.");
        }
        if (this.isTextureInUse() || !this.isQuitting) {
            throw new IllegalStateException("Unexpected release.");
        }
        Log.d((String)TAG, (String)"release()");
        this.eglBase.release();
        this.handler.getLooper().quit();
    }
}

