/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.video;

import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;

public class CoordinatesTransform {
    public static RectF normalizedFaceRect(Rect rect, int n2, boolean bl) {
        Matrix matrix = new Matrix();
        CoordinatesTransform.prepareMatrix(matrix, bl, n2);
        RectF rectF = new RectF(rect);
        matrix.mapRect(rectF);
        return rectF;
    }

    private static void prepareMatrix(Matrix matrix, boolean bl, int n2) {
        matrix.setScale(bl ? -1.0f : 1.0f, 1.0f);
        matrix.postRotate((float)n2);
        matrix.postScale(5.0E-4f, 5.0E-4f);
        matrix.postTranslate(0.5f, 0.5f);
    }

    public static Rect sensorToNormalizedPreview(Rect rect, int n2, int n3, Rect rect2) {
        double d2 = n2 > n3 ? (double)n2 / (double)n3 : (double)n3 / (double)n2;
        double d3 = (double)rect2.width() / (double)rect2.height();
        int n4 = rect2.width();
        int n5 = rect2.height();
        if (d2 > d3) {
            n5 = (int)((double)n4 / d2);
        } else {
            n4 = (int)((double)n5 * d2);
        }
        int n6 = Math.abs(n4 - rect2.width());
        int n7 = Math.abs(n5 - rect2.height());
        RectF rectF = new RectF(rect);
        Matrix matrix = new Matrix();
        matrix.postTranslate((float)(-rect2.left - n6 / 2), (float)(-rect2.top - n7 / 2));
        matrix.postTranslate((float)(-n4 / 2), (float)(-n5 / 2));
        matrix.postScale(2000.0f / (float)n4, 2000.0f / (float)n5);
        matrix.mapRect(rectF);
        Rect rect3 = new Rect();
        rectF.round(rect3);
        return rect3;
    }
}

