/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.video;

import android.graphics.Matrix;
import android.os.Build;
import android.os.Handler;
import io.agora.rtc.gl.EglBase;
import io.agora.rtc.gl.RendererCommon;
import io.agora.rtc.gl.VideoFrame;
import io.agora.rtc.gl.YuvConverter;
import io.agora.rtc.utils.ThreadUtils;
import java.util.concurrent.Callable;

public class AGraphicBufferEx
implements VideoFrame.TextureBuffer {
    private final EglBase.Context eglContext;
    private int width;
    private int height;
    private final VideoFrame.TextureBuffer.Type type;
    private final int id;
    private Matrix transformMatrix;
    private final Handler toI420Handler;
    private final Runnable releaseCallback;
    private final Object refCountLock = new Object();
    private int refCount;
    private long mHandler;

    public AGraphicBufferEx(EglBase.Context context, int n2, int n3, Handler handler, int n4, Matrix matrix, Runnable runnable) {
        this.eglContext = context;
        this.width = n2;
        this.height = n3;
        this.type = VideoFrame.TextureBuffer.Type.OES;
        this.id = n4;
        this.transformMatrix = matrix;
        this.toI420Handler = handler;
        this.releaseCallback = runnable;
        this.refCount = 1;
        this.mHandler = this.initHardwareBuffer(n2, n3, n4);
    }

    @Override
    public VideoFrame.TextureBuffer.Type getType() {
        return this.type;
    }

    @Override
    public Matrix getTransformMatrix() {
        return this.transformMatrix;
    }

    @Override
    public EglBase.Context getEglBaseContext() {
        return this.eglContext;
    }

    @Override
    public long getNativeEglContext() {
        return this.eglContext != null ? this.eglContext.getNativeEglContext() : 0L;
    }

    @Override
    public float[] getGlTransformMatrix() {
        return RendererCommon.convertMatrixFromAndroidGraphicsMatrix(this.transformMatrix);
    }

    @Override
    public Object getRealEglContext() {
        return this.eglContext.getRealEglContext();
    }

    @Override
    public int getEglType() {
        return this.eglContext.getEglType();
    }

    @Override
    public Handler getToI420Handler() {
        return this.toI420Handler;
    }

    @Override
    public YuvConverter getYuvConverter() {
        return null;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public VideoFrame.I420Buffer toI420() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void retain() {
        Object object = this.refCountLock;
        synchronized (object) {
            ++this.refCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        Object object = this.refCountLock;
        synchronized (object) {
            if (--this.refCount == 0 && this.releaseCallback != null) {
                this.releaseCallback.run();
            }
        }
    }

    @Override
    public VideoFrame.Buffer cropAndScale(int n2, int n3, int n4, int n5, int n6, int n7) {
        Matrix matrix = new Matrix();
        int n8 = this.height - (n3 + n5);
        matrix.preTranslate((float)n2 / (float)this.width, (float)n8 / (float)this.height);
        matrix.preScale((float)n4 / (float)this.width, (float)n5 / (float)this.height);
        return this.applyTransformMatrix(matrix, n6, n7);
    }

    @Override
    public VideoFrame.TextureBuffer rotate(int n2) {
        boolean bl = n2 == 90 || n2 == 270;
        int n3 = bl ? this.height : this.width;
        int n4 = bl ? this.width : this.height;
        Matrix matrix = new Matrix();
        matrix.preTranslate(0.5f, 0.5f);
        matrix.preRotate((float)n2);
        matrix.preTranslate(-0.5f, -0.5f);
        return this.applyTransformMatrix(matrix, n3, n4);
    }

    @Override
    public VideoFrame.TextureBuffer flip(boolean bl) {
        float[] fArray = bl ? RendererCommon.verticalFlipMatrix() : RendererCommon.horizontalFlipMatrix();
        return this.applyTransformMatrix(RendererCommon.convertMatrixToAndroidGraphicsMatrix(fArray), this.width, this.height);
    }

    public VideoFrame.TextureBuffer applyTransformMatrix(Matrix matrix, int n2, int n3) {
        Matrix matrix2 = new Matrix(this.transformMatrix);
        matrix2.preConcat(matrix);
        this.transformMatrix = matrix2;
        this.width = n2;
        this.height = n3;
        return this;
    }

    public void releaseNativeBuffer() {
        this.releaseHardwareBuffer(this.mHandler);
    }

    @Override
    public int getTextureId() {
        return this.getTextureId(this.mHandler);
    }

    @Override
    public int getTextureType() {
        return this.type == VideoFrame.TextureBuffer.Type.OES ? 11 : 10;
    }

    @Override
    public boolean isValidNativeBuffer() {
        return ThreadUtils.invokeAtFrontUninterruptibly(this.toI420Handler, new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return AGraphicBufferEx.this.isValid(AGraphicBufferEx.this.mHandler);
            }
        });
    }

    public byte[] getBuffer() {
        return this.getBuffer(this.mHandler);
    }

    public void setBuffer(byte[] byArray) {
        this.setBuffer(this.mHandler, byArray);
    }

    @Override
    public long getNativeBuffer() {
        return ThreadUtils.invokeAtFrontUninterruptibly(this.toI420Handler, new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                return AGraphicBufferEx.this.mHandler;
            }
        });
    }

    @Override
    public boolean isNativeBufferSupported() {
        return Build.VERSION.SDK_INT >= 26;
    }

    @Override
    public VideoFrame.TextureBuffer toTextureBuffer() {
        return this;
    }

    @Override
    public int getSequence() {
        return 0;
    }

    @Override
    public String infoString() {
        return this.toString();
    }

    @Override
    public VideoFrame.TextureBuffer toAGraphicBufferEx() {
        return this;
    }

    public String toString() {
        return "AGraphicBufferEx{eglContext=" + this.eglContext + ", width=" + this.width + ", height=" + this.height + ", type=" + (Object)((Object)this.type) + ", id=" + this.id + ", transformMatrix=" + this.transformMatrix + ", toI420Handler=" + this.toI420Handler + ", releaseCallback=" + this.releaseCallback + ", refCountLock=" + this.refCountLock + ", refCount=" + this.refCount + ", mHandler=" + this.mHandler + '}';
    }

    private native long initHardwareBuffer(int var1, int var2, int var3);

    private native void releaseHardwareBuffer(long var1);

    private native int getTextureId(long var1);

    private native boolean isValid(long var1);

    private native byte[] getBuffer(long var1);

    private native void setBuffer(long var1, byte[] var3);
}

