/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.mediaio;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.util.AttributeSet;
import android.util.Log;
import android.view.TextureView;
import io.agora.rtc.gl.EglBase;
import io.agora.rtc.gl.RendererCommon;
import io.agora.rtc.mediaio.BaseVideoRenderer;
import io.agora.rtc.mediaio.IVideoSink;
import io.agora.rtc.mediaio.MediaIO;
import io.agora.rtc.utils.ThreadUtils;
import java.nio.ByteBuffer;

public class AgoraTextureView
extends TextureView
implements IVideoSink,
TextureView.SurfaceTextureListener {
    private static final String TAG = TextureView.class.getSimpleName();
    private BaseVideoRenderer mRender = new BaseVideoRenderer(TAG);
    private EglBase.Context mEglContext;
    private int[] mConfigAttributes;
    private RendererCommon.GlDrawer mDrawer;

    public AgoraTextureView(Context context) {
        super(context);
        this.mRender.setRenderView(this, this);
    }

    public AgoraTextureView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mRender.setRenderView(this, this);
    }

    public void init(EglBase.Context context) {
        this.mEglContext = context;
    }

    public void init(EglBase.Context context, int[] nArray, RendererCommon.GlDrawer glDrawer) {
        this.mEglContext = context;
        this.mConfigAttributes = nArray;
        this.mDrawer = glDrawer;
    }

    @Override
    public long getEGLContextHandle() {
        return this.mRender.getEGLContextHandle();
    }

    public void setBufferType(MediaIO.BufferType bufferType) {
        this.mRender.setBufferType(bufferType);
    }

    public void setPixelFormat(MediaIO.PixelFormat pixelFormat) {
        this.mRender.setPixelFormat(pixelFormat);
    }

    public void setMirror(boolean bl) {
        this.mRender.getEglRender().setMirror(bl);
    }

    @Override
    public boolean onInitialize() {
        if (this.mConfigAttributes != null && this.mDrawer != null) {
            this.mRender.init(this.mEglContext, this.mConfigAttributes, this.mDrawer);
        } else {
            this.mRender.init(this.mEglContext);
        }
        return true;
    }

    @Override
    public boolean onStart() {
        return this.mRender.start();
    }

    @Override
    public void onStop() {
        this.mRender.stop();
    }

    @Override
    public void onDispose() {
        this.mRender.release();
    }

    @Override
    public void consumeTextureFrame(int n2, int n3, int n4, int n5, int n6, long l2, float[] fArray) {
        this.mRender.consume(n2, n3, n4, n5, n6, l2, fArray);
    }

    @Override
    public void consumeByteBufferFrame(ByteBuffer byteBuffer, int n2, int n3, int n4, int n5, long l2) {
        this.mRender.consume(byteBuffer, n2, n3, n4, n5, l2);
    }

    @Override
    public void consumeByteArrayFrame(byte[] byArray, int n2, int n3, int n4, int n5, long l2) {
        this.mRender.consume(byArray, n2, n3, n4, n5, l2);
    }

    @Override
    public int getBufferType() {
        int n2 = this.mRender.getBufferType();
        if (n2 == -1) {
            throw new IllegalArgumentException("Buffer type is not set");
        }
        return n2;
    }

    @Override
    public int getPixelFormat() {
        int n2 = this.mRender.getPixelFormat();
        if (n2 == -1) {
            throw new IllegalArgumentException("Pixel format is not set");
        }
        return n2;
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n2, int n3) {
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n2, int n3) {
        Log.e((String)TAG, (String)("onSurfaceTextureSizeChanged: width- " + n2 + ", height: " + n3));
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        return true;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
    }

    protected void onLayout(boolean bl, int n2, int n3, int n4, int n5) {
        ThreadUtils.checkIsOnMainThread();
        this.mRender.getEglRender().setLayoutAspectRatio((float)(n4 - n2) / (float)(n5 - n3));
    }
}

