/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.internal;

import io.agora.rtc.internal.Logging;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;

class Marshallable {
    private static final int MAX_PROTO_PACKET_SIZE = 8192;
    private static final int MIN_PROTO_PACKET_SIZE = 512;
    private static final int BUFFER_LEN_SIZE = 2;
    private static final int BYTE_SIZE = 1;
    private static final int CHAR_SIZE = 2;
    private static final int SHORT_SIZE = 2;
    private static final int INT_SIZE = 4;
    private static final int LONG_SIZE = 8;
    private static final int FLOAT_SIZE = 4;
    private static final int DOUBLE_SIZE = 8;
    private ByteBuffer mBuffer = null;

    public Marshallable() {
    }

    public Marshallable(int n2) {
        if (n2 < 2) {
            n2 = 2;
        }
        this.mBuffer = this.allocateByteBuffer(n2);
    }

    private ByteBuffer allocateByteBuffer(int n2) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        return byteBuffer;
    }

    private boolean checkSize(int n2) {
        int n3 = 0;
        if (this.mBuffer == null) {
            n3 = 512;
            if (n3 < n2 + 2) {
                n3 = n2 + 2;
            }
            if (n3 > 8192) {
                Logging.e("Marshallable", "checkSize failed! newSize: " + n3);
                return false;
            }
            this.mBuffer = this.allocateByteBuffer(n3);
            this.mBuffer.position(2);
            return true;
        }
        int n4 = this.mBuffer.capacity();
        if (this.mBuffer.remaining() >= n2) {
            return true;
        }
        n3 = n4 * 2;
        if (n3 - this.mBuffer.position() < n2) {
            n3 = this.mBuffer.position() + n2;
        }
        if (n3 > 8192) {
            Logging.e("Marshallable", "checkSize failed! newSize: " + n3 + " size: " + n2 + " position: " + this.mBuffer.position());
            return false;
        }
        ByteBuffer byteBuffer = this.allocateByteBuffer(n3);
        System.arraycopy(this.mBuffer.array(), 0, byteBuffer.array(), 0, this.mBuffer.position());
        byteBuffer.position(this.mBuffer.position());
        this.mBuffer = byteBuffer;
        return true;
    }

    public byte[] marshall() {
        short s = 0;
        if (this.mBuffer != null) {
            s = (short)this.mBuffer.position();
        }
        this.mBuffer.position(0);
        this.pushShort(s);
        byte[] byArray = new byte[s];
        this.mBuffer.position(0);
        this.mBuffer.get(byArray);
        return byArray;
    }

    public void marshall(ByteBuffer byteBuffer) {
        this.mBuffer = byteBuffer;
    }

    public void unmarshall(byte[] byArray) {
        this.mBuffer = ByteBuffer.wrap(byArray);
        this.mBuffer.order(ByteOrder.LITTLE_ENDIAN);
        short s = this.popShort();
    }

    public void unmarshall(ByteBuffer byteBuffer) {
        this.mBuffer = byteBuffer;
    }

    public void pushBool(Boolean bl) {
        byte by = 0;
        if (bl.booleanValue()) {
            by = 1;
        }
        if (!this.checkSize(1)) {
            return;
        }
        this.mBuffer.put(by);
    }

    public Boolean popBool() {
        byte by = this.mBuffer.get();
        return by == 1;
    }

    public void pushByte(byte by) {
        if (!this.checkSize(1)) {
            return;
        }
        this.mBuffer.put(by);
    }

    public byte popByte() {
        return this.mBuffer.get();
    }

    public void pushBytes(byte[] byArray) {
        if (!this.checkSize(2 + byArray.length)) {
            return;
        }
        this.mBuffer.putShort((short)byArray.length);
        this.mBuffer.put(byArray);
    }

    public byte[] popBytes() {
        short s = this.mBuffer.getShort();
        byte[] byArray = new byte[]{};
        if (s > 0) {
            byArray = new byte[s];
            this.mBuffer.get(byArray);
        }
        return byArray;
    }

    public void pushBytes32(byte[] byArray) {
        if (!this.checkSize(4 + byArray.length)) {
            return;
        }
        this.mBuffer.putInt(byArray.length);
        this.mBuffer.put(byArray);
    }

    public byte[] popBytes32() {
        int n2 = this.mBuffer.getInt();
        byte[] byArray = null;
        if (n2 > 0) {
            byArray = new byte[n2];
            this.mBuffer.get(byArray);
        }
        return byArray;
    }

    public byte[] popAll() {
        int n2 = this.mBuffer.remaining();
        byte[] byArray = new byte[n2];
        this.mBuffer.get(byArray);
        return byArray;
    }

    public void pushShort(short s) {
        if (!this.checkSize(2)) {
            return;
        }
        this.mBuffer.putShort(s);
    }

    public short popShort() {
        return this.mBuffer.getShort();
    }

    public void pushInt(int n2) {
        if (!this.checkSize(4)) {
            return;
        }
        this.mBuffer.putInt(n2);
    }

    public void pushDouble(double d2) {
        if (!this.checkSize(8)) {
            return;
        }
        this.mBuffer.putDouble(d2);
    }

    public int popInt() {
        return this.mBuffer.getInt();
    }

    public void pushInt64(long l2) {
        if (!this.checkSize(8)) {
            return;
        }
        this.mBuffer.putLong(l2);
    }

    public long popInt64() {
        return this.mBuffer.getLong();
    }

    public void pushString16(String string) {
        if (string == null) {
            this.pushShort((short)0);
            return;
        }
        this.pushBytes(string.getBytes());
    }

    public String popString16() {
        short s = this.mBuffer.getShort();
        byte[] byArray = null;
        if (s > 0) {
            byArray = new byte[s];
            this.mBuffer.get(byArray);
            try {
                return new String(byArray, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
        }
        return "";
    }

    public String popString16UTF8() {
        short s = this.mBuffer.getShort();
        byte[] byArray = null;
        if (s > 0) {
            byArray = new byte[s];
            this.mBuffer.get(byArray);
            try {
                return new String(byArray, "utf-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
        }
        return "";
    }

    public void pushStringArray(ArrayList<String> arrayList) {
        if (arrayList == null) {
            this.pushInt(0);
            return;
        }
        int n2 = arrayList.size();
        this.pushShort((short)n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.pushBytes(arrayList.get(i2).getBytes());
        }
    }

    public void pushIntArray(int[] nArray) {
        if (nArray == null) {
            this.pushInt(0);
            return;
        }
        int n2 = nArray.length;
        this.pushInt(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.pushInt(nArray[i2]);
        }
    }

    public void pushIntArray(Integer[] integerArray) {
        if (integerArray == null) {
            this.pushInt(0);
            return;
        }
        int n2 = integerArray.length;
        this.pushInt(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.pushInt(integerArray[i2]);
        }
    }

    public int[] popIntArray() {
        int n2 = this.popInt();
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = this.popInt();
        }
        return nArray;
    }

    public void pushShortArray(short[] sArray) {
        if (sArray == null) {
            this.pushInt(0);
            return;
        }
        int n2 = sArray.length;
        this.pushInt(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.pushShort(sArray[i2]);
        }
    }

    public short[] popShortArray() {
        int n2 = this.popInt();
        short[] sArray = new short[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            sArray[i2] = this.popShort();
        }
        return sArray;
    }

    public void clear() {
        this.mBuffer.position(10);
    }
}

