/*
 * Decompiled with CFR 0.152.
 */
package io.agora.media;

import io.agora.media.AccessToken;
import java.util.TreeMap;

public class SimpleTokenBuilder {
    public AccessToken mTokenCreator;
    public static TreeMap<Short, Integer> attendeePrivileges = new TreeMap();
    public static TreeMap<Short, Integer> publisherPrivileges;
    public static TreeMap<Short, Integer> subscriberPrivileges;
    public static TreeMap<Short, Integer> adminPrivileges;
    public static TreeMap<Integer, TreeMap<Short, Integer>> gRolePrivileges;

    public SimpleTokenBuilder(String appId, String appCertificate, String channelName, String uid) {
        this.mTokenCreator = new AccessToken(appId, appCertificate, channelName, uid);
    }

    public SimpleTokenBuilder(String appId, String appCertificate, String channelName, int uid) {
        this.mTokenCreator = new AccessToken(appId, appCertificate, channelName, uid);
    }

    public boolean initTokenBuilder(String originToken) {
        this.mTokenCreator.fromString(originToken);
        return true;
    }

    public boolean initPrivileges(Role role) {
        TreeMap<Short, Integer> value = gRolePrivileges.get(role.initValue);
        if (value == null) {
            return false;
        }
        this.mTokenCreator.message.messages = value;
        return true;
    }

    public void setPrivilege(AccessToken.Privileges privilege, int expireTimestamp) {
        this.mTokenCreator.message.messages.put(privilege.intValue, expireTimestamp);
    }

    public void removePrivilege(AccessToken.Privileges privilege) {
        this.mTokenCreator.message.messages.remove(privilege.intValue);
    }

    public String buildToken() throws Exception {
        return this.mTokenCreator.build();
    }

    static {
        attendeePrivileges.put(AccessToken.Privileges.kJoinChannel.intValue, 0);
        attendeePrivileges.put(AccessToken.Privileges.kPublishAudioStream.intValue, 0);
        attendeePrivileges.put(AccessToken.Privileges.kPublishVideoStream.intValue, 0);
        attendeePrivileges.put(AccessToken.Privileges.kPublishDataStream.intValue, 0);
        publisherPrivileges = new TreeMap();
        publisherPrivileges.put(AccessToken.Privileges.kJoinChannel.intValue, 0);
        publisherPrivileges.put(AccessToken.Privileges.kPublishAudioStream.intValue, 0);
        publisherPrivileges.put(AccessToken.Privileges.kPublishVideoStream.intValue, 0);
        publisherPrivileges.put(AccessToken.Privileges.kPublishDataStream.intValue, 0);
        publisherPrivileges.put(AccessToken.Privileges.kPublishAudiocdn.intValue, 0);
        publisherPrivileges.put(AccessToken.Privileges.kPublishVideoCdn.intValue, 0);
        publisherPrivileges.put(AccessToken.Privileges.kInvitePublishAudioStream.intValue, 0);
        publisherPrivileges.put(AccessToken.Privileges.kInvitePublishVideoStream.intValue, 0);
        publisherPrivileges.put(AccessToken.Privileges.kInvitePublishDataStream.intValue, 0);
        subscriberPrivileges = new TreeMap();
        subscriberPrivileges.put(AccessToken.Privileges.kJoinChannel.intValue, 0);
        subscriberPrivileges.put(AccessToken.Privileges.kRequestPublishAudioStream.intValue, 0);
        subscriberPrivileges.put(AccessToken.Privileges.kRequestPublishVideoStream.intValue, 0);
        subscriberPrivileges.put(AccessToken.Privileges.kRequestPublishDataStream.intValue, 0);
        adminPrivileges = new TreeMap();
        adminPrivileges.put(AccessToken.Privileges.kJoinChannel.intValue, 0);
        adminPrivileges.put(AccessToken.Privileges.kPublishAudioStream.intValue, 0);
        adminPrivileges.put(AccessToken.Privileges.kPublishVideoStream.intValue, 0);
        adminPrivileges.put(AccessToken.Privileges.kPublishDataStream.intValue, 0);
        adminPrivileges.put(AccessToken.Privileges.kAdministrateChannel.intValue, 0);
        gRolePrivileges = new TreeMap();
        gRolePrivileges.put(Role.Role_Attendee.initValue, attendeePrivileges);
        gRolePrivileges.put(Role.Role_Publisher.initValue, publisherPrivileges);
        gRolePrivileges.put(Role.Role_Subscriber.initValue, subscriberPrivileges);
        gRolePrivileges.put(Role.Role_Admin.initValue, adminPrivileges);
    }

    public static enum Role {
        Role_Attendee(0),
        Role_Publisher(1),
        Role_Subscriber(2),
        Role_Admin(101);

        public int initValue;

        private Role(int initValue) {
            this.initValue = initValue;
        }
    }
}

