/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.uri;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;

public class UriUtil {
    public static <M extends Map<String, String>> M parseQueryString(URI uri, M queryParams) throws URISyntaxException {
        String query = uri.getQuery();
        if (null != query) {
            for (String pair : query.split("&")) {
                String[] componentParts = pair.split("=");
                if (componentParts.length == 2) {
                    queryParams.put((String)componentParts[0], (String)componentParts[1]);
                    continue;
                }
                if (componentParts.length == 1) {
                    queryParams.put((String)componentParts[0], (String)"");
                    continue;
                }
                throw new URISyntaxException(pair, "Did not contain 1 or 2 parts");
            }
        }
        return queryParams;
    }
}

