/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.uri;

import java.net.InetSocketAddress;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.agrona.Strings;

public class SocketAddressUtil {
    private static final Pattern IPV4_ADDRESS_PATTERN = Pattern.compile("([^:]+)(?::([0-9]+))?");
    private static final Pattern IPV6_ADDRESS_PATTERN = Pattern.compile("\\[([0-9A-Fa-f:]+)(?:%[a-zA-Z0-9_.~-]+)?\\](?::([0-9]+))?");

    private static InetSocketAddress parse(CharSequence cs, BiFunction<String, String, InetSocketAddress> consumer) {
        if (null == cs) {
            throw new NullPointerException("Input string must not be null");
        }
        Matcher ipV4Matcher = IPV4_ADDRESS_PATTERN.matcher(cs);
        if (ipV4Matcher.matches()) {
            String host = ipV4Matcher.group(1);
            String portString = ipV4Matcher.group(2);
            return consumer.apply(host, portString);
        }
        Matcher ipV6Matcher = IPV6_ADDRESS_PATTERN.matcher(cs);
        if (ipV6Matcher.matches()) {
            String host = ipV6Matcher.group(1);
            String portString = ipV6Matcher.group(2);
            return consumer.apply(host, portString);
        }
        throw new IllegalArgumentException("Invalid format: " + cs);
    }

    public static InetSocketAddress parse(CharSequence cs) {
        return SocketAddressUtil.parse(cs, (hostString, portString) -> {
            if (null == portString) {
                throw new IllegalArgumentException("The 'port' portion of the address is required");
            }
            return new InetSocketAddress((String)hostString, Integer.parseInt(portString));
        });
    }

    public static InetSocketAddress parse(CharSequence cs, int defaultPort) {
        return SocketAddressUtil.parse(cs, (hostString, portString) -> {
            int port = Strings.parseIntOrDefault((String)portString, (int)defaultPort);
            return new InetSocketAddress((String)hostString, port);
        });
    }
}

