/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.AeronClient;
import io.aeron.driver.DriverConductor;
import io.aeron.driver.DriverManagedResource;
import io.aeron.driver.NetworkPublication;
import io.aeron.driver.media.ReceiveChannelEndpoint;
import org.agrona.concurrent.status.ReadablePosition;

public abstract class SubscriptionLink
implements DriverManagedResource {
    protected final long registrationId;
    protected final long clientLivenessTimeoutNs;
    protected final int streamId;
    protected final String uri;
    protected final AeronClient aeronClient;
    protected boolean reachedEndOfLife = false;

    protected SubscriptionLink(long registrationId, int streamId, String channelUri, AeronClient aeronClient, long clientLivenessTimeoutNs) {
        this.registrationId = registrationId;
        this.streamId = streamId;
        this.uri = channelUri;
        this.aeronClient = aeronClient;
        this.clientLivenessTimeoutNs = clientLivenessTimeoutNs;
    }

    public long registrationId() {
        return this.registrationId;
    }

    public int streamId() {
        return this.streamId;
    }

    public String uri() {
        return this.uri;
    }

    public ReceiveChannelEndpoint channelEndpoint() {
        return null;
    }

    public boolean isReliable() {
        return true;
    }

    public boolean matches(NetworkPublication publication) {
        return false;
    }

    public boolean matches(ReceiveChannelEndpoint channelEndpoint, int streamId) {
        return false;
    }

    public boolean matches(int streamId) {
        return false;
    }

    public abstract void link(Object var1, ReadablePosition var2);

    public abstract void unlink(Object var1);

    public abstract void close();

    @Override
    public void onTimeEvent(long timeNs, DriverConductor conductor) {
        if (timeNs > this.aeronClient.timeOfLastKeepalive() + this.clientLivenessTimeoutNs) {
            this.reachedEndOfLife = true;
            conductor.cleanupSubscriptionLink(this);
        }
    }

    @Override
    public boolean hasReachedEndOfLife() {
        return this.reachedEndOfLife;
    }

    public void timeOfLastStateChange(long time) {
    }

    public long timeOfLastStateChange() {
        return this.aeronClient.timeOfLastKeepalive();
    }

    public void delete() {
        this.close();
    }
}

