/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.ArrayListUtil;
import io.aeron.driver.Configuration;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.PendingSetupMessageFromSource;
import io.aeron.driver.PublicationImage;
import io.aeron.driver.cmd.ReceiverCmd;
import io.aeron.driver.media.DataTransportPoller;
import io.aeron.driver.media.ReceiveChannelEndpoint;
import io.aeron.driver.status.SystemCounterDescriptor;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.NanoClock;
import org.agrona.concurrent.OneToOneConcurrentArrayQueue;
import org.agrona.concurrent.status.AtomicCounter;

public class Receiver
implements Agent,
Consumer<ReceiverCmd> {
    private final DataTransportPoller dataTransportPoller;
    private final OneToOneConcurrentArrayQueue<ReceiverCmd> commandQueue;
    private final AtomicCounter totalBytesReceived;
    private final NanoClock clock;
    private final ArrayList<PublicationImage> publicationImages = new ArrayList();
    private final ArrayList<PendingSetupMessageFromSource> pendingSetupMessages = new ArrayList();

    public Receiver(MediaDriver.Context ctx) {
        this.dataTransportPoller = ctx.dataTransportPoller();
        this.commandQueue = ctx.receiverCommandQueue();
        this.totalBytesReceived = ctx.systemCounters().get(SystemCounterDescriptor.BYTES_RECEIVED);
        this.clock = ctx.nanoClock();
    }

    public String roleName() {
        return "receiver";
    }

    public int doWork() throws Exception {
        int lastIndex;
        int workCount = this.commandQueue.drain((Consumer)this);
        int bytesReceived = this.dataTransportPoller.pollTransports();
        long now = this.clock.nanoTime();
        ArrayList<PublicationImage> publicationImages = this.publicationImages;
        for (int i = lastIndex = publicationImages.size() - 1; i >= 0; --i) {
            PublicationImage image = publicationImages.get(i);
            if (!image.checkForActivity(now)) {
                image.removeFromDispatcher();
                ArrayListUtil.fastUnorderedRemove(publicationImages, (int)i, (int)lastIndex);
                --lastIndex;
                continue;
            }
            workCount += image.sendPendingStatusMessage();
            workCount += image.processPendingLoss();
            workCount += image.initiateAnyRttMeasurements(now);
        }
        this.checkPendingSetupMessages(now);
        this.totalBytesReceived.addOrdered((long)bytesReceived);
        return workCount + bytesReceived;
    }

    public void addPendingSetupMessage(int sessionId, int streamId, ReceiveChannelEndpoint channelEndpoint, boolean periodic, InetSocketAddress controlAddress) {
        PendingSetupMessageFromSource cmd = new PendingSetupMessageFromSource(sessionId, streamId, channelEndpoint, periodic, controlAddress);
        cmd.timeOfStatusMessage(this.clock.nanoTime());
        this.pendingSetupMessages.add(cmd);
    }

    public void onAddSubscription(ReceiveChannelEndpoint channelEndpoint, int streamId) {
        channelEndpoint.addSubscription(streamId);
    }

    public void onRemoveSubscription(ReceiveChannelEndpoint channelEndpoint, int streamId) {
        channelEndpoint.removeSubscription(streamId);
    }

    public void onNewPublicationImage(ReceiveChannelEndpoint channelEndpoint, PublicationImage image) {
        this.publicationImages.add(image);
        channelEndpoint.addPublicationImage(image);
    }

    public void onRegisterReceiveChannelEndpoint(ReceiveChannelEndpoint channelEndpoint) {
        channelEndpoint.openChannel();
        channelEndpoint.registerForRead(this.dataTransportPoller);
        channelEndpoint.indicateActive();
        if (channelEndpoint.hasExplicitControl()) {
            this.addPendingSetupMessage(0, 0, channelEndpoint, true, channelEndpoint.explicitControlAddress());
            channelEndpoint.sendSetupElicitingStatusMessage(channelEndpoint.explicitControlAddress(), 0, 0);
        }
    }

    public void onCloseReceiveChannelEndpoint(ReceiveChannelEndpoint channelEndpoint) {
        channelEndpoint.close();
    }

    public void onRemoveCoolDown(ReceiveChannelEndpoint channelEndpoint, int sessionId, int streamId) {
        channelEndpoint.removeCoolDown(sessionId, streamId);
    }

    @Override
    public void accept(ReceiverCmd cmd) {
        cmd.execute(this);
    }

    private void checkPendingSetupMessages(long now) {
        int lastIndex;
        ArrayList<PendingSetupMessageFromSource> pendingSetupMessages = this.pendingSetupMessages;
        for (int i = lastIndex = pendingSetupMessages.size() - 1; i >= 0; --i) {
            PendingSetupMessageFromSource pending = pendingSetupMessages.get(i);
            if (now <= pending.timeOfStatusMessage() + Configuration.PENDING_SETUPS_TIMEOUT_NS) continue;
            if (!pending.isPeriodic()) {
                ArrayListUtil.fastUnorderedRemove(pendingSetupMessages, (int)i, (int)lastIndex);
                --lastIndex;
                pending.removeFromDataPacketDispatcher();
                continue;
            }
            if (!pending.shouldElicitSetupMessage()) continue;
            pending.channelEndpoint().sendSetupElicitingStatusMessage(pending.controlAddress(), pending.sessionId(), pending.streamId());
            pending.timeOfStatusMessage(now);
        }
    }
}

