/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.AeronClient;
import io.aeron.driver.PublicationImage;
import io.aeron.driver.SubscriptionLink;
import io.aeron.driver.media.ReceiveChannelEndpoint;
import java.util.IdentityHashMap;
import java.util.Map;
import org.agrona.concurrent.status.ReadablePosition;

class NetworkSubscriptionLink
extends SubscriptionLink {
    private final boolean isReliable;
    private final ReceiveChannelEndpoint channelEndpoint;
    private final Map<PublicationImage, ReadablePosition> positionByImageMap = new IdentityHashMap<PublicationImage, ReadablePosition>();

    NetworkSubscriptionLink(long registrationId, ReceiveChannelEndpoint channelEndpoint, int streamId, String channelUri, AeronClient aeronClient, long clientLivenessTimeoutNs, boolean isReliable) {
        super(registrationId, streamId, channelUri, aeronClient, clientLivenessTimeoutNs);
        this.isReliable = isReliable;
        this.channelEndpoint = channelEndpoint;
    }

    @Override
    public boolean isReliable() {
        return this.isReliable;
    }

    @Override
    public ReceiveChannelEndpoint channelEndpoint() {
        return this.channelEndpoint;
    }

    @Override
    public boolean matches(ReceiveChannelEndpoint channelEndpoint, int streamId) {
        return channelEndpoint == this.channelEndpoint && streamId == this.streamId;
    }

    @Override
    public void link(Object source, ReadablePosition position) {
        this.positionByImageMap.put((PublicationImage)source, position);
    }

    @Override
    public void unlink(Object source) {
        this.positionByImageMap.remove(source);
    }

    @Override
    public void close() {
        this.positionByImageMap.forEach(PublicationImage::removeSubscriber);
    }
}

