/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.Configuration;
import io.aeron.driver.DriverConductor;
import io.aeron.driver.DriverManagedResource;
import io.aeron.driver.buffer.RawLog;
import io.aeron.driver.status.SystemCounterDescriptor;
import io.aeron.driver.status.SystemCounters;
import io.aeron.logbuffer.LogBufferDescriptor;
import io.aeron.logbuffer.LogBufferUnblocker;
import org.agrona.collections.ArrayUtil;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.Position;
import org.agrona.concurrent.status.ReadablePosition;

public class IpcPublication
implements DriverManagedResource {
    private static final ReadablePosition[] EMPTY_POSITIONS = new ReadablePosition[0];
    private final long correlationId;
    private final long tripGain;
    private final int sessionId;
    private final int streamId;
    private final int termWindowLength;
    private final int positionBitsToShift;
    private final int initialTermId;
    private final long unblockTimeoutNs;
    private long tripLimit = 0L;
    private long consumerPosition = 0L;
    private long lastConsumerPosition = 0L;
    private long timeOfLastConsumerPositionChange = 0L;
    private long cleanPosition = 0L;
    private long timeOfLastStatusChange = 0L;
    private int refCount = 0;
    private boolean reachedEndOfLife = false;
    private Status status = Status.ACTIVE;
    private final UnsafeBuffer[] termBuffers;
    private ReadablePosition[] subscriberPositions = EMPTY_POSITIONS;
    private final RawLog rawLog;
    private final Position publisherLimit;
    private final AtomicCounter unblockedPublications;

    public IpcPublication(long correlationId, int sessionId, int streamId, Position publisherLimit, RawLog rawLog, long unblockTimeoutNs, SystemCounters systemCounters) {
        this.correlationId = correlationId;
        this.sessionId = sessionId;
        this.streamId = streamId;
        this.termBuffers = rawLog.termBuffers();
        this.initialTermId = LogBufferDescriptor.initialTermId((UnsafeBuffer)rawLog.metaData());
        int termLength = rawLog.termLength();
        this.positionBitsToShift = Integer.numberOfTrailingZeros(termLength);
        this.termWindowLength = Configuration.ipcPublicationTermWindowLength(termLength);
        this.tripGain = this.termWindowLength / 8;
        this.publisherLimit = publisherLimit;
        this.rawLog = rawLog;
        this.unblockTimeoutNs = unblockTimeoutNs;
        this.unblockedPublications = systemCounters.get(SystemCounterDescriptor.UNBLOCKED_PUBLICATIONS);
    }

    public int sessionId() {
        return this.sessionId;
    }

    public int streamId() {
        return this.streamId;
    }

    public long correlationId() {
        return this.correlationId;
    }

    public RawLog rawLog() {
        return this.rawLog;
    }

    public int publisherLimitId() {
        return this.publisherLimit.id();
    }

    public void close() {
        this.publisherLimit.close();
        for (ReadablePosition position : this.subscriberPositions) {
            position.close();
        }
        this.rawLog.close();
    }

    public void addSubscription(ReadablePosition subscriberPosition) {
        this.subscriberPositions = (ReadablePosition[])ArrayUtil.add((Object[])this.subscriberPositions, (Object)subscriberPosition);
    }

    public void removeSubscription(ReadablePosition subscriberPosition) {
        this.subscriberPositions = (ReadablePosition[])ArrayUtil.remove((Object[])this.subscriberPositions, (Object)subscriberPosition);
        subscriberPosition.close();
    }

    int updatePublishersLimit(long nowInMillis) {
        int workCount = 0;
        long minSubscriberPosition = Long.MAX_VALUE;
        long maxSubscriberPosition = 0L;
        for (ReadablePosition subscriberPosition : this.subscriberPositions) {
            long position = subscriberPosition.getVolatile();
            minSubscriberPosition = Math.min(minSubscriberPosition, position);
            maxSubscriberPosition = Math.max(maxSubscriberPosition, position);
        }
        if (0 != this.subscriberPositions.length) {
            long proposedLimit = minSubscriberPosition + (long)this.termWindowLength;
            if (proposedLimit > this.tripLimit) {
                LogBufferDescriptor.timeOfLastStatusMessage((UnsafeBuffer)this.rawLog.metaData(), (long)nowInMillis);
                this.publisherLimit.setOrdered(proposedLimit);
                this.tripLimit = proposedLimit + this.tripGain;
                this.cleanBuffer(minSubscriberPosition);
                workCount = 1;
            }
            this.consumerPosition = maxSubscriberPosition;
        }
        return workCount;
    }

    private void cleanBuffer(long minConsumerPosition) {
        int termOffset;
        long cleanPosition = this.cleanPosition;
        int bytesForCleaning = (int)(minConsumerPosition - cleanPosition);
        UnsafeBuffer dirtyTerm = this.termBuffers[LogBufferDescriptor.indexByPosition((long)cleanPosition, (int)this.positionBitsToShift)];
        int bufferCapacity = dirtyTerm.capacity();
        int length = Math.min(bytesForCleaning, bufferCapacity - (termOffset = (int)cleanPosition & bufferCapacity - 1));
        if (length > 0) {
            dirtyTerm.setMemory(termOffset, length, (byte)0);
            this.cleanPosition = cleanPosition + (long)length;
        }
    }

    public long joiningPosition() {
        long maxSubscriberPosition = this.producerPosition();
        for (ReadablePosition subscriberPosition : this.subscriberPositions) {
            maxSubscriberPosition = Math.max(maxSubscriberPosition, subscriberPosition.getVolatile());
        }
        return maxSubscriberPosition;
    }

    @Override
    public long producerPosition() {
        long rawTail = LogBufferDescriptor.rawTailVolatile((UnsafeBuffer)this.rawLog.metaData());
        int termOffset = LogBufferDescriptor.termOffset((long)rawTail, (long)this.rawLog.termLength());
        return LogBufferDescriptor.computePosition((int)LogBufferDescriptor.termId((long)rawTail), (int)termOffset, (int)this.positionBitsToShift, (int)this.initialTermId);
    }

    @Override
    public void onTimeEvent(long timeNs, DriverConductor conductor) {
        switch (this.status) {
            case ACTIVE: {
                if (0 != this.refCount) break;
                this.status(Status.INACTIVE, timeNs);
                break;
            }
            case INACTIVE: {
                if (!this.isDrained()) break;
                this.status(Status.LINGER, timeNs);
                conductor.transitionToLinger(this);
                break;
            }
            case LINGER: {
                if (timeNs <= this.timeOfLastStatusChange + Configuration.PUBLICATION_LINGER_NS) break;
                this.reachedEndOfLife = true;
                conductor.cleanupIpcPublication(this);
            }
        }
        if (this.consumerPosition == this.lastConsumerPosition) {
            if (this.producerPosition() > this.consumerPosition && timeNs > this.timeOfLastConsumerPositionChange + this.unblockTimeoutNs && this.unblockAtConsumerPosition()) {
                this.unblockedPublications.orderedIncrement();
            }
        } else {
            this.timeOfLastConsumerPositionChange = timeNs;
            this.lastConsumerPosition = this.consumerPosition;
        }
    }

    @Override
    public boolean hasReachedEndOfLife() {
        return this.reachedEndOfLife;
    }

    public void timeOfLastStateChange(long time) {
        this.timeOfLastStatusChange = time;
    }

    public long timeOfLastStateChange() {
        return this.timeOfLastStatusChange;
    }

    public void delete() {
        this.close();
    }

    @Override
    public int incRef() {
        return ++this.refCount;
    }

    @Override
    public int decRef() {
        return --this.refCount;
    }

    @Override
    public long consumerPosition() {
        return this.consumerPosition;
    }

    @Override
    public boolean unblockAtConsumerPosition() {
        return LogBufferUnblocker.unblock((UnsafeBuffer[])this.termBuffers, (UnsafeBuffer)this.rawLog.metaData(), (long)this.consumerPosition);
    }

    Status status() {
        return this.status;
    }

    private boolean isDrained() {
        long minSubscriberPosition = Long.MAX_VALUE;
        for (ReadablePosition subscriberPosition : this.subscriberPositions) {
            minSubscriberPosition = Math.min(minSubscriberPosition, subscriberPosition.getVolatile());
        }
        return minSubscriberPosition >= this.producerPosition();
    }

    private void status(Status status, long time) {
        this.timeOfLastStatusChange = time;
        this.status = status;
    }

    static enum Status {
        ACTIVE,
        INACTIVE,
        LINGER;

    }
}

