/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.ErrorCode;
import io.aeron.command.CorrelatedMessageFlyweight;
import io.aeron.command.DestinationMessageFlyweight;
import io.aeron.command.PublicationMessageFlyweight;
import io.aeron.command.RemoveMessageFlyweight;
import io.aeron.command.SubscriptionMessageFlyweight;
import io.aeron.driver.ClientProxy;
import io.aeron.driver.DriverConductor;
import io.aeron.driver.exceptions.ControlProtocolException;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.MessageHandler;
import org.agrona.concurrent.errors.DistinctErrorLog;
import org.agrona.concurrent.ringbuffer.RingBuffer;
import org.agrona.concurrent.status.AtomicCounter;

class ClientListenerAdapter
implements MessageHandler {
    private final PublicationMessageFlyweight publicationMsgFlyweight = new PublicationMessageFlyweight();
    private final SubscriptionMessageFlyweight subscriptionMsgFlyweight = new SubscriptionMessageFlyweight();
    private final CorrelatedMessageFlyweight correlatedMsgFlyweight = new CorrelatedMessageFlyweight();
    private final RemoveMessageFlyweight removeMsgFlyweight = new RemoveMessageFlyweight();
    private final DestinationMessageFlyweight destinationMsgFlyweight = new DestinationMessageFlyweight();
    private final DriverConductor conductor;
    private final RingBuffer toDriverCommands;
    private final ClientProxy clientProxy;
    private final AtomicCounter errors;
    private final DistinctErrorLog errorLog;

    ClientListenerAdapter(AtomicCounter errors, DistinctErrorLog errorLog, RingBuffer toDriverCommands, ClientProxy clientProxy, DriverConductor driverConductor) {
        this.errors = errors;
        this.errorLog = errorLog;
        this.toDriverCommands = toDriverCommands;
        this.clientProxy = clientProxy;
        this.conductor = driverConductor;
    }

    public int receive() {
        return this.toDriverCommands.read((MessageHandler)this);
    }

    public void onMessage(int msgTypeId, MutableDirectBuffer buffer, int index, int length) {
        long correlationId = 0L;
        try {
            switch (msgTypeId) {
                case 1: {
                    PublicationMessageFlyweight publicationMessageFlyweight = this.publicationMsgFlyweight;
                    publicationMessageFlyweight.wrap(buffer, index);
                    correlationId = publicationMessageFlyweight.correlationId();
                    int streamId = publicationMessageFlyweight.streamId();
                    long clientId = publicationMessageFlyweight.clientId();
                    String channel = publicationMessageFlyweight.channel();
                    if (channel.startsWith("aeron:ipc")) {
                        this.conductor.onAddIpcPublication(channel, streamId, correlationId, clientId);
                        break;
                    }
                    this.conductor.onAddNetworkPublication(channel, streamId, correlationId, clientId);
                    break;
                }
                case 2: {
                    RemoveMessageFlyweight removeMessageFlyweight = this.removeMsgFlyweight;
                    removeMessageFlyweight.wrap(buffer, index);
                    correlationId = removeMessageFlyweight.correlationId();
                    this.conductor.onRemovePublication(removeMessageFlyweight.registrationId(), correlationId);
                    break;
                }
                case 4: {
                    SubscriptionMessageFlyweight subscriptionMessageFlyweight = this.subscriptionMsgFlyweight;
                    subscriptionMessageFlyweight.wrap(buffer, index);
                    correlationId = subscriptionMessageFlyweight.correlationId();
                    int streamId = subscriptionMessageFlyweight.streamId();
                    long clientId = subscriptionMessageFlyweight.clientId();
                    String channel = subscriptionMessageFlyweight.channel();
                    if (channel.startsWith("aeron:ipc")) {
                        this.conductor.onAddIpcSubscription(channel, streamId, correlationId, clientId);
                        break;
                    }
                    if (channel.startsWith("aeron-spy:")) {
                        this.conductor.onAddSpySubscription(channel.substring("aeron-spy:".length()), streamId, correlationId, clientId);
                        break;
                    }
                    this.conductor.onAddNetworkSubscription(channel, streamId, correlationId, clientId);
                    break;
                }
                case 5: {
                    RemoveMessageFlyweight removeMessageFlyweight = this.removeMsgFlyweight;
                    removeMessageFlyweight.wrap(buffer, index);
                    correlationId = removeMessageFlyweight.correlationId();
                    this.conductor.onRemoveSubscription(removeMessageFlyweight.registrationId(), correlationId);
                    break;
                }
                case 7: {
                    DestinationMessageFlyweight addDestinationMsgFlyweight = this.destinationMsgFlyweight;
                    addDestinationMsgFlyweight.wrap(buffer, index);
                    correlationId = addDestinationMsgFlyweight.correlationId();
                    long channelRegistrationId = addDestinationMsgFlyweight.registrationCorrelationId();
                    String channel = addDestinationMsgFlyweight.channel();
                    this.conductor.onAddDestination(channelRegistrationId, channel, correlationId);
                    break;
                }
                case 8: {
                    DestinationMessageFlyweight addDestinationMsgFlyweight = this.destinationMsgFlyweight;
                    addDestinationMsgFlyweight.wrap(buffer, index);
                    correlationId = addDestinationMsgFlyweight.correlationId();
                    long channelRegistrationId = addDestinationMsgFlyweight.registrationCorrelationId();
                    String channel = addDestinationMsgFlyweight.channel();
                    this.conductor.onRemoveDestination(channelRegistrationId, channel, correlationId);
                    break;
                }
                case 6: {
                    CorrelatedMessageFlyweight correlatedMessageFlyweight = this.correlatedMsgFlyweight;
                    correlatedMessageFlyweight.wrap(buffer, index);
                    this.conductor.onClientKeepalive(correlatedMessageFlyweight.clientId());
                    break;
                }
            }
        }
        catch (ControlProtocolException ex) {
            this.clientProxy.onError(ex.errorCode(), ex.getMessage(), correlationId);
            this.recordError(ex);
        }
        catch (Exception ex) {
            this.clientProxy.onError(ErrorCode.GENERIC_ERROR, ex.getMessage(), correlationId);
            this.recordError(ex);
        }
    }

    private void recordError(Exception ex) {
        this.errors.increment();
        this.errorLog.record((Throwable)ex);
    }
}

