/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.logbuffer;

import io.aeron.logbuffer.FrameDescriptor;
import org.agrona.BitUtil;
import org.agrona.concurrent.UnsafeBuffer;

public class TermGapScanner {
    private static final int ALIGNED_HEADER_LENGTH = BitUtil.align((int)32, (int)32);

    public static int scanForGap(UnsafeBuffer termBuffer, int termId, int rebuildOffset, int hwmOffset, GapHandler handler) {
        int frameLength;
        while ((frameLength = FrameDescriptor.frameLengthVolatile(termBuffer, rebuildOffset)) > 0 && (rebuildOffset += BitUtil.align((int)frameLength, (int)32)) < hwmOffset) {
        }
        int gapBeginOffset = rebuildOffset;
        if (rebuildOffset < hwmOffset) {
            int limit = hwmOffset - ALIGNED_HEADER_LENGTH;
            while (rebuildOffset < limit) {
                if (0 == termBuffer.getIntVolatile(rebuildOffset += 32)) continue;
                rebuildOffset -= ALIGNED_HEADER_LENGTH;
                break;
            }
            int gapLength = rebuildOffset - gapBeginOffset + ALIGNED_HEADER_LENGTH;
            handler.onGap(termId, termBuffer, gapBeginOffset, gapLength);
        }
        return gapBeginOffset;
    }

    @FunctionalInterface
    public static interface GapHandler {
        public void onGap(int var1, UnsafeBuffer var2, int var3, int var4);
    }
}

