/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.CncFileDescriptor;
import java.io.File;
import java.io.PrintStream;
import java.nio.MappedByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.IoUtil;
import org.agrona.LangUtil;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.errors.ErrorLogReader;
import org.agrona.concurrent.ringbuffer.ManyToOneRingBuffer;

public class CommonContext
implements AutoCloseable {
    public static final String AERON_DIR_PROP_NAME = "aeron.dir";
    public static final String AERON_DIR_PROP_DEFAULT;
    public static final String IPC_CHANNEL = "aeron:ipc";
    public static final String SPY_PREFIX = "aeron-spy:";
    public static final long DEFAULT_DRIVER_TIMEOUT_MS = 10000L;
    public static final String TERM_LENGTH_PARAM_NAME = "term-length";
    private long driverTimeoutMs = 10000L;
    private String aeronDirectoryName = System.getProperty("aeron.dir", AERON_DIR_PROP_DEFAULT);
    private File cncFile;
    private UnsafeBuffer countersMetaDataBuffer;
    private UnsafeBuffer countersValuesBuffer;

    public static String generateRandomDirName() {
        String randomDirName = UUID.randomUUID().toString();
        return AERON_DIR_PROP_DEFAULT + "-" + randomDirName;
    }

    public CommonContext conclude() {
        this.cncFile = new File(this.aeronDirectoryName, "cnc.dat");
        return this;
    }

    public String aeronDirectoryName() {
        return this.aeronDirectoryName;
    }

    public CommonContext aeronDirectoryName(String dirName) {
        this.aeronDirectoryName = dirName;
        return this;
    }

    public static File newDefaultCncFile() {
        return new File(System.getProperty(AERON_DIR_PROP_NAME, AERON_DIR_PROP_DEFAULT), "cnc.dat");
    }

    public UnsafeBuffer countersMetaDataBuffer() {
        return this.countersMetaDataBuffer;
    }

    public CommonContext countersMetaDataBuffer(UnsafeBuffer countersMetaDataBuffer) {
        this.countersMetaDataBuffer = countersMetaDataBuffer;
        return this;
    }

    public UnsafeBuffer countersValuesBuffer() {
        return this.countersValuesBuffer;
    }

    public CommonContext countersValuesBuffer(UnsafeBuffer countersValuesBuffer) {
        this.countersValuesBuffer = countersValuesBuffer;
        return this;
    }

    public File cncFile() {
        return this.cncFile;
    }

    public CommonContext driverTimeoutMs(long driverTimeoutMs) {
        this.driverTimeoutMs = driverTimeoutMs;
        return this;
    }

    public long driverTimeoutMs() {
        return this.driverTimeoutMs;
    }

    public void deleteAeronDirectory() {
        File dirFile = new File(this.aeronDirectoryName);
        IoUtil.delete((File)dirFile, (boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDriverActive(long driverTimeoutMs, Consumer<String> logHandler) {
        File dirFile = new File(this.aeronDirectoryName);
        if (dirFile.exists() && dirFile.isDirectory()) {
            File cncFile = new File(this.aeronDirectoryName, "cnc.dat");
            logHandler.accept(String.format("INFO: Aeron directory %s exists", dirFile));
            if (cncFile.exists()) {
                MappedByteBuffer cncByteBuffer = null;
                logHandler.accept(String.format("INFO: Aeron CnC file %s exists", cncFile));
                try {
                    cncByteBuffer = IoUtil.mapExistingFile((File)cncFile, (String)"cnc.dat");
                    UnsafeBuffer cncMetaDataBuffer = CncFileDescriptor.createMetaDataBuffer(cncByteBuffer);
                    int cncVersion = cncMetaDataBuffer.getInt(CncFileDescriptor.cncVersionOffset(0));
                    if (5 != cncVersion) {
                        throw new IllegalStateException("aeron cnc file version not understood: version=" + cncVersion);
                    }
                    ManyToOneRingBuffer toDriverBuffer = new ManyToOneRingBuffer((AtomicBuffer)CncFileDescriptor.createToDriverBuffer(cncByteBuffer, (DirectBuffer)cncMetaDataBuffer));
                    long timestamp = toDriverBuffer.consumerHeartbeatTime();
                    long now = System.currentTimeMillis();
                    long diff = now - timestamp;
                    logHandler.accept(String.format("INFO: Aeron toDriver consumer heartbeat is %d ms old", diff));
                    if (diff <= driverTimeoutMs) {
                        boolean bl = true;
                        return bl;
                    }
                }
                catch (Exception ex) {
                    LangUtil.rethrowUnchecked((Throwable)ex);
                }
                finally {
                    IoUtil.unmap((MappedByteBuffer)cncByteBuffer);
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int saveErrorLog(PrintStream stream) {
        File cncFile;
        File dirFile = new File(this.aeronDirectoryName);
        int result = 0;
        if (dirFile.exists() && dirFile.isDirectory() && (cncFile = new File(this.aeronDirectoryName, "cnc.dat")).exists()) {
            MappedByteBuffer cncByteBuffer = null;
            try {
                cncByteBuffer = IoUtil.mapExistingFile((File)cncFile, (String)"cnc.dat");
                UnsafeBuffer cncMetaDataBuffer = CncFileDescriptor.createMetaDataBuffer(cncByteBuffer);
                int cncVersion = cncMetaDataBuffer.getInt(CncFileDescriptor.cncVersionOffset(0));
                if (5 != cncVersion) {
                    throw new IllegalStateException("aeron cnc file version not understood: version=" + cncVersion);
                }
                UnsafeBuffer buffer = CncFileDescriptor.createErrorLogBuffer(cncByteBuffer, (DirectBuffer)cncMetaDataBuffer);
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ");
                int distinctErrorCount = ErrorLogReader.read((AtomicBuffer)buffer, (observationCount, firstObservationTimestamp, lastObservationTimestamp, encodedException) -> stream.format("***%n%d observations from %s to %s for:%n %s%n", observationCount, dateFormat.format(new Date(firstObservationTimestamp)), dateFormat.format(new Date(lastObservationTimestamp)), encodedException));
                stream.format("%n%d distinct errors observed.%n", distinctErrorCount);
                result = distinctErrorCount;
            }
            catch (Exception ex) {
                LangUtil.rethrowUnchecked((Throwable)ex);
            }
            finally {
                IoUtil.unmap((MappedByteBuffer)cncByteBuffer);
            }
        }
        return result;
    }

    @Override
    public void close() {
    }

    static {
        File devShmDir;
        String baseDirName = IoUtil.tmpDirName() + "aeron";
        if ("Linux".equalsIgnoreCase(System.getProperty("os.name")) && (devShmDir = new File("/dev/shm")).exists()) {
            baseDirName = "/dev/shm/aeron";
        }
        AERON_DIR_PROP_DEFAULT = baseDirName + "-" + System.getProperty("user.name", "default");
    }
}

