/*
 * Decompiled with CFR 0.152.
 */
package io.adamantic.quicknote.types;

import io.adamantic.quicknote.exceptions.TimeToLiveExpired;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;

public class Message {
    public static final String DEFAULT_ROUTING = "";
    public static final String DEFAULT_CONTENT_TYPE = "text/plain";
    public static final Map<String, String> DEFAULT_HEADERS = Collections.emptyMap();
    public static final byte[] DEFAULT_PAYLOAD = new byte[0];
    public static final int DEFAULT_TTL = 16;
    private static IDGenerator idGenerator = new IDGenerator();
    private long id = Message.nextId();
    private String contentType = "text/plain";
    private byte[] payload = DEFAULT_PAYLOAD;
    private Map<String, String> headers = DEFAULT_HEADERS;
    private String routing = "";
    private int ttl = 16;

    public Message(long id) {
        this.id = id;
    }

    public int touchTtl() {
        if (--this.ttl <= 0) {
            throw new TimeToLiveExpired(this);
        }
        return this.ttl;
    }

    public static long nextId() {
        return idGenerator.nextId();
    }

    public long id() {
        return this.id;
    }

    public String contentType() {
        return this.contentType;
    }

    public byte[] payload() {
        return this.payload;
    }

    public Map<String, String> headers() {
        return this.headers;
    }

    public String routing() {
        return this.routing;
    }

    public int ttl() {
        return this.ttl;
    }

    public Message id(long id) {
        this.id = id;
        return this;
    }

    public Message contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public Message payload(byte[] payload) {
        this.payload = payload;
        return this;
    }

    public Message headers(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public Message routing(String routing) {
        this.routing = routing;
        return this;
    }

    public Message ttl(int ttl) {
        this.ttl = ttl;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Message)) {
            return false;
        }
        Message other = (Message)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.id() != other.id()) {
            return false;
        }
        if (this.ttl() != other.ttl()) {
            return false;
        }
        String this$contentType = this.contentType();
        String other$contentType = other.contentType();
        if (this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType)) {
            return false;
        }
        if (!Arrays.equals(this.payload(), other.payload())) {
            return false;
        }
        Map<String, String> this$headers = this.headers();
        Map<String, String> other$headers = other.headers();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        String this$routing = this.routing();
        String other$routing = other.routing();
        return !(this$routing == null ? other$routing != null : !this$routing.equals(other$routing));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Message;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.id();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        result = result * 59 + this.ttl();
        String $contentType = this.contentType();
        result = result * 59 + ($contentType == null ? 43 : $contentType.hashCode());
        result = result * 59 + Arrays.hashCode(this.payload());
        Map<String, String> $headers = this.headers();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        String $routing = this.routing();
        result = result * 59 + ($routing == null ? 43 : $routing.hashCode());
        return result;
    }

    public String toString() {
        return "Message(id=" + this.id() + ", contentType=" + this.contentType() + ", payload=" + Arrays.toString(this.payload()) + ", headers=" + this.headers() + ", routing=" + this.routing() + ", ttl=" + this.ttl() + ")";
    }

    public Message(long id, String contentType, byte[] payload, Map<String, String> headers, String routing, int ttl) {
        this.id = id;
        this.contentType = contentType;
        this.payload = payload;
        this.headers = headers;
        this.routing = routing;
        this.ttl = ttl;
    }

    public Message() {
    }

    public static IDGenerator idGenerator() {
        return idGenerator;
    }

    public static void idGenerator(IDGenerator idGenerator) {
        Message.idGenerator = idGenerator;
    }

    public static class IDGenerator {
        private static long nextId = 1L;

        public long nextId() {
            return nextId++;
        }
    }
}

